/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.client.render;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;
import net.minecraft.class_837;
import ru.bclib.blockentities.BaseSignBlockEntity;
import ru.bclib.blocks.BaseSignBlock;

public class BaseSignBlockEntityRenderer
implements class_827<BaseSignBlockEntity> {
    private static final HashMap<class_2248, class_1921> RENDER_TYPES = Maps.newHashMap();
    private static final int OUTLINE_RENDER_DISTANCE = class_3532.method_34954((int)16);
    private static final class_1921 RENDER_TYPE = class_1921.method_23572((class_2960)new class_2960("textures/entity/signs/oak.png"));
    private final class_837.class_4702 model;
    private final class_327 font;

    public BaseSignBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.font = ctx.method_32143();
        this.model = new class_837.class_4702(ctx.method_32140(class_5602.method_32078((class_4719)class_4719.field_21676)));
    }

    public void render(BaseSignBlockEntity signBlockEntity, float tickDelta, class_4587 matrixStack, class_4597 provider, int light, int overlay) {
        int drawLight;
        boolean drawOutlined;
        int drawColor;
        class_2680 state = signBlockEntity.method_11010();
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 0.5, 0.5);
        float angle = -((float)((Integer)state.method_11654((class_2769)class_2508.field_11559) * 360) / 16.0f);
        class_2680 blockState = signBlockEntity.method_11010();
        if (((Boolean)blockState.method_11654((class_2769)BaseSignBlock.FLOOR)).booleanValue()) {
            matrixStack.method_22907(class_1160.field_20705.method_23214(angle));
            this.model.field_21531.field_3665 = true;
        } else {
            matrixStack.method_22907(class_1160.field_20705.method_23214(angle + 180.0f));
            matrixStack.method_22904(0.0, -0.3125, -0.4375);
            this.model.field_21531.field_3665 = false;
        }
        matrixStack.method_22903();
        matrixStack.method_22905(0.6666667f, -0.6666667f, -0.6666667f);
        class_4588 vertexConsumer = BaseSignBlockEntityRenderer.getConsumer(provider, state.method_26204());
        this.model.field_27756.method_22698(matrixStack, vertexConsumer, light, overlay);
        matrixStack.method_22909();
        matrixStack.method_22904(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStack.method_22905(0.010416667f, -0.010416667f, 0.010416667f);
        int m = signBlockEntity.method_16126().method_16357();
        int n = (int)((double)class_1011.method_24033((int)m) * 0.4);
        int o = (int)((double)class_1011.method_24034((int)m) * 0.4);
        int p = (int)((double)class_1011.method_24035((int)m) * 0.4);
        int q = class_1011.method_24031((int)0, (int)p, (int)o, (int)n);
        class_5481[] formattedCharSequences = signBlockEntity.method_33829(class_310.method_1551().method_33883(), component -> {
            List list = this.font.method_1728((class_5348)component, 90);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (signBlockEntity.method_34271()) {
            drawColor = signBlockEntity.method_16126().method_16357();
            drawOutlined = BaseSignBlockEntityRenderer.isOutlineVisible(signBlockEntity, drawColor);
            drawLight = 0xF000F0;
        } else {
            drawColor = m;
            drawOutlined = false;
            drawLight = light;
        }
        for (int s = 0; s < 4; ++s) {
            class_5481 formattedCharSequence = formattedCharSequences[s];
            float t = -this.font.method_30880(formattedCharSequence) / 2;
            if (drawOutlined) {
                this.font.method_37296(formattedCharSequence, t, (float)(s * 10 - 20), drawColor, m, matrixStack.method_23760().method_23761(), provider, drawLight);
                continue;
            }
            this.font.method_22942(formattedCharSequence, t, (float)(s * 10 - 20), drawColor, false, matrixStack.method_23760().method_23761(), provider, false, 0, drawLight);
        }
        matrixStack.method_22909();
    }

    private static boolean isOutlineVisible(BaseSignBlockEntity signBlockEntity, int i) {
        if (i == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        class_746 localPlayer = minecraft.field_1724;
        if (localPlayer != null && minecraft.field_1690.method_31044().method_31034() && localPlayer.method_31550()) {
            return true;
        }
        class_1297 entity = minecraft.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)signBlockEntity.method_11016())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    public static class_4719 getSignType(class_2248 block) {
        class_4719 signType2 = block instanceof class_2478 ? ((class_2478)block).method_24025() : class_4719.field_21676;
        return signType2;
    }

    public static class_4730 getModelTexture(class_2248 block) {
        return class_4722.method_33082((class_4719)BaseSignBlockEntityRenderer.getSignType(block));
    }

    public static class_4588 getConsumer(class_4597 provider, class_2248 block) {
        return provider.getBuffer(RENDER_TYPES.getOrDefault(block, RENDER_TYPE));
    }

    public static void registerRenderLayer(class_2248 block) {
        class_2960 blockId = class_2378.field_11146.method_10221((Object)block);
        class_1921 layer = class_1921.method_23572((class_2960)new class_2960(blockId.method_12836(), "textures/entity/sign/" + blockId.method_12832() + ".png"));
        RENDER_TYPES.put(block, layer);
    }
}

