/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.blocks;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1100;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3558;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import ru.bclib.api.tag.NamedMineableTags;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.blocks.BaseBlock;
import ru.bclib.client.models.BasePatterns;
import ru.bclib.client.models.ModelsHelper;
import ru.bclib.client.models.PatternsHelper;
import ru.bclib.client.sound.BlockSounds;

public class BaseTerrainBlock
extends BaseBlock {
    private final class_2248 baseBlock;
    private class_2248 pathBlock;

    public BaseTerrainBlock(class_2248 baseBlock, class_3620 color) {
        super(FabricBlockSettings.copyOf((class_4970)baseBlock).materialColor(color).method_9626(BlockSounds.TERRAIN_SOUND).method_9640());
        this.baseBlock = baseBlock;
    }

    public void setPathBlock(class_2248 roadBlock) {
        this.pathBlock = roadBlock;
    }

    public class_2248 getBaseBlock() {
        return this.baseBlock;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.pathBlock != null && TagAPI.isToolWithMineableTag(player.method_6047(), NamedMineableTags.SHOVEL)) {
            world.method_8396(player, pos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
            if (!world.field_9236) {
                world.method_8501(pos, this.pathBlock.method_9564());
                if (!player.method_7337()) {
                    player.method_6047().method_7970(1, world.field_9229, (class_3222)player);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public List<class_1799> getLoot(class_2680 state, class_47.class_48 builder) {
        class_1799 tool = (class_1799)builder.method_308(class_181.field_1229);
        if (tool != null && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)tool) > 0) {
            return Collections.singletonList(new class_1799((class_1935)this));
        }
        return Collections.singletonList(new class_1799((class_1935)this.getBaseBlock()));
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        if (random.nextInt(16) == 0 && !this.canStay(state, (class_4538)world, pos)) {
            world.method_8501(pos, this.getBaseBlock().method_9564());
        }
    }

    public boolean canStay(class_2680 state, class_4538 worldView, class_2338 pos) {
        class_2338 blockPos = pos.method_10084();
        class_2680 blockState = worldView.method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_10477) && (Integer)blockState.method_11654((class_2769)class_2488.field_11518) == 1) {
            return true;
        }
        if (blockState.method_26227().method_15761() == 8) {
            return false;
        }
        int i = class_3558.method_20049((class_1922)worldView, (class_2680)state, (class_2338)pos, (class_2680)blockState, (class_2338)blockPos, (class_2350)class_2350.field_11036, (int)blockState.method_26193((class_1922)worldView, blockPos));
        return i < 5;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        return this.getBlockModel(blockId, this.method_9564());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        class_2960 baseId = class_2378.field_11146.method_10221((Object)this.getBaseBlock());
        String modId = blockId.method_12836();
        String path = blockId.method_12832();
        String bottom = baseId.method_12836() + ":block/" + baseId.method_12832();
        HashMap textures = Maps.newHashMap();
        textures.put("%top%", modId + ":block/" + path + "_top");
        textures.put("%side%", modId + ":block/" + path + "_side");
        textures.put("%bottom%", bottom);
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_TOP_SIDE_BOTTOM, textures);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832());
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createRandomTopModel(modelId);
    }
}

