/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.tag;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.tag.CommonBlockTags;
import ru.bclib.api.tag.CommonItemTags;
import ru.bclib.mixin.common.DiggerItemAccessor;

public class TagAPI {
    private static final Map<class_2960, Set<class_2960>> TAGS_BLOCK = Maps.newConcurrentMap();
    private static final Map<class_2960, Set<class_2960>> TAGS_ITEM = Maps.newConcurrentMap();
    private static final Map<class_2960, Set<class_2960>> TAGS_BIOME = Maps.newConcurrentMap();

    public static <T> class_6862<T> makeTag(class_2378<T> registry, TagLocation<T> id) {
        return registry.method_40273().filter(tagKey -> tagKey.comp_327().equals((Object)id)).findAny().orElse(class_6862.method_40092((class_5321)registry.method_30517(), id));
    }

    public static class_6862<class_1959> makeBiomeTag(String modID, String name) {
        return class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(modID, name));
    }

    public static class_6862<class_2248> makeBlockTag(String modID, String name) {
        return TagAPI.makeTag(class_2378.field_11146, new TagLocation(modID, name));
    }

    public static class_6862<class_2248> makeBlockTag(class_2960 id) {
        return TagAPI.makeTag(class_2378.field_11146, new TagLocation(id));
    }

    public static class_6862<class_1792> makeItemTag(String modID, String name) {
        return TagAPI.makeTag(class_2378.field_11142, new TagLocation(modID, name));
    }

    public static class_6862<class_1792> makeItemTag(class_2960 id) {
        return TagAPI.makeTag(class_2378.field_11142, new TagLocation(id));
    }

    public static class_6862<class_2248> makeCommonBlockTag(String name) {
        return TagAPI.makeTag(class_2378.field_11146, new TagLocation("c", name));
    }

    public static class_6862<class_1792> makeCommonItemTag(String name) {
        return TagAPI.makeTag(class_2378.field_11142, new TagLocation("c", name));
    }

    public static void init() {
        TagAPI.addBlockTag(CommonBlockTags.BOOKSHELVES, class_2246.field_10504);
        TagAPI.addBlockTag(CommonBlockTags.CHEST, class_2246.field_10034);
        TagAPI.addItemTag(CommonItemTags.CHEST, new class_1935[]{class_1802.field_8106});
        TagAPI.addItemTag(CommonItemTags.IRON_INGOTS, new class_1935[]{class_1802.field_8620});
        TagAPI.addItemTag(CommonItemTags.FURNACES, new class_1935[]{class_2246.field_10181});
    }

    @SafeVarargs
    public static void addBiomeTags(class_1959 biome, TagLocation<class_1959> ... tagIDs) {
        for (TagLocation<class_1959> tagID : tagIDs) {
            TagAPI.addBiomeTagUntyped(tagID, biome);
        }
    }

    public static void addBiomeTag(TagLocation<class_1959> tagID, class_1959 ... biomes) {
        TagAPI.addBiomeTagUntyped(tagID, biomes);
    }

    public static void addBiomeTag(class_6862<class_1959> tagID, class_1959 ... biomes) {
        TagAPI.addBiomeTagUntyped(tagID.comp_327(), biomes);
    }

    protected static void addBiomeTagUntyped(class_2960 tagID, class_1959 ... biomes) {
        Set set = TAGS_BIOME.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_1959 biome : biomes) {
            class_2960 id = BiomeAPI.getBiomeID(biome);
            if (id == null) continue;
            set.add(id);
        }
    }

    @SafeVarargs
    public static void addBlockTags(class_2248 block, TagLocation<class_2248> ... tagIDs) {
        for (TagLocation<class_2248> tagID : tagIDs) {
            TagAPI.addBlockTagUntyped(tagID, block);
        }
    }

    public static void addBlockTag(TagLocation<class_2248> tagID, class_2248 ... blocks) {
        TagAPI.addBlockTagUntyped(tagID, blocks);
    }

    public static void addBlockTag(class_6862<class_2248> tagID, class_2248 ... blocks) {
        TagAPI.addBlockTagUntyped(tagID.comp_327(), blocks);
    }

    protected static void addBlockTagUntyped(class_2960 tagID, class_2248 ... blocks) {
        Set set = TAGS_BLOCK.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_2248 block : blocks) {
            class_2960 id = class_2378.field_11146.method_10221((Object)block);
            if (id == class_2378.field_11146.method_10137()) continue;
            set.add(id);
        }
    }

    @SafeVarargs
    public static void addItemTags(class_1935 item, TagLocation<class_1792> ... tagIDs) {
        for (TagLocation<class_1792> tagID : tagIDs) {
            TagAPI.addItemTagUntyped(tagID, item);
        }
    }

    public static void addItemTag(TagLocation<class_1792> tagID, class_1935 ... items) {
        TagAPI.addItemTagUntyped(tagID, items);
    }

    public static void addItemTag(class_6862<class_1792> tagID, class_1935 ... items) {
        TagAPI.addItemTagUntyped(tagID.comp_327(), items);
    }

    protected static void addItemTagUntyped(class_2960 tagID, class_1935 ... items) {
        Set set = TAGS_ITEM.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_1935 item : items) {
            class_2960 id = class_2378.field_11142.method_10221((Object)item.method_8389());
            if (id == class_2378.field_11142.method_10137()) continue;
            set.add(id);
        }
    }

    public static <T> Map<class_2960, class_3494.class_3495> apply(String directory, Map<class_2960, class_3494.class_3495> tagsMap) {
        BiConsumer<class_2960, Set> consumer = (id, ids) -> TagAPI.apply(tagsMap.computeIfAbsent((class_2960)id, key -> class_3494.class_3495.method_26778()), ids);
        if ("tags/blocks".equals(directory)) {
            TAGS_BLOCK.forEach(consumer);
        } else if ("tags/items".equals(directory)) {
            TAGS_ITEM.forEach(consumer);
        } else if ("tags/worldgen/biome".equals(directory)) {
            TAGS_BIOME.forEach(consumer);
        }
        return tagsMap;
    }

    public static class_3494.class_3495 apply(class_3494.class_3495 builder, Set<class_2960> ids) {
        ids.forEach(value -> builder.method_26784(value, "BCLib Code"));
        return builder;
    }

    public static boolean isToolWithMineableTag(class_1799 stack, class_6862<class_2248> tag) {
        return TagAPI.isToolWithUntypedMineableTag(stack, tag.comp_327());
    }

    public static boolean isToolWithMineableTag(class_1799 stack, TagLocation<class_2248> tag) {
        return TagAPI.isToolWithUntypedMineableTag(stack, tag);
    }

    private static boolean isToolWithUntypedMineableTag(class_1799 stack, class_2960 tag) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof DiggerItemAccessor) {
            DiggerItemAccessor dig = (DiggerItemAccessor)class_17922;
            return dig.bclib_getBlockTag().comp_327().equals((Object)tag);
        }
        return false;
    }

    public static class TagLocation<T>
    extends class_2960 {
        public TagLocation(String string) {
            super(string);
        }

        public TagLocation(String string, String string2) {
            super(string, string2);
        }

        public TagLocation(class_2960 location) {
            super(location.method_12836(), location.method_12832());
        }

        public static <R> TagLocation<R> of(class_6862<R> tag) {
            return new TagLocation(tag.comp_327());
        }
    }
}

