/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.dataexchange.handler.autosync;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import ru.bclib.BCLib;
import ru.bclib.api.dataexchange.DataHandler;
import ru.bclib.api.dataexchange.FileHash;
import ru.bclib.api.dataexchange.handler.autosync.AutoSync;
import ru.bclib.api.dataexchange.handler.autosync.AutoSyncID;
import ru.bclib.config.Configs;
import ru.bclib.util.PathUtil;

public class SyncFolderDescriptor {
    @NotNull
    public final String folderID;
    public final boolean removeAdditionalFiles;
    @NotNull
    public final Path localFolder;
    private List<SubFile> fileCache;

    public SyncFolderDescriptor(String folderID, Path localFolder, boolean removeAdditionalFiles) {
        this.removeAdditionalFiles = removeAdditionalFiles;
        this.folderID = folderID;
        this.localFolder = localFolder;
        this.fileCache = null;
    }

    public String toString() {
        return "SyncFolderDescriptor{folderID='" + this.folderID + "', removeAdditionalFiles=" + this.removeAdditionalFiles + ", localFolder=" + this.localFolder + ", files=" + (Serializable)(this.fileCache == null ? "?" : Integer.valueOf(this.fileCache.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            return this.folderID.equals(o);
        }
        if (o instanceof AutoSyncID.ForDirectFileRequest) {
            return this.folderID.equals(((AutoSyncID.ForDirectFileRequest)o).uniqueID);
        }
        if (!(o instanceof SyncFolderDescriptor)) {
            return false;
        }
        SyncFolderDescriptor that = (SyncFolderDescriptor)o;
        return this.folderID.equals(that.folderID);
    }

    public int hashCode() {
        return this.folderID.hashCode();
    }

    public int fileCount() {
        return this.fileCache == null ? 0 : this.fileCache.size();
    }

    public void invalidateCache() {
        this.fileCache = null;
    }

    public void loadCache() {
        if (this.fileCache == null) {
            this.fileCache = new ArrayList<SubFile>(8);
            PathUtil.fileWalker(this.localFolder.toFile(), p -> this.fileCache.add(new SubFile(this.localFolder.relativize((Path)p).toString(), FileHash.create(p.toFile()))));
        }
    }

    public void serialize(class_2540 buf) {
        boolean debugHashes = Configs.CLIENT_CONFIG.getBoolean("auto_sync", "debugHashes", false);
        this.loadCache();
        DataHandler.writeString(buf, this.folderID);
        buf.writeBoolean(this.removeAdditionalFiles);
        buf.writeInt(this.fileCache.size());
        this.fileCache.forEach(fl -> {
            BCLib.LOGGER.info("\t  - " + fl.relPath);
            if (debugHashes) {
                BCLib.LOGGER.info("\t\t" + fl.hash);
            }
            fl.serialize(buf);
        });
    }

    public static SyncFolderDescriptor deserialize(class_2540 buf) {
        SyncFolderDescriptor desc;
        String folderID = DataHandler.readString(buf);
        boolean remAddFiles = buf.readBoolean();
        int count = buf.readInt();
        SyncFolderDescriptor localDescriptor = AutoSync.getSyncFolderDescriptor(folderID);
        if (localDescriptor != null) {
            desc = new SyncFolderDescriptor(folderID, localDescriptor.localFolder, localDescriptor.removeAdditionalFiles && remAddFiles);
            desc.fileCache = new ArrayList<SubFile>(count);
        } else {
            BCLib.LOGGER.warning((String)(BCLib.isClient() ? "Client" : "Server does not know Sync-Folder ID '" + folderID + "'"), new Object[0]);
            desc = null;
        }
        for (int i = 0; i < count; ++i) {
            SubFile relPath = SubFile.deserialize(buf);
            if (desc == null) continue;
            desc.fileCache.add(relPath);
        }
        return desc;
    }

    boolean hasRelativeFile(String relFile) {
        return this.fileCache.stream().filter(sf -> sf.equals(relFile)).findFirst().isPresent();
    }

    boolean hasRelativeFile(SubFile subFile) {
        return this.hasRelativeFile(subFile.relPath);
    }

    SubFile getLocalSubFile(String relPath) {
        return this.fileCache.stream().filter(sf -> sf.relPath.equals(relPath)).findFirst().orElse(null);
    }

    Stream<SubFile> relativeFilesStream() {
        this.loadCache();
        return this.fileCache.stream();
    }

    public Path mapAbsolute(String relPath) {
        return this.localFolder.resolve(relPath).normalize();
    }

    public Path mapAbsolute(SubFile subFile) {
        return this.localFolder.resolve(subFile.relPath).normalize();
    }

    public boolean acceptChildElements(Path absPath) {
        return PathUtil.isChildOf(this.localFolder, absPath);
    }

    public boolean acceptChildElements(SubFile subFile) {
        return this.acceptChildElements(this.mapAbsolute(subFile));
    }

    public boolean discardChildElements(SubFile subFile) {
        return !this.acceptChildElements(subFile);
    }

    static class SubFile {
        public final String relPath;
        public final FileHash hash;

        SubFile(String relPath, FileHash hash) {
            this.relPath = relPath;
            this.hash = hash;
        }

        public String toString() {
            return this.relPath;
        }

        public void serialize(class_2540 buf) {
            DataHandler.writeString(buf, this.relPath);
            this.hash.serialize(buf);
        }

        public static SubFile deserialize(class_2540 buf) {
            String relPath = DataHandler.readString(buf);
            FileHash hash = FileHash.deserialize(buf);
            return new SubFile(relPath, hash);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof String) {
                return this.relPath.equals(o);
            }
            if (!(o instanceof SubFile)) {
                return false;
            }
            SubFile subFile = (SubFile)o;
            return this.relPath.equals(subFile.relPath);
        }

        public int hashCode() {
            return this.relPath.hashCode();
        }
    }
}

