/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib;

import net.minecraft.class_2487;
import net.minecraft.class_2520;
import ru.bclib.api.datafixer.ForcedLevelPatch;
import ru.bclib.api.datafixer.MigrationProfile;
import ru.bclib.world.generator.GeneratorOptions;

final class BiomeSourcePatch
extends ForcedLevelPatch {
    private static final String NETHER_BIOME_SOURCE = "bclib:nether_biome_source";
    private static final String END_BIOME_SOURCE = "bclib:end_biome_source";
    private static final String MC_NETHER = "minecraft:the_nether";
    private static final String MC_END = "minecraft:the_end";

    protected BiomeSourcePatch() {
        super("bclib", "1.2.1");
    }

    @Override
    protected Boolean runLevelDatPatch(class_2487 root, MigrationProfile profile) {
        class_2487 dimRoot;
        class_2487 worldGenSettings = root.method_10562("Data").method_10562("WorldGenSettings");
        class_2487 dimensions = worldGenSettings.method_10562("dimensions");
        long seed = worldGenSettings.method_10537("seed");
        boolean result = false;
        if (!(!GeneratorOptions.fixNetherBiomeSource() || dimensions.method_10545(MC_NETHER) && this.isBCLibEntry(dimensions.method_10562(MC_NETHER)))) {
            dimRoot = new class_2487();
            dimRoot.method_10566("generator", (class_2520)BiomeSourcePatch.makeNetherGenerator(seed));
            dimRoot.method_10582("type", MC_NETHER);
            dimensions.method_10566(MC_NETHER, (class_2520)dimRoot);
            result = true;
        }
        if (!(!GeneratorOptions.fixEndBiomeSource() || dimensions.method_10545(MC_END) && this.isBCLibEntry(dimensions.method_10562(MC_END)))) {
            dimRoot = new class_2487();
            dimRoot.method_10566("generator", (class_2520)BiomeSourcePatch.makeEndGenerator(seed));
            dimRoot.method_10582("type", MC_END);
            dimensions.method_10566(MC_END, (class_2520)dimRoot);
            result = true;
        }
        return result;
    }

    private boolean isBCLibEntry(class_2487 dimRoot) {
        String type = dimRoot.method_10562("generator").method_10562("biome_source").method_10558("type");
        if (type.isEmpty() || type.length() < 5) {
            return false;
        }
        return type.startsWith("bclib");
    }

    public static class_2487 makeNetherGenerator(long seed) {
        class_2487 generator = new class_2487();
        generator.method_10582("type", "minecraft:noise");
        generator.method_10582("settings", "minecraft:nether");
        generator.method_10544("seed", seed);
        class_2487 biomeSource = new class_2487();
        biomeSource.method_10582("type", NETHER_BIOME_SOURCE);
        biomeSource.method_10544("seed", seed);
        generator.method_10566("biome_source", (class_2520)biomeSource);
        return generator;
    }

    public static class_2487 makeEndGenerator(long seed) {
        class_2487 generator = new class_2487();
        generator.method_10582("type", "minecraft:noise");
        generator.method_10582("settings", "minecraft:end");
        generator.method_10544("seed", seed);
        class_2487 biomeSource = new class_2487();
        biomeSource.method_10582("type", END_BIOME_SOURCE);
        biomeSource.method_10544("seed", seed);
        generator.method_10566("biome_source", (class_2520)biomeSource);
        return generator;
    }
}

