/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3233;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;

public class PollenPilingProcessor
extends class_3491 {
    public static final Codec<PollenPilingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("xz_scale").forGetter(config -> Float.valueOf(config.xzScale)), (App)Codec.FLOAT.fieldOf("y_scale").forGetter(config -> Float.valueOf(config.yScale)), (App)Codec.BOOL.fieldOf("pollen_replace_solids").forGetter(config -> config.pollenReplaceSolids)).apply((Applicative)instance, instance.stable(PollenPilingProcessor::new)));
    private final float xzScale;
    private final float yScale;
    private final boolean pollenReplaceSolids;
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public PollenPilingProcessor(float xzScale, float yScale, boolean pollenReplaceSolids) {
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.pollenReplaceSolids = pollenReplaceSolids;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public class_3499.class_3501 method_15110(class_4538 worldView, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 structurePlacementData) {
        class_2338 abovePos;
        class_2680 aboveState;
        class_2791 chunk;
        this.setSeed(worldView instanceof class_3233 ? ((class_3233)worldView).method_8412() : 0L);
        class_3499.class_3501 structureBlockInfoToReturn = structureBlockInfoWorld;
        class_2680 structureState = structureBlockInfoToReturn.field_15596;
        class_2338 worldPos = structureBlockInfoToReturn.field_15597;
        if (structureState.method_27852(BzBlocks.PILE_OF_POLLEN)) {
            if (!this.pollenReplaceSolids && !worldView.method_8320(worldPos).method_26215()) {
                return null;
            }
            class_2338 belowPos = worldPos.method_10074();
            if (belowPos.method_10264() <= worldView.method_31607() || belowPos.method_10264() >= worldView.method_31600()) {
                return null;
            }
            chunk = worldView.method_22350(belowPos);
            class_2680 belowState = chunk.method_8320(belowPos);
            if (!belowState.method_26225()) {
                ((class_1936)worldView).method_39279(belowPos, structureState.method_26204(), 0);
            }
            class_2338.class_2339 sidePos = new class_2338.class_2339();
            for (class_2350 direction : class_2350.values()) {
                sidePos.method_10101((class_2382)worldPos).method_10098(direction);
                if (!worldView.method_8320((class_2338)sidePos).method_26227().method_15771()) continue;
                return new class_3499.class_3501(worldPos, BzBlocks.FILLED_POROUS_HONEYCOMB.method_9564(), null);
            }
            double noiseVal = this.noiseGenerator.noise3_Classic((float)worldPos.method_10263() * this.xzScale, (float)worldPos.method_10264() * this.yScale, (float)worldPos.method_10260() * this.xzScale);
            int layerHeight = Math.max(0, (int)((noiseVal / 2.0 + 0.5) * 2.5));
            layerHeight = Math.min(8, layerHeight + (Integer)structureState.method_11654((class_2769)PileOfPollen.LAYERS));
            structureBlockInfoToReturn = new class_3499.class_3501(worldPos, (class_2680)structureState.method_11657((class_2769)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(layerHeight)), structureBlockInfoToReturn.field_15595);
        }
        if (!structureState.method_26225() && (aboveState = (chunk = worldView.method_22350(abovePos = worldPos.method_10084())).method_8320(abovePos)).method_27852(BzBlocks.PILE_OF_POLLEN)) {
            ((class_1936)worldView).method_39279(abovePos, aboveState.method_26204(), 0);
        }
        return structureBlockInfoToReturn;
    }

    protected class_3828<?> method_16772() {
        return BzProcessors.POLLEN_PILING_PROCESSOR;
    }
}

