/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla;

import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.BigContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyArea;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.PixelTransformer;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.class_3756;
import net.minecraft.class_4540;
import net.minecraft.class_5819;
import net.minecraft.class_5820;

public class LazyAreaContext
implements BigContext<LazyArea> {
    private static final int MAX_CACHE = 1024;
    private final Long2IntLinkedOpenHashMap cache;
    private final int maxCache;
    private final class_3756 biomeNoise;
    private final long seed;
    private long rval;

    public LazyAreaContext(int maxCache, long seed1, long seed2) {
        this.seed = LazyAreaContext.mixSeed(seed1, seed2);
        this.biomeNoise = new class_3756((class_5819)new class_5820(seed1));
        this.cache = new Long2IntLinkedOpenHashMap(16, 0.25f);
        this.cache.defaultReturnValue(Integer.MIN_VALUE);
        this.maxCache = maxCache;
    }

    @Override
    public LazyArea createResult(PixelTransformer pixelTransformer) {
        return new LazyArea(this.cache, this.maxCache, pixelTransformer);
    }

    @Override
    public LazyArea createResult(PixelTransformer pixelTransformer, LazyArea lazyArea) {
        return new LazyArea(this.cache, Math.min(1024, lazyArea.getMaxCache() * 4), pixelTransformer);
    }

    @Override
    public LazyArea createResult(PixelTransformer pixelTransformer, LazyArea lazyArea, LazyArea lazyArea2) {
        return new LazyArea(this.cache, Math.min(1024, Math.max(lazyArea.getMaxCache(), lazyArea2.getMaxCache()) * 4), pixelTransformer);
    }

    @Override
    public void initRandom(long l, long m) {
        long n = this.seed;
        n = class_4540.method_22372((long)n, (long)l);
        n = class_4540.method_22372((long)n, (long)m);
        n = class_4540.method_22372((long)n, (long)l);
        this.rval = n = class_4540.method_22372((long)n, (long)m);
    }

    @Override
    public int nextRandom(int i) {
        int j = Math.floorMod(this.rval >> 24, i);
        this.rval = class_4540.method_22372((long)this.rval, (long)this.seed);
        return j;
    }

    @Override
    public class_3756 getBiomeNoise() {
        return this.biomeNoise;
    }

    private static long mixSeed(long l, long m) {
        long n = class_4540.method_22372((long)m, (long)m);
        n = class_4540.method_22372((long)n, (long)m);
        n = class_4540.method_22372((long)n, (long)m);
        long o = class_4540.method_22372((long)l, (long)n);
        o = class_4540.method_22372((long)o, (long)n);
        return class_4540.method_22372((long)o, (long)n);
    }
}

