/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.components.EntityComponent;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzDimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class BzWorldSavedData
extends class_18 {
    private static final String TELEPORTATION_DATA = "the_bumblezoneteleportation";
    private static final BzWorldSavedData CLIENT_DUMMY = new BzWorldSavedData(null);
    private static final List<Pair<class_1297, class_5321<class_1937>>> QUEUED_ENTITIES_TO_TELEPORT = new ArrayList<Pair<class_1297, class_5321<class_1937>>>();

    public BzWorldSavedData(class_2487 tag) {
    }

    public static BzWorldSavedData get(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return CLIENT_DUMMY;
        }
        class_26 storage = ((class_3218)world).method_17983();
        return (BzWorldSavedData)storage.method_20786(BzWorldSavedData::new, TELEPORTATION_DATA);
    }

    public class_2487 method_75(class_2487 data) {
        return null;
    }

    public static void queueEntityToTeleport(class_1297 entity, class_5321<class_1937> destination) {
        if (!BzWorldSavedData.isEntityQueuedToTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_TELEPORT.add((Pair<class_1297, class_5321<class_1937>>)Pair.of((Object)entity, destination));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(class_1297 entity) {
        return QUEUED_ENTITIES_TO_TELEPORT.stream().anyMatch(entry -> ((class_1297)entry.getFirst()).equals((Object)entity));
    }

    public static void tick(class_3218 world) {
        if (QUEUED_ENTITIES_TO_TELEPORT.size() == 0) {
            return;
        }
        HashSet<class_1297> teleportedEntities = new HashSet<class_1297>();
        for (Pair<class_1297, class_5321<class_1937>> entry2 : QUEUED_ENTITIES_TO_TELEPORT) {
            class_1297 entity = (class_1297)entry2.getFirst();
            if (teleportedEntities.contains(entity)) continue;
            class_5321 destinationKey = (class_5321)entry2.getSecond();
            class_3218 destination = world.method_8410().method_8503().method_3847(destinationKey);
            if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                BzWorldSavedData.enteringBumblezone(entity, teleportedEntities);
                continue;
            }
            if (entity.method_5642() != null) {
                BzWorldSavedData.exitingBumblezone(entity.method_5642(), destination, teleportedEntities);
                continue;
            }
            BzWorldSavedData.exitingBumblezone(entity, destination, teleportedEntities);
        }
        QUEUED_ENTITIES_TO_TELEPORT.removeIf(entry -> teleportedEntities.contains(entry.getFirst()));
    }

    public static void enteringBumblezone(class_1297 entity, Set<class_1297> teleportedEntities) {
        if (!entity.field_6002.method_8608()) {
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).setNonBZPos(entity.method_19538());
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).setNonBZDimension(entity.field_6002.method_27983().method_29177());
            MinecraftServer minecraftServer = entity.method_5682();
            class_3218 bumblezoneWorld = minecraftServer.method_3847(BzDimension.BZ_WORLD_KEY);
            if (bumblezoneWorld == null) {
                if (entity instanceof class_3222) {
                    class_3222 playerEntity = (class_3222)entity;
                    Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                    class_2585 message = new class_2585("Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: \u00a76https://bugs.mojang.com/browse/MC-195468\u00a7f. A restart will fix this.");
                    playerEntity.method_7353((class_2561)message, true);
                }
                return;
            }
            class_243 destinationPosition = EntityTeleportationBackend.getBzCoordinate(entity, (class_3218)entity.field_6002, bumblezoneWorld);
            class_1297 baseVehicle = entity.method_5668();
            BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, bumblezoneWorld, destinationPosition, teleportedEntities);
            ((class_3218)entity.field_6002).method_14197();
            bumblezoneWorld.method_14197();
        }
    }

    public static void exitingBumblezone(class_1297 entity, class_3218 destination, Set<class_1297> teleportedEntities) {
        boolean upwardChecking = entity.method_23318() > 0.0;
        class_243 destinationPosition = EntityTeleportationBackend.destPostFromOutOfBoundsTeleport(entity, destination, upwardChecking);
        if (destinationPosition == null) {
            ((class_3222)entity).method_7353((class_2561)new class_2585("Error teleporting out of Bumblezone. destinationPosition is null. Report to Bumblezone dev pls."), true);
        }
        class_1297 baseVehicle = entity.method_5668();
        BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, destination, destinationPosition, teleportedEntities);
        ((class_3218)entity.field_6002).method_14197();
        destination.method_14197();
    }

    private static void teleportEntityAndAssignToVehicle(class_1297 entity, class_1297 vehicle, class_3218 destination, class_243 destinationPosition, Set<class_1297> teleportedEntities) {
        class_1657 teleportedEntity;
        List passengers = entity.method_5685();
        entity.method_5772();
        entity.method_30229();
        if (destination.method_27983().equals(BzDimension.BZ_WORLD_KEY)) {
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).setNonBZPos(entity.method_19538());
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).setNonBZDimension(entity.field_6002.method_27983().method_29177());
        }
        if (entity instanceof class_3222) {
            if (destination.method_27983().equals(BzDimension.BZ_WORLD_KEY)) {
                ((class_3222)entity).method_7353((class_2561)new class_2585("Teleporting into the Bumblezone..."), true);
            } else {
                ((class_3222)entity).method_7353((class_2561)new class_2585("Teleporting out of Bumblezone..."), true);
            }
            if (((class_3222)entity).method_6113()) {
                ((class_3222)entity).method_7358(true, true);
            }
            ((class_3222)entity).method_14251(destination, destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.method_36454(), entity.method_36455());
            teleportedEntity = destination.method_18470(entity.method_5667());
        } else {
            class_1297 newEntity = entity;
            if ((newEntity = newEntity.method_5864().method_5883((class_1937)destination)) == null) {
                return;
            }
            entity.method_5808(destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.method_36454(), entity.method_36455());
            newEntity.method_5878(entity);
            newEntity.method_5808(destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.method_36454(), entity.method_36455());
            destination.method_18769(newEntity);
            teleportedEntity = newEntity;
            entity.method_5650(class_1297.class_5529.field_27002);
        }
        if (teleportedEntity != null) {
            teleportedEntities.add(entity);
            class_1923 chunkpos = new class_1923(new class_2338(destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350));
            destination.method_14178().method_17297(class_3230.field_19347, chunkpos, 1, (Object)entity.method_5628());
            if (vehicle != null) {
                teleportedEntity.method_5804(vehicle);
            }
            if (teleportedEntity instanceof class_1309) {
                BzWorldSavedData.reAddStatusEffect((class_1309)teleportedEntity);
            }
            passengers.forEach(arg_0 -> BzWorldSavedData.lambda$teleportEntityAndAssignToVehicle$2((class_1297)teleportedEntity, destination, destinationPosition, teleportedEntities, arg_0));
        }
    }

    private static void reAddStatusEffect(class_1309 livingEntity) {
        ArrayList effectInstanceList = new ArrayList(livingEntity.method_6026());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            class_1293 effectInstance = (class_1293)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            livingEntity.method_6016(effectInstance.method_5579());
            livingEntity.method_6092(new class_1293(effectInstance.method_5579(), effectInstance.method_5584(), effectInstance.method_5578(), effectInstance.method_5591(), effectInstance.method_5581(), effectInstance.method_5592()));
        }
    }

    private static /* synthetic */ void lambda$teleportEntityAndAssignToVehicle$2(class_1297 teleportedEntity, class_3218 destination, class_243 destinationPosition, Set teleportedEntities, class_1297 passenger) {
        BzWorldSavedData.teleportEntityAndAssignToVehicle(passenger, teleportedEntity, destination, destinationPosition, teleportedEntities);
    }
}

