/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseChunkAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseGeneratorSettingsInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.WorldSeedHolder;
import com.telepathicgrunt.the_bumblezone.world.dimension.BiomeInfluencedNoiseSampler;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5483;
import net.minecraft.class_5539;
import net.minecraft.class_5817;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5868;
import net.minecraft.class_5873;
import net.minecraft.class_6012;
import net.minecraft.class_6350;
import net.minecraft.class_6544;
import net.minecraft.class_6568;
import net.minecraft.class_6673;
import net.minecraft.class_6724;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_7059;
import org.jetbrains.annotations.Nullable;

public class BzChunkGenerator
extends class_2794 {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_37227).forGetter(bzChunkGenerator -> bzChunkGenerator.field_37053), (App)class_6903.method_40419((class_5321)class_2378.field_35433).forGetter(bzChunkGenerator -> bzChunkGenerator.noises), (App)class_1966.field_24713.fieldOf("biome_source").forGetter(bzChunkGenerator -> bzChunkGenerator.field_12761), (App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).stable().forGetter(bzChunkGenerator -> bzChunkGenerator.seed), (App)class_5284.field_24781.fieldOf("settings").forGetter(bzChunkGenerator -> bzChunkGenerator.settings), (App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(bzChunkGenerator -> bzChunkGenerator.biomeRegistry), (App)class_6903.method_40419((class_5321)class_2378.field_25915).forGetter(bzChunkGenerator -> bzChunkGenerator.configuredStructureFeaturesRegistry)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    private static final class_2680[] EMPTY_COLUMN = new class_2680[0];
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultFluid;
    private final class_2378<class_5216.class_5487> noises;
    private final long seed;
    protected final class_6880<class_5284> settings;
    private final class_6953 router;
    private final class_6544.class_6552 sampler;
    private final class_2378<class_1959> biomeRegistry;
    private final class_2378<class_5312<?, ?>> configuredStructureFeaturesRegistry;
    private final class_6724 surfaceSystem;
    private final class_6350.class_6565 globalFluidPicker;
    private static final class_5483.class_1964 INITIAL_HONEY_SLIME_ENTRY = new class_5483.class_1964(BzEntities.HONEY_SLIME, 1, 1, 3);
    private static final class_5483.class_1964 INITIAL_BEE_ENTRY = new class_5483.class_1964(class_1299.field_20346, 1, 1, 4);
    private static final class_5483.class_1964 INITIAL_BEEHEMOTH_ENTRY = new class_5483.class_1964(BzEntities.BEEHEMOTH, 1, 1, 1);

    public BzChunkGenerator(class_2378<class_7059> structureSetRegistry, class_2378<class_5216.class_5487> parametersRegistry, class_1966 biomeSource, long seed, class_6880<class_5284> supplier, class_2378<class_1959> biomeRegistry, class_2378<class_5312<?, ?>> configuredStructureFeaturesRegistry) {
        this(structureSetRegistry, parametersRegistry, biomeSource, biomeSource, seed, supplier, biomeRegistry, configuredStructureFeaturesRegistry);
    }

    private BzChunkGenerator(class_2378<class_7059> structureSetRegistry, class_2378<class_5216.class_5487> parametersRegistry, class_1966 biomeSource, class_1966 biomeSource2, long seed, class_6880<class_5284> supplier, class_2378<class_1959> biomeRegistry, class_2378<class_5312<?, ?>> configuredStructureFeaturesRegistry) {
        super(structureSetRegistry, Optional.empty(), biomeSource, biomeSource2, seed);
        this.noises = parametersRegistry;
        this.seed = seed;
        this.settings = supplier;
        this.biomeRegistry = biomeRegistry;
        class_5284 noiseGeneratorSettings = (class_5284)this.settings.comp_349();
        this.defaultBlock = noiseGeneratorSettings.comp_475();
        this.defaultFluid = noiseGeneratorSettings.comp_476();
        class_6953 noiseRouter = noiseGeneratorSettings.method_41099(parametersRegistry, seed);
        this.sampler = new class_6544.class_6552(noiseRouter.comp_420(), noiseRouter.comp_421(), noiseRouter.comp_484(), noiseRouter.comp_423(), noiseRouter.comp_424(), noiseRouter.comp_485(), noiseRouter.comp_431());
        class_6910 newFinalDensity = class_6916.method_40486((class_6910)new BiomeNoise(this.method_38276(), this.biomeRegistry, this.method_12098()), (class_6910)noiseRouter.comp_487());
        newFinalDensity = class_6916.method_40483((class_6910)newFinalDensity);
        newFinalDensity = class_6916.method_40486((class_6910)new RoughSurfaceNoise(), (class_6910)newFinalDensity);
        newFinalDensity = class_6916.method_40483((class_6910)newFinalDensity);
        this.router = new class_6953(noiseRouter.comp_414(), noiseRouter.comp_415(), noiseRouter.comp_416(), noiseRouter.comp_417(), noiseRouter.comp_418(), noiseRouter.comp_419(), noiseRouter.comp_420(), noiseRouter.comp_421(), noiseRouter.comp_484(), noiseRouter.comp_423(), noiseRouter.comp_424(), noiseRouter.comp_485(), noiseRouter.comp_486(), newFinalDensity, noiseRouter.comp_428(), noiseRouter.comp_429(), noiseRouter.comp_430(), noiseRouter.comp_431());
        class_6350.class_6351 fluidStatus = new class_6350.class_6351(-54, class_2246.field_10164.method_9564());
        int seaLevel = noiseGeneratorSettings.comp_479();
        class_6350.class_6351 fluidStatus2 = new class_6350.class_6351(seaLevel, noiseGeneratorSettings.comp_476());
        this.globalFluidPicker = (j, k, lx) -> k < Math.min(-54, seaLevel) ? fluidStatus : fluidStatus2;
        this.surfaceSystem = new class_6724(parametersRegistry, this.defaultBlock, seaLevel, seed, noiseGeneratorSettings.method_38999());
        this.configuredStructureFeaturesRegistry = configuredStructureFeaturesRegistry;
    }

    public static void registerChunkGenerator() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)new class_2960("the_bumblezone", "chunk_generator"), CODEC);
    }

    public class_6544.class_6552 method_38276() {
        return this.sampler;
    }

    public void method_12108(class_3233 worldGenRegion, long seed, class_4543 biomeManager, class_5138 structureFeatureManager, class_2791 chunkAccess, class_2893.class_2894 carving) {
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public class_2794 method_27997(long seed) {
        return new BzChunkGenerator((class_2378<class_7059>)this.field_37053, this.noises, this.field_12761.method_27985(seed), seed, this.settings, this.biomeRegistry, this.configuredStructureFeaturesRegistry);
    }

    public boolean stable(long seed, class_5321<class_5284> resourceKey) {
        return this.seed == seed && this.settings.method_40225(resourceKey);
    }

    public int method_16397(int x, int z, class_2902.class_2903 types, class_5539 levelHeightAccessor) {
        class_5309 noiseSettings = ((class_5284)this.settings.comp_349()).comp_474();
        int maxY = Math.max(noiseSettings.comp_173(), levelHeightAccessor.method_31607());
        int minY = Math.min(noiseSettings.comp_173() + noiseSettings.comp_174(), levelHeightAccessor.method_31600());
        int maxYCell = class_3532.method_15346((int)maxY, (int)noiseSettings.method_39545());
        int minYCell = class_3532.method_15346((int)(minY - maxY), (int)noiseSettings.method_39545());
        return minYCell <= 0 ? levelHeightAccessor.method_31607() : this.iterateNoiseColumn(x, z, null, types.method_16402(), maxYCell, minYCell).orElse(levelHeightAccessor.method_31607());
    }

    public class_4966 method_26261(int x, int z, class_5539 levelHeightAccessor) {
        class_5309 noiseSettings = ((class_5284)this.settings.comp_349()).comp_474();
        int minY = Math.max(noiseSettings.comp_173(), levelHeightAccessor.method_31607());
        int maxY = Math.min(noiseSettings.comp_173() + noiseSettings.comp_174(), levelHeightAccessor.method_31600());
        int minYCell = class_3532.method_15346((int)minY, (int)noiseSettings.method_39545());
        int maxYCell = class_3532.method_15346((int)(maxY - minY), (int)noiseSettings.method_39545());
        if (maxYCell <= 0) {
            return new class_4966(minY, EMPTY_COLUMN);
        }
        class_2680[] blockStates = new class_2680[maxYCell * noiseSettings.method_39545()];
        this.iterateNoiseColumn(x, z, blockStates, null, minYCell, maxYCell);
        return new class_4966(minY, blockStates);
    }

    public void method_40450(List<String> list, class_2338 blockPos) {
    }

    private OptionalInt iterateNoiseColumn(int x, int z, @Nullable class_2680[] blockStates, @Nullable Predicate<class_2680> predicate, int minYCell, int maxYCell) {
        class_5309 noiseSettings = ((class_5284)this.settings.comp_349()).comp_474();
        int cellWidth = noiseSettings.method_39546();
        int cellHeight = noiseSettings.method_39545();
        int o = Math.floorDiv(x, cellWidth);
        int p = Math.floorDiv(z, cellWidth);
        int q = Math.floorMod(x, cellWidth);
        int r = Math.floorMod(z, cellWidth);
        int s = o * cellWidth;
        int t = p * cellWidth;
        double d = (double)q / (double)cellWidth;
        double e = (double)r / (double)cellWidth;
        class_6568 noiseChunk = class_6568.method_39542((int)s, (int)t, (int)minYCell, (int)maxYCell, (class_6953)this.router, (class_5284)((class_5284)this.settings.comp_349()), (class_6350.class_6565)this.globalFluidPicker);
        noiseChunk.method_38336();
        noiseChunk.method_38339(0);
        for (int currentYCell = maxYCell - 1; currentYCell >= 0; --currentYCell) {
            noiseChunk.method_38362(currentYCell, 0);
            for (int yInCell = cellHeight - 1; yInCell >= 0; --yInCell) {
                class_2680 blockState2;
                int y = (minYCell + currentYCell) * cellHeight + yInCell;
                double f = (double)yInCell / (double)cellHeight;
                noiseChunk.method_38337(y, f);
                noiseChunk.method_38349(x, d);
                noiseChunk.method_38355(z, e);
                class_2680 blockState = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                class_2680 class_26802 = blockState2 = blockState == null ? this.defaultBlock : blockState;
                if ((blockState == null || blockState.method_26215()) && y < this.method_16398()) {
                    blockState2 = this.defaultFluid;
                }
                if (blockStates != null) {
                    int index = currentYCell * cellHeight + yInCell;
                    blockStates[index] = blockState2;
                }
                if (predicate == null || !predicate.test(blockState2)) continue;
                return OptionalInt.of(y + 1);
            }
        }
        return OptionalInt.empty();
    }

    public void method_12110(class_3233 worldGenRegion, class_5138 structureFeatureManager, class_2791 chunkAccess) {
        if (!class_155.method_37896((class_1923)chunkAccess.method_12004())) {
            class_5868 worldGenerationContext = new class_5868((class_2794)this, (class_5539)worldGenRegion);
            class_5284 noiseGeneratorSettings = (class_5284)this.settings.comp_349();
            class_6568 noiseChunk = chunkAccess.method_38255(this.router, () -> new class_5817(structureFeatureManager, chunkAccess), noiseGeneratorSettings, this.globalFluidPicker, class_6748.method_39342((class_3233)worldGenRegion));
            this.surfaceSystem.method_39106(worldGenRegion.method_22385(), worldGenRegion.method_30349().method_30530(class_2378.field_25114), noiseGeneratorSettings.comp_483(), worldGenerationContext, chunkAccess, noiseChunk, noiseGeneratorSettings.comp_478());
        }
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_5138 structureFeatureManager, class_2791 chunkAccess) {
        class_5309 noiseSettings = ((class_5284)this.settings.comp_349()).comp_474();
        class_5539 levelHeightAccessor = chunkAccess.method_39460();
        int minY = Math.max(noiseSettings.comp_173(), levelHeightAccessor.method_31607());
        int maxY = Math.min(noiseSettings.comp_173() + noiseSettings.comp_174(), levelHeightAccessor.method_31600());
        int minYCell = class_3532.method_15346((int)minY, (int)noiseSettings.method_39545());
        int maxYCell = class_3532.method_15346((int)(maxY - minY), (int)noiseSettings.method_39545());
        if (maxYCell <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int maxChunkSection = chunkAccess.method_31602(maxYCell * noiseSettings.method_39545() - 1 + minY);
        int minChunkSection = chunkAccess.method_31602(minY);
        HashSet set = Sets.newHashSet();
        for (int currentChunkSection = maxChunkSection; currentChunkSection >= minChunkSection; --currentChunkSection) {
            class_2826 levelChunkSection = chunkAccess.method_38259(currentChunkSection);
            levelChunkSection.method_16676();
            set.add(levelChunkSection);
        }
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"wgen_fill_noise", () -> this.doFill(blender, structureFeatureManager, chunkAccess, minYCell, maxYCell)), class_156.method_18349()).whenCompleteAsync((chunkAccessx, throwable) -> {
            for (class_2826 levelChunkSectionx : set) {
                levelChunkSectionx.method_16677();
            }
        }, executor);
    }

    private class_2791 doFill(class_6748 blender, class_5138 structureFeatureManager, class_2791 chunkAccess, int minYCell, int maxYCell) {
        class_5284 noiseGeneratorSettings = (class_5284)this.settings.comp_349();
        class_6568 noiseChunk = chunkAccess.method_38255(this.router, () -> new class_5817(structureFeatureManager, chunkAccess), noiseGeneratorSettings, this.globalFluidPicker, blender);
        class_2902 heightmap = chunkAccess.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmap2 = chunkAccess.method_12032(class_2902.class_2903.field_13194);
        class_1923 chunkPos = chunkAccess.method_12004();
        int k = chunkPos.method_8326();
        int l = chunkPos.method_8328();
        class_6350 aquifer = noiseChunk.method_38354();
        noiseChunk.method_38336();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_5309 noiseSettings = noiseGeneratorSettings.comp_474();
        int m = noiseSettings.method_39546();
        int n = noiseSettings.method_39545();
        int o = 16 / m;
        int p = 16 / m;
        for (int q = 0; q < o; ++q) {
            noiseChunk.method_38339(q);
            for (int r = 0; r < p; ++r) {
                class_2826 levelChunkSection = chunkAccess.method_38259(chunkAccess.method_32890() - 1);
                for (int s = maxYCell - 1; s >= 0; --s) {
                    noiseChunk.method_38362(s, r);
                    for (int t = n - 1; t >= 0; --t) {
                        int yy = (minYCell + s) * n + t;
                        int v = yy & 0xF;
                        int w = chunkAccess.method_31602(yy);
                        if (chunkAccess.method_31602(levelChunkSection.method_12259()) != w) {
                            levelChunkSection = chunkAccess.method_38259(w);
                        }
                        double d = (double)t / (double)n;
                        for (int x = 0; x < m; ++x) {
                            int xx = k + q * m + x;
                            int z = xx & 0xF;
                            double e = (double)x / (double)m;
                            noiseChunk.method_38349(xx, e);
                            for (int aa = 0; aa < m; ++aa) {
                                int zz = l + r * m + aa;
                                int ac = zz & 0xF;
                                double f = (double)aa / (double)m;
                                noiseChunk.method_38355(zz, f);
                                noiseChunk.method_38337(yy, d);
                                class_2680 blockState = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                                if (blockState == null) {
                                    blockState = this.defaultBlock;
                                }
                                if (blockState.method_26215() && yy < this.method_16398()) {
                                    blockState = this.defaultFluid;
                                }
                                if (blockState.method_26215() || class_155.method_37896((class_1923)chunkAccess.method_12004())) continue;
                                if (blockState.method_26213() != 0 && chunkAccess instanceof class_2839) {
                                    mutableBlockPos.method_10103(xx, yy, zz);
                                    ((class_2839)chunkAccess).method_12315((class_2338)mutableBlockPos);
                                }
                                levelChunkSection.method_12256(z, v, ac, blockState, false);
                                heightmap.method_12597(z, yy, ac, blockState);
                                heightmap2.method_12597(z, yy, ac, blockState);
                                if (!aquifer.method_33742() || blockState.method_26227().method_15769()) continue;
                                mutableBlockPos.method_10103(xx, yy, zz);
                                chunkAccess.method_12039((class_2338)mutableBlockPos);
                            }
                        }
                    }
                }
            }
            noiseChunk.method_38348();
        }
        return chunkAccess;
    }

    public int method_12104() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_174();
    }

    public int method_16398() {
        return ((class_5284)this.settings.comp_349()).comp_479();
    }

    public int method_33730() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_173();
    }

    @Deprecated
    public Optional<class_2680> topMaterial(class_5873 carvingContext, Function<class_2338, class_6880<class_1959>> function, class_2791 chunkAccess, class_6568 noiseChunk, class_2338 blockPos, boolean bl) {
        return this.surfaceSystem.method_39110(((class_5284)this.settings.comp_349()).comp_478(), carvingContext, function, chunkAccess, noiseChunk, blockPos, bl);
    }

    public class_6012<class_5483.class_1964> method_12113(class_6880<class_1959> biome, class_5138 accessor, class_1311 group, class_2338 pos) {
        return super.method_12113(biome, accessor, group, pos);
    }

    public void method_12107(class_3233 region) {
        class_5284 noiseGeneratorSettings = (class_5284)this.settings.comp_349();
        if (!((NoiseGeneratorSettingsInvoker)noiseGeneratorSettings).thebumblezone_callDisableMobGeneration()) {
            class_1923 chunkPos = region.method_33561();
            class_1959 biome = (class_1959)region.method_23753(chunkPos.method_8323()).comp_349();
            class_2919 sharedseedrandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
            sharedseedrandom.method_12661(region.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
            while (sharedseedrandom.nextFloat() < biome.method_30966().method_31002()) {
                class_1308 mobEntity;
                float threshold = sharedseedrandom.nextFloat();
                class_5483.class_1964 biome$spawnlistentry = threshold < 0.15f ? INITIAL_HONEY_SLIME_ENTRY : (threshold < 0.95f ? INITIAL_BEE_ENTRY : INITIAL_BEEHEMOTH_ENTRY);
                int startingX = chunkPos.method_8326() + sharedseedrandom.nextInt(16);
                int startingZ = chunkPos.method_8328() + sharedseedrandom.nextInt(16);
                class_2338.class_2339 blockpos = new class_2338.class_2339(startingX, 0, startingZ);
                int height = BzPlacingUtils.topOfSurfaceBelowHeight((class_1936)region, sharedseedrandom.nextInt(255), -1, (class_2338)blockpos) + 1;
                if (!biome$spawnlistentry.field_9389.method_5896() || height <= 0 || height >= 255) continue;
                float width = biome$spawnlistentry.field_9389.method_17685();
                double xLength = class_3532.method_15350((double)startingX, (double)((double)chunkPos.method_8326() + (double)width), (double)((double)chunkPos.method_8326() + 16.0 - (double)width));
                double zLength = class_3532.method_15350((double)startingZ, (double)((double)chunkPos.method_8328() + (double)width), (double)((double)chunkPos.method_8328() + 16.0 - (double)width));
                class_1297 entity = biome$spawnlistentry.field_9389.method_5883((class_1937)region.method_8410());
                if (entity == null) continue;
                entity.method_5808(xLength, (double)height, zLength, sharedseedrandom.nextFloat() * 360.0f, 0.0f);
                if (!(entity instanceof class_1308) || !(mobEntity = (class_1308)entity).method_5979((class_1936)region, class_3730.field_16472) || !mobEntity.method_5957((class_4538)region)) continue;
                mobEntity.method_5943((class_5425)region, region.method_8404(new class_2338(mobEntity.method_19538())), class_3730.field_16472, null, null);
                region.method_8649((class_1297)mobEntity);
            }
        }
    }

    record BiomeNoise(class_6544.class_6552 sampler, class_2378<class_1959> biomeRegistry, class_1966 biomeSource) implements class_6910.class_6913
    {
        public double method_40464(class_6910.class_6912 functionContext) {
            return BiomeInfluencedNoiseSampler.calculateBaseNoise(functionContext.comp_371(), functionContext.comp_373(), this.sampler, this.biomeSource, this.biomeRegistry);
        }

        public double comp_377() {
            return 0.0;
        }

        public double comp_378() {
            return 2.0;
        }

        public Codec<? extends class_6910> method_41062() {
            return null;
        }
    }

    record RoughSurfaceNoise() implements class_6910.class_6913
    {
        private static final OpenSimplex2F noiseGen = new OpenSimplex2F(0L);

        public double method_40464(class_6910.class_6912 functionContext) {
            return noiseGen.noise3_Classic(functionContext.comp_371(), functionContext.comp_372(), functionContext.comp_373()) / 100.0 - 0.01;
        }

        public double comp_377() {
            return 0.0;
        }

        public double comp_378() {
            return 2.0;
        }

        public Codec<? extends class_6910> method_41062() {
            return null;
        }
    }
}

