/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.mixin.world.BiomeSourceAccessor;
import com.telepathicgrunt.the_bumblezone.utils.WorldSeedHolder;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeMergeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeNonstandardLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePollinatedFieldsLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePollinatedPillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeScaleLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.Area;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.AreaFactory;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.AreaTransformer1;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.BigContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.Layer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyArea;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyAreaContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.ZoomLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;

public class BzBiomeProvider
extends class_1966 {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).stable().forGetter(bzBiomeProvider -> bzBiomeProvider.seed), (App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(biomeSource -> biomeSource.biomeRegistry)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    public static class_2960 HIVE_WALL = new class_2960("the_bumblezone", "hive_wall");
    public static class_2960 HIVE_PILLAR = new class_2960("the_bumblezone", "hive_pillar");
    public static class_2960 SUGAR_WATER_FLOOR = new class_2960("the_bumblezone", "sugar_water_floor");
    public static class_2960 POLLINATED_FIELDS = new class_2960("the_bumblezone", "pollinated_fields");
    public static class_2960 POLLINATED_PILLAR = new class_2960("the_bumblezone", "pollinated_pillar");
    private final long seed;
    private final Layer biomeSampler;
    private final class_2378<class_1959> biomeRegistry;
    public static List<class_1959> nonstandardBiome = new ArrayList<class_1959>();

    public BzBiomeProvider(long seed, class_2378<class_1959> biomeRegistry) {
        super(biomeRegistry.method_40270().filter(entry -> entry.method_40237().method_29177().method_12836().equals("the_bumblezone")).collect(Collectors.toList()));
        nonstandardBiome = ((BiomeSourceAccessor)((Object)this)).getPossibleBiomes().stream().map(class_6880::comp_349).filter(biome -> {
            class_2960 rlKey = biomeRegistry.method_10221(biome);
            return rlKey != null && !rlKey.equals((Object)HIVE_WALL) && !rlKey.equals((Object)HIVE_PILLAR) && !rlKey.equals((Object)SUGAR_WATER_FLOOR) && !rlKey.equals((Object)POLLINATED_FIELDS) && !rlKey.equals((Object)POLLINATED_PILLAR);
        }).collect(Collectors.toList());
        this.seed = seed;
        this.biomeRegistry = biomeRegistry;
        this.biomeSampler = BzBiomeProvider.buildWorldProcedure(seed, biomeRegistry);
    }

    public static void registerBiomeProvider() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("the_bumblezone", "biome_source"), CODEC);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public class_1966 method_27985(long seed) {
        return new BzBiomeProvider(seed, this.biomeRegistry);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> stack(long seed, AreaTransformer1 parent, AreaFactory<T> incomingArea, int count, LongFunction<C> contextFactory) {
        AreaFactory<T> LayerFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            LayerFactory = parent.run((BigContext)contextFactory.apply(seed + (long)i), LayerFactory);
        }
        return LayerFactory;
    }

    public static Layer buildWorldProcedure(long seed, class_2378<class_1959> biomeRegistry) {
        AreaFactory<LazyArea> layerFactory = BzBiomeProvider.build(salt -> new LazyAreaContext(25, seed, salt), seed, biomeRegistry);
        return new Layer(layerFactory);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> build(LongFunction<C> contextFactory, long seed, class_2378<class_1959> biomeRegistry) {
        AreaFactory layer = new BzBiomeLayer(seed, biomeRegistry).run((BigContext)contextFactory.apply(200L));
        layer = new BzBiomePillarLayer(biomeRegistry).run((BigContext)contextFactory.apply(1008L), layer);
        layer = new BzBiomeScaleLayer(HIVE_PILLAR, biomeRegistry).run((BigContext)contextFactory.apply(1055L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2003L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2523L), layer);
        AreaFactory layerOverlay = new BzBiomeNonstandardLayer(biomeRegistry).run((BigContext)contextFactory.apply(204L));
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2423L), layerOverlay);
        layerOverlay = new BzBiomePollinatedPillarLayer(biomeRegistry).run((BigContext)contextFactory.apply(3008L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(POLLINATED_PILLAR, biomeRegistry).run((BigContext)contextFactory.apply(4455L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2503L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2603L), layerOverlay);
        layerOverlay = new BzBiomePollinatedFieldsLayer(biomeRegistry).run((BigContext)contextFactory.apply(3578L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(POLLINATED_FIELDS, biomeRegistry).run((BigContext)contextFactory.apply(4055L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2853L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(3583L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(4583L), layerOverlay);
        layer = new BzBiomeMergeLayer().run((BigContext)contextFactory.apply(5583L), layerOverlay, layer);
        return layer;
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        return this.biomeSampler.sample(this.biomeRegistry, x, z);
    }
}

