/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_4466;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;
    private static final Set<class_4466> BEE_SET = new HashSet<class_4466>();
    public static final List<class_2680> VANILLA_CANDLES = ImmutableList.of((Object)class_2246.field_27099.method_9564(), (Object)class_2246.field_27109.method_9564(), (Object)class_2246.field_27141.method_9564(), (Object)class_2246.field_27111.method_9564(), (Object)class_2246.field_27112.method_9564(), (Object)class_2246.field_27107.method_9564(), (Object)class_2246.field_27113.method_9564(), (Object)class_2246.field_27103.method_9564(), (Object)class_2246.field_27108.method_9564(), (Object)class_2246.field_27105.method_9564(), (Object)class_2246.field_27102.method_9564(), (Object)class_2246.field_27101.method_9564(), (Object[])new class_2680[]{class_2246.field_27106.method_9564(), class_2246.field_27110.method_9564(), class_2246.field_27140.method_9564(), class_2246.field_27100.method_9564(), class_2246.field_27104.method_9564()});

    public static void updateEntityCount(class_3218 world) {
        BEE_SET.clear();
        int counter = 0;
        for (class_1297 entity : world.method_27909()) {
            ++counter;
            if (entity.method_5864() != class_1299.field_20346) continue;
            BEE_SET.add((class_4466)entity);
        }
        ACTIVE_ENTITIES = counter;
        BEE_SET.removeIf(bee -> bee.method_5947() || bee.method_21791() || bee.method_16914() || bee.method_5934() || bee.method_5782());
    }

    public static int getEntityCountInBz() {
        return ACTIVE_ENTITIES;
    }

    public static void adjustEntityCountInBz(int adjust) {
        ACTIVE_ENTITIES += adjust;
    }

    public static Set<class_4466> getAllWildBees() {
        return BEE_SET;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static class_2338 getRandomBlockposWithinRange(class_1937 world, class_1297 entity, int maxRadius, int minRadius) {
        class_2338 newBeePos = new class_2338(entity.method_23317() + (double)((world.field_9229.nextInt(maxRadius) + minRadius) * (world.field_9229.nextBoolean() ? 1 : -1)), Doubles.constrainToRange((double)(entity.method_23318() + (double)((world.field_9229.nextInt(maxRadius) + minRadius) * (world.field_9229.nextBoolean() ? 1 : -1))), (double)1.0, (double)254.0), entity.method_23321() + (double)((world.field_9229.nextInt(maxRadius) + minRadius) * (world.field_9229.nextBoolean() ? 1 : -1)));
        return newBeePos;
    }

    public static void givePlayerItem(class_1657 playerEntity, class_1268 hand, class_1799 itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        class_1799 playerItem = playerEntity.method_5998(hand);
        class_1799 copiedPlayerItem = playerItem.method_7972();
        if (shrinkCurrentItem) {
            playerItem.method_7934(1);
        }
        if (!itemstackToGive.method_7960()) {
            if (playerItem.method_7960()) {
                playerEntity.method_6122(hand, itemstackToGive);
            } else if (!playerEntity.method_31548().method_7394(itemstackToGive)) {
                playerEntity.method_7328(itemstackToGive, false);
            }
        }
        if (giveContainerItem && copiedPlayerItem.method_7909().method_7857()) {
            class_1799 containerItem = copiedPlayerItem.method_7909().method_7858().method_7854();
            if (playerEntity.method_5998(hand).method_7960()) {
                playerEntity.method_6122(hand, containerItem);
            } else if (!playerEntity.method_31548().method_7394(containerItem)) {
                playerEntity.method_7328(containerItem, false);
            }
        }
    }

    public static class BasicItemTrade
    implements class_3853.class_1652 {
        private final class_1792 itemToTrade;
        private final class_1792 itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(class_1792 itemToTrade, class_1792 itemToReceive, int amountToGive, int amountToReceive) {
            this(itemToReceive, itemToTrade, amountToGive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(class_1792 itemToTrade, class_1792 itemToReceive, int amountToGive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public class_1914 method_7246(class_1297 entity, Random random) {
            class_1799 in = new class_1799((class_1935)this.itemToTrade, this.amountToGive);
            class_1799 out = new class_1799((class_1935)this.itemToReceive, this.amountToReceive);
            return new class_1914(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }

    public static final class Lazy<T> {
        private volatile T value;

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }
    }
}

