/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.BeeBetterCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.FriendsAndFoesCompat;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;

public class ModChecker {
    public static boolean potionOfBeesPresent = false;
    public static boolean strangePresent = false;
    public static boolean friendsAndFoesPresent = false;
    public static boolean beeBetterPresent = false;

    public static void setupModCompat() {
        String currentModID = "";
        try {
            currentModID = "friendsandfoes";
            ModChecker.loadupModCompat(currentModID, () -> FriendsAndFoesCompat.setupCompat());
            currentModID = "beebetter";
            ModChecker.loadupModCompat(currentModID, () -> BeeBetterCompat.setupCompat());
        }
        catch (Exception e) {
            ModChecker.printErrorToLogs("classloading " + currentModID + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (FabricLoader.getInstance().isModLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.ERROR, "  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n\n  ERROR: Something broke when trying to add mod compatibility with %s. Please let The Bumblezone developer (TelepathicGrunt) know about this!\n\n  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n".formatted(currentModID));
    }
}

