/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin.entities;

import com.telepathicgrunt.the_bumblezone.effects.HiddenEffect;
import com.telepathicgrunt.the_bumblezone.effects.ParalyzedEffect;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.enchantments.NeurotoxinsEnchantment;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationHookup;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluid;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"isImmobile()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void thebumblezone_isParalyzedCheck(CallbackInfoReturnable<Boolean> cir) {
        if (ParalyzedEffect.isParalyzed((class_1309)this)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    private void thebumblezone_entityHurt(class_1282 source, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        NeurotoxinsEnchantment.entityHurt(this, source);
    }

    @Inject(method={"actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at={@At(value="HEAD")})
    private void thebumblezone_onEntityDamaged(class_1282 source, float amount, CallbackInfo ci) {
        BeeAggression.beeHitAndAngered((class_1297)((class_1309)this), source.method_5529());
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void thebumblezone_onDeath(class_1282 source, CallbackInfo ci) {
        WrathOfTheHiveEffect.calmTheBees(this.field_6002, (class_1309)this);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void thebumblezone_onLivingEntityTick(CallbackInfo ci) {
        EntityTeleportationHookup.entityTick((class_1309)this);
    }

    @Inject(method={"getVisibilityPercent(Lnet/minecraft/world/entity/Entity;)D"}, at={@At(value="RETURN")}, cancellable=true)
    private void thebumblezone_hideEntityWithHiddenEffect(class_1297 entity, CallbackInfoReturnable<Double> cir) {
        double newVisibility = HiddenEffect.hideEntity(entity, (Double)cir.getReturnValue());
        if ((Double)cir.getReturnValue() != newVisibility) {
            cir.setReturnValue((Object)newVisibility);
        }
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    private void thebumblezone_breathing(CallbackInfo ci) {
        HoneyFluid.breathing((class_1309)this);
    }

    @ModifyVariable(method={"aiStep()V"}, ordinal=0, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D", ordinal=1), slice=@Slice(from=@At(value="INVOKE_ASSIGN", target="net/minecraft/world/entity/LivingEntity.isAffectedByFluids()Z"), to=@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.isInWater()Z")))
    private double thebumblezone_honeyFluidJump(double fluidHeight) {
        if (fluidHeight == 0.0) {
            return this.method_5861(BzTags.BZ_HONEY_FLUID);
        }
        return fluidHeight;
    }
}

