/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids;

import com.telepathicgrunt.the_bumblezone.blocks.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.FlowingFluidAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

public abstract class HoneyFluid
extends class_3609 {
    public static final class_2758 BOTTOM_LEVEL = HoneyFluidBlock.BOTTOM_LEVEL;
    public static final class_2746 ABOVE_FLUID = HoneyFluidBlock.ABOVE_FLUID;

    protected HoneyFluid() {
    }

    public class_3611 method_15750() {
        return BzFluids.HONEY_FLUID_FLOWING;
    }

    public class_3611 method_15751() {
        return BzFluids.HONEY_FLUID;
    }

    public class_1792 method_15774() {
        return BzItems.HONEY_BUCKET;
    }

    public void method_15776(class_1937 worldIn, class_2338 pos, class_3610 state, Random random) {
        if (random.nextInt(82) == 0) {
            worldIn.method_8406((class_2394)BzParticles.HONEY_PARTICLE, (double)((float)pos.method_10263() + random.nextFloat()), (double)((float)pos.method_10264() + random.nextFloat()), (double)((float)pos.method_10260() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public class_2394 method_15787() {
        return BzParticles.HONEY_PARTICLE;
    }

    protected float method_15784() {
        return 120.0f;
    }

    protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)pos, (class_2586)blockEntity);
    }

    public int method_15733(class_4538 world) {
        return 4;
    }

    public int method_15739(class_4538 world) {
        return 1;
    }

    public int method_15789(class_4538 world) {
        return 30;
    }

    public boolean method_15780(class_3611 fluid) {
        return fluid.method_15791(BzTags.VISUAL_HONEY_FLUID);
    }

    public boolean method_15777(class_3610 state, class_1922 world, class_2338 pos, class_3611 fluid, class_2350 direction) {
        return direction == class_2350.field_11033 && !fluid.method_15791(class_3486.field_15517);
    }

    public class_2680 method_15790(class_3610 state) {
        return (class_2680)((class_2680)((class_2680)((class_2680)BzFluids.HONEY_FLUID_BLOCK.method_9564().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(state.method_15771() ? 0 : state.method_15761()))).method_11657((class_2769)BOTTOM_LEVEL, (Comparable)(state.method_15771() ? Integer.valueOf(0) : (Integer)state.method_11654((class_2769)BOTTOM_LEVEL)))).method_11657((class_2769)field_15902, (Comparable)Boolean.valueOf(!state.method_15771() && (Boolean)state.method_11654((class_2769)field_15902) != false))).method_11657((class_2769)ABOVE_FLUID, (Comparable)((Boolean)state.method_11654((class_2769)ABOVE_FLUID)));
    }

    public void method_15778(class_1937 world, class_2338 blockPos, class_3610 fluidState) {
        boolean justFilledBottom = false;
        if (!fluidState.method_15771()) {
            class_3610 newFluidState = this.method_15727((class_4538)world, blockPos, world.method_8320(blockPos));
            int spreadDelay = this.method_15753(world, blockPos, fluidState, newFluidState);
            if (newFluidState.method_15769()) {
                fluidState = newFluidState;
                world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                if ((Integer)fluidState.method_11654((class_2769)BOTTOM_LEVEL) != 0 && (newFluidState.method_15771() || (Integer)newFluidState.method_11654((class_2769)BOTTOM_LEVEL) == 0)) {
                    justFilledBottom = true;
                }
                fluidState = newFluidState;
                class_2680 blockstate = newFluidState.method_15759();
                world.method_8652(blockPos, blockstate, 2);
                world.method_39281(blockPos, newFluidState.method_15772(), spreadDelay);
                world.method_8452(blockPos, blockstate.method_26204());
            }
        }
        if (!fluidState.method_15769()) {
            int bottomFluidLevel;
            int n = bottomFluidLevel = fluidState.method_15771() ? 0 : (Integer)fluidState.method_11654((class_2769)BOTTOM_LEVEL);
            if (bottomFluidLevel == 0) {
                class_2680 blockState = world.method_8320(blockPos);
                class_2338 belowBlockPos = blockPos.method_10074();
                class_2680 belowBlockState = world.method_8320(belowBlockPos);
                class_3610 belowFluidState = this.method_15727((class_4538)world, belowBlockPos, belowBlockState);
                if (!belowBlockState.method_26227().method_15767(BzTags.HONEY_FLUID) && this.method_15738((class_1922)world, blockPos, blockState, class_2350.field_11033, belowBlockPos, belowBlockState, world.method_8316(belowBlockPos), belowFluidState.method_15772())) {
                    if (!justFilledBottom) {
                        this.spreadDown((class_1936)world, belowBlockPos, belowBlockState, class_2350.field_11033, belowFluidState);
                        if (((FlowingFluidAccessor)((Object)this)).thebumblezone_callSourceNeighborCount((class_4538)world, blockPos) >= 3) {
                            ((FlowingFluidAccessor)((Object)this)).thebumblezone_callSpreadToSides((class_1936)world, blockPos, fluidState, blockState);
                        }
                    }
                } else if (fluidState.method_15771() || !belowBlockState.method_26227().method_15772().method_15780((class_3611)this)) {
                    ((FlowingFluidAccessor)((Object)this)).thebumblezone_callSpreadToSides((class_1936)world, blockPos, fluidState, blockState);
                }
            }
        }
    }

    protected void method_15725(class_1936 world, class_2338 blockPos, class_3610 fluidState) {
        int bottomFluidLevel;
        if (!fluidState.method_15769() && (bottomFluidLevel = ((Integer)fluidState.method_11654((class_2769)BOTTOM_LEVEL)).intValue()) == 0) {
            class_2680 blockState = world.method_8320(blockPos);
            class_2338 belowBlockPos = blockPos.method_10074();
            class_2680 belowBlockState = world.method_8320(belowBlockPos);
            class_3610 belowFluidState = this.method_15727((class_4538)world, belowBlockPos, belowBlockState);
            if (!belowBlockState.method_26227().method_15767(BzTags.HONEY_FLUID) && this.method_15738((class_1922)world, blockPos, blockState, class_2350.field_11033, belowBlockPos, belowBlockState, world.method_8316(belowBlockPos), belowFluidState.method_15772())) {
                this.spreadDown(world, belowBlockPos, belowBlockState, class_2350.field_11033, belowFluidState);
                if (((FlowingFluidAccessor)((Object)this)).thebumblezone_callSourceNeighborCount((class_4538)world, blockPos) >= 3) {
                    ((FlowingFluidAccessor)((Object)this)).thebumblezone_callSpreadToSides(world, blockPos, fluidState, blockState);
                }
            } else if (fluidState.method_15771() || !belowBlockState.method_26227().method_15772().method_15780((class_3611)this)) {
                ((FlowingFluidAccessor)((Object)this)).thebumblezone_callSpreadToSides(world, blockPos, fluidState, blockState);
            }
        }
    }

    protected void spreadDown(class_1936 world, class_2338 blockPos, class_2680 blockState, class_2350 direction, class_3610 fluidState) {
        if (!blockState.method_26215()) {
            this.method_15730(world, blockPos, blockState);
        }
        world.method_8652(blockPos, fluidState.method_15759(), 3);
    }

    protected class_3610 method_15727(class_4538 worldReader, class_2338 blockPos, class_2680 blockState) {
        int currentFluidLevel;
        boolean isBzFluidBlock = blockState.method_26204() instanceof HoneyFluidBlock;
        int lowestNeighboringFluidLevel = isBzFluidBlock ? (Integer)blockState.method_11654((class_2769)BOTTOM_LEVEL) : 8;
        int highestNeighboringFluidLevel = currentFluidLevel = isBzFluidBlock ? (Integer)blockState.method_11654((class_2769)HoneyFluidBlock.field_11278) : 0;
        int neighboringFluidSource = 0;
        boolean hasAboveFluid = isBzFluidBlock ? (Boolean)blockState.method_11654((class_2769)ABOVE_FLUID) : false;
        class_2338 aboveBlockPos = blockPos.method_10084();
        class_2680 aboveBlockState = worldReader.method_8320(aboveBlockPos);
        class_2680 belowBlockState = worldReader.method_8320(blockPos.method_10074());
        boolean canPassThroughBelow = ((FlowingFluidAccessor)((Object)this)).thebumblezone_callCanPassThroughWall(class_2350.field_11033, (class_1922)worldReader, blockPos, blockState, blockPos.method_10074(), belowBlockState);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 sideBlockPos = blockPos.method_10093(direction);
            class_2680 sideBlockState = worldReader.method_8320(sideBlockPos);
            class_3610 sideFluidState = sideBlockState.method_26227();
            if (!sideFluidState.method_15772().method_15780((class_3611)this) || !((FlowingFluidAccessor)((Object)this)).thebumblezone_callCanPassThroughWall(direction, (class_1922)worldReader, blockPos, blockState, sideBlockPos, sideBlockState)) continue;
            if (sideFluidState.method_15771()) {
                ++neighboringFluidSource;
            }
            highestNeighboringFluidLevel = Math.max(highestNeighboringFluidLevel, sideFluidState.method_15761());
            if (!sideFluidState.method_15767(BzTags.BZ_HONEY_FLUID) || canPassThroughBelow && !sideFluidState.method_15771() && ((Boolean)sideBlockState.method_11654((class_2769)HoneyFluidBlock.FALLING)).booleanValue() && aboveBlockState.method_26227().method_15767(BzTags.BZ_HONEY_FLUID)) continue;
            lowestNeighboringFluidLevel = Math.min(lowestNeighboringFluidLevel, sideFluidState.method_15771() ? 0 : (Integer)sideFluidState.method_11654((class_2769)BOTTOM_LEVEL));
        }
        class_3610 aboveFluidState = aboveBlockState.method_26227();
        boolean aboveFluidIsThisFluid = !aboveFluidState.method_15769() && aboveFluidState.method_15772().method_15780((class_3611)this);
        int newBottomFluidLevel = Math.max(lowestNeighboringFluidLevel - 1, 0);
        boolean isFalling = true;
        int newFluidLevel = 8;
        int dropOffValue = this.method_15739(worldReader);
        if (hasAboveFluid && !aboveFluidIsThisFluid) {
            dropOffValue = 0;
        }
        if (aboveFluidIsThisFluid && ((FlowingFluidAccessor)((Object)this)).thebumblezone_callCanPassThroughWall(class_2350.field_11036, (class_1922)worldReader, blockPos, blockState, aboveBlockPos, aboveBlockState)) {
            if (!aboveFluidState.method_15771() && aboveFluidState.method_15767(BzTags.BZ_HONEY_FLUID) && (Integer)aboveFluidState.method_11654((class_2769)BOTTOM_LEVEL) != 0) {
                newFluidLevel = highestNeighboringFluidLevel - dropOffValue;
            }
        } else {
            isFalling = aboveFluidState.method_15769() && neighboringFluidSource == 0 && highestNeighboringFluidLevel <= currentFluidLevel && canPassThroughBelow;
            newFluidLevel = highestNeighboringFluidLevel - dropOffValue;
        }
        return newFluidLevel <= 0 ? class_3612.field_15906.method_15785() : (class_3610)((class_3610)this.method_15728(newFluidLevel, isFalling).method_11657((class_2769)BOTTOM_LEVEL, (Comparable)Integer.valueOf(newBottomFluidLevel))).method_11657((class_2769)ABOVE_FLUID, (Comparable)Boolean.valueOf(aboveFluidIsThisFluid && (aboveFluidState.method_15771() || (Integer)aboveFluidState.method_11654((class_2769)BOTTOM_LEVEL) == 0)));
    }

    public float method_15788(class_3610 fluidState, class_1922 world, class_2338 blockPos) {
        class_2338 aboveBlockPos = blockPos.method_10084();
        class_2680 aboveBlockState = world.method_8320(aboveBlockPos);
        class_3610 aboveFluidState = aboveBlockState.method_26227();
        boolean aboveFluidIsThisFluid = !aboveFluidState.method_15769() && aboveFluidState.method_15772().method_15780((class_3611)this) && (aboveFluidState.method_15771() || !aboveFluidState.method_15767(BzTags.BZ_HONEY_FLUID) || (Integer)aboveFluidState.method_11654((class_2769)BOTTOM_LEVEL) == 0);
        return (Boolean)fluidState.method_11654((class_2769)ABOVE_FLUID) != false || aboveFluidIsThisFluid ? 1.0f : fluidState.method_20785();
    }

    public static float getHoneyFluidHeight(class_1922 world, class_2338 blockPos, class_3611 fluid) {
        float totalHeight = 0.0f;
        int checkedSides = 0;
        int fluidSides = 0;
        class_3610 currentMatchingFluidState = null;
        for (int xOffset = -2; xOffset <= 1; ++xOffset) {
            for (int zOffset = -2; zOffset <= 1; ++zOffset) {
                class_2338 currentBlockPos = blockPos.method_10069(xOffset, 0, zOffset);
                if (xOffset == -2 || zOffset == -2 || xOffset == 1 || zOffset == 1) {
                    class_3610 currentFluidState = world.method_8316(currentBlockPos);
                    if (!currentFluidState.method_15772().method_15780(fluid)) continue;
                    currentMatchingFluidState = currentFluidState;
                    ++fluidSides;
                    continue;
                }
                class_3610 aboveFluidState = world.method_8316(currentBlockPos.method_10084());
                if (aboveFluidState.method_15772().method_15780(fluid) && (aboveFluidState.method_15771() || !aboveFluidState.method_15767(BzTags.BZ_HONEY_FLUID) || (Integer)aboveFluidState.method_11654((class_2769)BOTTOM_LEVEL) == 0)) {
                    return 1.0f;
                }
                class_3610 currentFluidState = world.method_8316(currentBlockPos);
                if (currentFluidState.method_15772().method_15780(fluid)) {
                    currentMatchingFluidState = currentFluidState;
                    ++fluidSides;
                    float fluidStateHeight = currentFluidState.method_15763(world, currentBlockPos);
                    if (fluidStateHeight >= 0.8f) {
                        totalHeight += fluidStateHeight * 10.0f;
                        checkedSides += 10;
                        continue;
                    }
                    totalHeight += fluidStateHeight;
                    ++checkedSides;
                    continue;
                }
                if (world.method_8320(currentBlockPos).method_26207().method_15799()) continue;
                ++checkedSides;
            }
        }
        if (fluidSides == 1 && currentMatchingFluidState.method_15772().method_15780(fluid) && !currentMatchingFluidState.method_15771() && ((Boolean)currentMatchingFluidState.method_11654((class_2769)field_15902)).booleanValue()) {
            return currentMatchingFluidState.method_15763(world, blockPos);
        }
        return totalHeight / (float)checkedSides;
    }

    public static void setBottomFluidHeight(Args args, class_2338 blockPos, class_3610 fluidState) {
        if (fluidState.method_15767(BzTags.BZ_HONEY_FLUID)) {
            double blockY = blockPos.method_10264() & 0xF;
            args.set(2, (Object)(blockY + (double)(fluidState.method_15771() ? 0.0f : (float)((Integer)fluidState.method_11654((class_2769)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0f)));
        }
    }

    public static boolean shouldNotCullSide(class_1922 world, class_2338 blockPos, class_2350 direction, class_3610 currentFluidState) {
        if (direction == class_2350.field_11036) {
            class_3610 aboveFluidState = world.method_8320(blockPos.method_10084()).method_26227();
            return aboveFluidState.method_15767(BzTags.BZ_HONEY_FLUID) && !aboveFluidState.method_15771() && ((Integer)aboveFluidState.method_11654((class_2769)BOTTOM_LEVEL) != 0 || currentFluidState.method_15761() != 8);
        }
        if (direction == class_2350.field_11033) {
            class_3610 belowFluidState = world.method_8320(blockPos.method_10074()).method_26227();
            return belowFluidState.method_15767(BzTags.BZ_HONEY_FLUID) && !currentFluidState.method_15771() && (belowFluidState.method_15761() != 8 || (Integer)currentFluidState.method_11654((class_2769)BOTTOM_LEVEL) != 0);
        }
        class_3610 sideFluidState = world.method_8320(blockPos.method_10093(direction)).method_26227();
        if (sideFluidState.method_15767(BzTags.BZ_HONEY_FLUID)) {
            int bottomLayerCurrent = currentFluidState.method_15771() ? 8 : (Integer)currentFluidState.method_11654((class_2769)BOTTOM_LEVEL);
            int bottomLayerSide = sideFluidState.method_15771() ? 8 : (Integer)sideFluidState.method_11654((class_2769)BOTTOM_LEVEL);
            return bottomLayerCurrent < bottomLayerSide;
        }
        return false;
    }

    public static void breathing(class_1309 thisEntity) {
        boolean invulnerable;
        boolean bl = invulnerable = thisEntity instanceof class_1657 && ((class_1657)thisEntity).method_31549().field_7480;
        if (thisEntity.method_5805() && thisEntity.method_5777(BzTags.BZ_HONEY_FLUID)) {
            if (!(thisEntity.method_6094() || class_1292.method_5574((class_1309)thisEntity) || invulnerable)) {
                thisEntity.method_5855(HoneyFluid.decreaseAirSupply(thisEntity.method_5669() - 4, thisEntity, thisEntity.field_6002.field_9229));
                if (thisEntity.method_5669() == -20) {
                    thisEntity.method_5855(0);
                    class_243 vector3d = thisEntity.method_18798();
                    for (int i = 0; i < 8; ++i) {
                        double d2 = thisEntity.field_6002.field_9229.nextDouble() - thisEntity.field_6002.field_9229.nextDouble();
                        double d3 = thisEntity.field_6002.field_9229.nextDouble() - thisEntity.field_6002.field_9229.nextDouble();
                        double d4 = thisEntity.field_6002.field_9229.nextDouble() - thisEntity.field_6002.field_9229.nextDouble();
                        thisEntity.field_6002.method_8406((class_2394)BzParticles.HONEY_PARTICLE, thisEntity.method_23317() + d2, thisEntity.method_23318() + d3, thisEntity.method_23321() + d4, vector3d.field_1352, vector3d.field_1351, vector3d.field_1350);
                    }
                    thisEntity.method_5643(class_1282.field_5859, 2.0f);
                }
            }
            if (!thisEntity.field_6002.method_8608() && thisEntity.method_5765() && thisEntity.method_5854() != null && !thisEntity.method_5854().method_5788()) {
                thisEntity.method_5848();
            }
        }
    }

    protected static int decreaseAirSupply(int airSupply, class_1309 entity, Random random) {
        int respiration = class_1890.method_8211((class_1309)entity);
        return respiration > 0 && random.nextInt(respiration + 1) > 0 ? airSupply : airSupply - 1;
    }

    public static class Source
    extends HoneyFluid {
        public Source() {
            this.method_15781((class_3610)((class_3610)this.method_15783().method_11664()).method_11657((class_2769)ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        }

        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(new class_2769[]{ABOVE_FLUID});
        }

        public int method_15779(class_3610 state) {
            return 8;
        }

        public boolean method_15793(class_3610 state) {
            return true;
        }

        protected boolean method_15737() {
            return false;
        }
    }

    public static class Flowing
    extends HoneyFluid {
        public Flowing() {
            this.method_15781((class_3610)((class_3610)((class_3610)((class_3610)this.method_15783().method_11664()).method_11657((class_2769)field_15900, (Comparable)Integer.valueOf(8))).method_11657((class_2769)BOTTOM_LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)ABOVE_FLUID, (Comparable)Boolean.valueOf(false)));
        }

        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(new class_2769[]{field_15900});
            builder.method_11667(new class_2769[]{BOTTOM_LEVEL});
            builder.method_11667(new class_2769[]{ABOVE_FLUID});
        }

        public int method_15779(class_3610 state) {
            return (Integer)state.method_11654((class_2769)field_15900);
        }

        public boolean method_15793(class_3610 state) {
            return false;
        }

        protected boolean method_15737() {
            return true;
        }
    }
}

