/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.components.EntityComponent;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzDimension;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzWorldSavedData;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class EntityTeleportationHookup {
    public static void entityTick(class_1309 livingEntity) {
        if (livingEntity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (livingEntity.method_23318() < -2.0) {
                if (livingEntity instanceof class_3222 && livingEntity.field_6017 > 100.0f && livingEntity.method_18798().method_10214() < -1.0) {
                    BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_FALL_TRIGGER.trigger((class_3222)livingEntity);
                }
                if (Bumblezone.BZ_CONFIG.BZDimensionConfig.enableExitTeleportation) {
                    if (livingEntity.method_23318() < -4.0) {
                        livingEntity.method_24203(livingEntity.method_23317(), -4.0, livingEntity.method_23321());
                        livingEntity.method_30634(livingEntity.method_23317(), -4.0, livingEntity.method_23321());
                    }
                    livingEntity.field_6017 = 0.0f;
                    if (!livingEntity.field_6002.method_8608()) {
                        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                    }
                }
            } else if (livingEntity.method_23318() > 255.0 && Bumblezone.BZ_CONFIG.BZDimensionConfig.enableExitTeleportation) {
                if (livingEntity.method_23318() > 257.0) {
                    livingEntity.method_24203(livingEntity.method_23317(), 257.0, livingEntity.method_23321());
                    livingEntity.method_30634(livingEntity.method_23317(), 257.0, livingEntity.method_23321());
                }
                if (!livingEntity.field_6002.method_8608()) {
                    EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                }
            }
        }
    }

    public static void teleportOutOfBz(class_1309 livingEntity) {
        if (!livingEntity.field_6002.method_8608()) {
            class_5321 worldKey;
            EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity);
            MinecraftServer minecraftServer = livingEntity.method_5682();
            if (livingEntity.method_5642() == null) {
                worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity)).getNonBZDimension());
            } else {
                class_1297 class_12972 = livingEntity.method_5642();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity2 = (class_1309)class_12972;
                    EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity2);
                }
                worldKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity.method_5642())).getNonBZDimension());
            }
            class_3218 serverWorld = minecraftServer.method_3847(worldKey);
            if (serverWorld == null) {
                serverWorld = minecraftServer.method_3847(class_1937.field_25179);
            }
            BzWorldSavedData.queueEntityToTeleport((class_1297)livingEntity, (class_5321<class_1937>)serverWorld.method_27983());
        }
    }

    public static boolean runEnderpearlImpact(class_239 hitResult, class_1676 pearlEntity) {
        class_1297 class_12972;
        class_1937 world = pearlEntity.field_6002;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.enableEntranceTeleportation && !world.method_8608() && (class_12972 = pearlEntity.method_24921()) instanceof class_3222) {
            class_3222 playerEntity = (class_3222)class_12972;
            if (!(world.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BZ_CONFIG.BZDimensionConfig.onlyOverworldHivesTeleports && !world.method_27983().equals(class_1937.field_25179))) {
                class_243 hitPos = hitResult.method_17784();
                class_2338 hivePos = EntityTeleportationHookup.getNearbyHivePos(hitPos, world);
                if (hivePos == null) {
                    hitPos = hitPos.method_1019(pearlEntity.method_18798());
                    hivePos = EntityTeleportationHookup.getNearbyHivePos(hitPos, world);
                }
                if (hivePos == null) {
                    return false;
                }
                boolean validBelowBlock = false;
                Optional blockTag = class_2378.field_11146.method_40266(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && ((class_6885.class_6888)blockTag.get()).method_40247() != 0) {
                    if (world.method_8320(hivePos.method_10074()).method_26164(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                        validBelowBlock = true;
                    } else if (Bumblezone.BZ_CONFIG.BZDimensionConfig.warnPlayersOfWrongBlockUnderHive) {
                        Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                        class_2585 message = new class_2585("the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                        playerEntity.method_7353((class_2561)message, true);
                        return false;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(playerEntity);
                    BzWorldSavedData.queueEntityToTeleport((class_1297)playerEntity, BzDimension.BZ_WORLD_KEY);
                    pearlEntity.method_31472();
                    return true;
                }
            }
        }
        return false;
    }

    private static class_2338 getNearbyHivePos(class_243 hitBlockPos, class_1937 world) {
        double checkRadius = 0.5;
        for (double offset = -checkRadius; offset <= checkRadius; offset += checkRadius) {
            for (double offset2 = -checkRadius; offset2 <= checkRadius; offset2 += checkRadius) {
                for (double offset3 = -checkRadius; offset3 <= checkRadius; offset3 += checkRadius) {
                    class_2338 offsettedHitPos = new class_2338(hitBlockPos.method_1031(offset, offset2, offset3));
                    class_2680 block = world.method_8320(offsettedHitPos);
                    if (!EntityTeleportationBackend.isValidBeeHive(block)) continue;
                    return offsettedHitPos;
                }
            }
        }
        return null;
    }

    public static void runPistonPushed(class_2350 direction, class_1309 pushedEntity) {
        class_3218 world = (class_3218)pushedEntity.field_6002;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.enableEntranceTeleportation && !world.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) && (!Bumblezone.BZ_CONFIG.BZDimensionConfig.onlyOverworldHivesTeleports || world.method_27983().equals(class_1937.field_25179))) {
            if (BzWorldSavedData.isEntityQueuedToTeleportAlready((class_1297)pushedEntity)) {
                return;
            }
            class_2338.class_2339 entityPos = new class_2338.class_2339().method_10101((class_2382)pushedEntity.method_24515());
            class_2338[] blockPositions = new class_2338[]{entityPos, entityPos.method_10093(direction), entityPos.method_10093(class_2350.field_11036), entityPos.method_10093(class_2350.field_11036).method_10093(direction)};
            ArrayList<class_2680> belowHiveBlocks = new ArrayList<class_2680>();
            boolean isPushedIntoBeehive = false;
            for (class_2338 pos : blockPositions) {
                if (!EntityTeleportationBackend.isValidBeeHive(world.method_8320(pos))) continue;
                isPushedIntoBeehive = true;
                belowHiveBlocks.add(world.method_8320(pos.method_10074()));
            }
            if (isPushedIntoBeehive) {
                boolean validBelowBlock = false;
                Optional blockTag = class_2378.field_11146.method_40266(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && ((class_6885.class_6888)blockTag.get()).method_40247() != 0) {
                    for (class_2680 belowBlock : belowHiveBlocks) {
                        if (!belowBlock.method_26164(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) continue;
                        validBelowBlock = true;
                    }
                    if (!validBelowBlock && Bumblezone.BZ_CONFIG.BZDimensionConfig.warnPlayersOfWrongBlockUnderHive) {
                        if (pushedEntity instanceof class_1657) {
                            class_1657 playerEntity = (class_1657)pushedEntity;
                            Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                            class_2585 message = new class_2585("the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                            playerEntity.method_7353((class_2561)message, true);
                        }
                        return;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    if (pushedEntity instanceof class_3222) {
                        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger((class_3222)pushedEntity);
                    }
                    BzWorldSavedData.queueEntityToTeleport((class_1297)pushedEntity, BzDimension.BZ_WORLD_KEY);
                }
            }
        }
    }

    private static void checkAndCorrectStoredDimension(class_1309 livingEntity) {
        if (((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity)).getNonBZDimension().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BZ_CONFIG.BZDimensionConfig.forceExitToOverworld) {
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)livingEntity)).setNonBZDimension(class_1937.field_25179.method_29177());
        }
    }
}

