/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.components.EntityComponent;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3614;
import net.minecraft.class_4481;

public class EntityTeleportationBackend {
    private static final int SEARCH_RADIUS = 48;

    public static class_243 destPostFromOutOfBoundsTeleport(class_1297 entity, class_3218 destination, boolean checkingUpward) {
        class_2338 validBlockPos;
        class_2338 finalSpawnPos;
        class_1297 player = entity.method_5685().stream().filter(e -> e instanceof class_1657).findFirst().orElse(null);
        if (player != null) {
            entity = player;
        }
        double coordinateScale = entity.field_6002.method_8597().method_31110() / destination.method_8597().method_31110();
        boolean spawnAtFixedPosition = false;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 1) {
            finalSpawnPos = new class_2338(Doubles.constrainToRange((double)(entity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), entity.method_19538().method_10214(), Doubles.constrainToRange((double)(entity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocationByBeehive((class_1937)destination, finalSpawnPos, 48, checkingUpward);
        } else if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 2) {
            class_243 playerPos = ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).getNonBZPos();
            spawnAtFixedPosition = true;
            validBlockPos = playerPos != null ? new class_2338(playerPos) : entity.method_24515();
        } else {
            finalSpawnPos = new class_2338(Doubles.constrainToRange((double)(entity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), entity.method_19538().method_10214(), Doubles.constrainToRange((double)(entity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocationByBeehive((class_1937)destination, finalSpawnPos, 48, checkingUpward);
            class_243 playerPos = ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).getNonBZPos();
            if (validBlockPos == null && playerPos != null) {
                validBlockPos = new class_2338(playerPos);
                spawnAtFixedPosition = true;
            }
        }
        finalSpawnPos = validBlockPos;
        if (finalSpawnPos == null) {
            finalSpawnPos = new class_2338(entity.method_19538());
            spawnAtFixedPosition = true;
        }
        if (spawnAtFixedPosition && destination.method_8320(finalSpawnPos.method_10084()).method_26228((class_1922)destination, finalSpawnPos.method_10084())) {
            destination.method_8652(finalSpawnPos, class_2246.field_10124.method_9564(), 3);
            destination.method_8652(finalSpawnPos.method_10084(), class_2246.field_10124.method_9564(), 3);
        }
        return new class_243((double)finalSpawnPos.method_10263() + 0.5, (double)(finalSpawnPos.method_10264() + 1), (double)finalSpawnPos.method_10260() + 0.5);
    }

    public static class_243 getBzCoordinate(class_1297 entity, class_3218 originalWorld, class_3218 bumblezoneWorld) {
        int heightCheck;
        class_1309 livingEntity;
        class_2338 blockpos;
        Object validBlockPos;
        double coordinateScale = 1.0;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode != 2) {
            coordinateScale = originalWorld.method_8597().method_31110() / bumblezoneWorld.method_8597().method_31110();
        }
        if ((validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocation((class_1937)bumblezoneWorld, blockpos = new class_2338(Doubles.constrainToRange((double)(entity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), Doubles.constrainToRange((double)entity.method_19538().method_10214(), (double)45.0, (double)200.0), Doubles.constrainToRange((double)(entity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7)), 10)) == null) {
            validBlockPos = new class_2338(blockpos.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((class_1936)bumblezoneWorld, blockpos.method_10264(), 0, blockpos) + 1, blockpos.method_10260());
            if (validBlockPos.method_10264() == 0) {
                validBlockPos = null;
            } else if (bumblezoneWorld.method_8320(validBlockPos).method_26207() == class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() == class_3614.field_15920) {
                class_2338.class_2339 mutable = new class_2338.class_2339(validBlockPos.method_10263(), validBlockPos.method_10264(), validBlockPos.method_10260());
                while (mutable.method_10264() < 255 && !bumblezoneWorld.method_22347((class_2338)mutable) || bumblezoneWorld.method_8320((class_2338)mutable).method_26207() == class_3614.field_15920) {
                    mutable.method_10098(class_2350.field_11036);
                }
                validBlockPos = bumblezoneWorld.method_8320((class_2338)mutable).method_26207() != class_3614.field_15959 ? null : mutable;
            } else if (!bumblezoneWorld.method_22347(validBlockPos) && bumblezoneWorld.method_8320(validBlockPos).method_26207() != class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() != class_3614.field_15959) {
                validBlockPos = null;
            }
            if (validBlockPos == null) {
                bumblezoneWorld.method_8501(blockpos, class_2246.field_10124.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10084(), class_2246.field_10124.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10074(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10084().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10095(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10067(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10078(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10072(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10095().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10067().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10078().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10072().method_10084(), class_2246.field_21212.method_9564());
                validBlockPos = blockpos;
            }
        }
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6113()) {
            livingEntity.method_18400();
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.method_10264() && bumblezoneWorld.method_8320(validBlockPos.method_10087(heightCheck)).method_26215(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.method_10264()) {
            bumblezoneWorld.method_8501(validBlockPos.method_10264() == 0 ? validBlockPos : validBlockPos.method_10074(), class_2246.field_21212.method_9564());
        }
        return new class_243((double)validBlockPos.method_10263() + 0.5, (double)validBlockPos.method_10264(), (double)validBlockPos.method_10260() + 0.5);
    }

    private static class_2338 validPlayerSpawnLocationByBeehive(class_1937 world, class_2338 position, int maximumRange, boolean checkingUpward) {
        int maxHeight = 0;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        HashSet<class_2818> chunksInRange = new HashSet<class_2818>();
        for (int x = -maximumRange; x < maximumRange; x += 16) {
            for (int z = -maximumRange; z < maximumRange; z += 16) {
                mutableBlockPos.method_10103(position.method_10263() + x, 0, position.method_10260() + z);
                class_2791 chunk = world.method_22350((class_2338)mutableBlockPos);
                if (chunk instanceof class_2818) {
                    chunksInRange.add((class_2818)chunk);
                }
                maxHeight = Math.max(maxHeight, world.method_8624(class_2902.class_2903.field_13197, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()));
            }
        }
        maxHeight = Math.min(maxHeight, world.method_31605() - 1);
        class_2338.class_2339 mutableTemp1 = new class_2338.class_2339();
        class_2338.class_2339 mutableTemp2 = new class_2338.class_2339();
        HashSet tempSet = new HashSet();
        chunksInRange.stream().map(class_2818::method_12214).forEach(map -> tempSet.addAll(map.values()));
        Stream<class_2586> allBlockEntitiesInRange = tempSet.stream().filter(be -> {
            if (!EntityTeleportationBackend.isValidBeeHive(be.method_11010())) {
                return false;
            }
            if (Bumblezone.BZ_CONFIG.BZDimensionConfig.seaLevelOrHigherExitTeleporting && be.method_11016().method_10264() < ((class_3218)world).method_14178().method_12129().method_16398() - 1) {
                return false;
            }
            mutableTemp1.method_10101((class_2382)be.method_11016()).method_10100(-position.method_10263(), 0, -position.method_10260());
            return Math.abs(mutableTemp1.method_10263()) <= maximumRange && Math.abs(mutableTemp1.method_10260()) <= maximumRange;
        });
        List sortedBlockEntities = allBlockEntitiesInRange.sorted((be1, be2) -> {
            mutableTemp1.method_10101((class_2382)be1.method_11016()).method_10100(-position.method_10263(), 0, -position.method_10260());
            mutableTemp2.method_10101((class_2382)be2.method_11016()).method_10100(-position.method_10263(), 0, -position.method_10260());
            int heightDiff = mutableTemp1.method_10264() - mutableTemp2.method_10264();
            int xzDiff = Math.abs(mutableTemp1.method_10263() - mutableTemp2.method_10263()) + Math.abs(mutableTemp1.method_10260() - mutableTemp2.method_10260());
            if (checkingUpward) {
                heightDiff *= -1;
                xzDiff *= -1;
            }
            return heightDiff - xzDiff;
        }).collect(Collectors.toList());
        for (class_2586 blockEntity : sortedBlockEntities) {
            class_2338 validSpot = EntityTeleportationBackend.validPlayerSpawnLocation(world, blockEntity.method_11016(), 4);
            if (validSpot == null) continue;
            return validSpot;
        }
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 3) {
            return null;
        }
        if (maxHeight + 1 < world.method_31605()) {
            ++maxHeight;
        }
        mutableBlockPos.method_10103(position.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeight((class_1936)world, maxHeight, 0, position), position.method_10260());
        if (mutableBlockPos.method_10264() <= 0) {
            mutableBlockPos.method_10103(position.method_10263(), world.method_31605() / 2, position.method_10260());
        }
        EntityTeleportationBackend.createSpaceForPlayer(world, mutableBlockPos);
        return mutableBlockPos;
    }

    private static void createSpaceForPlayer(class_1937 world, class_2338.class_2339 mutableBlockPos) {
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.generateBeenest) {
            world.method_8501((class_2338)mutableBlockPos, class_2246.field_20421.method_9564());
        } else if (world.method_8320((class_2338)mutableBlockPos).method_26207() == class_3614.field_15959 || !world.method_8320((class_2338)mutableBlockPos).method_26227().method_15769() && !world.method_8320((class_2338)mutableBlockPos).method_26227().method_15767(class_3486.field_15517)) {
            world.method_8501((class_2338)mutableBlockPos, class_2246.field_21212.method_9564());
        }
        world.method_8501(mutableBlockPos.method_10084(), class_2246.field_10124.method_9564());
    }

    private static class_2338 validPlayerSpawnLocation(class_1937 world, class_2338 position, int maximumRange) {
        class_2338.class_2339 currentPos = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        for (int range = 0; range < maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = 0; y <= range * 2; ++y) {
                int y2 = y > range ? -(y - range) : y;
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        int z2 = z > range ? -(z - range) : z;
                        int distanceSq = x2 * x2 + z2 * z2 + y2 * y2;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.method_10101((class_2382)position.method_10069(x2, y2, z2));
                        if (!world.method_8320(currentPos.method_10074()).method_26225() || !world.method_8320((class_2338)currentPos).method_26215() || !world.method_8320(currentPos.method_10084()).method_26215()) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    public static boolean isValidBeeHive(class_2680 block) {
        if (block.method_26164(BzTags.BLACKLISTED_TELEPORTATION_HIVES)) {
            return false;
        }
        return block.method_26164(class_3481.field_20340) || block.method_26204() instanceof class_4481;
    }

    public static void entityChangingDimension(class_2960 dimensionEntering, class_1297 entity) {
        if (dimensionEntering.equals((Object)Bumblezone.MOD_DIMENSION_ID) && entity instanceof class_1309) {
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).setNonBZDimension(dimensionEntering);
            ((EntityComponent)Bumblezone.ENTITY_COMPONENT.get((Object)entity)).setNonBZPos(entity.method_19538());
        }
    }
}

