/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_4466;
import net.minecraft.class_5321;

public class BeeAggression {
    private static final Set<String> LIST_OF_BEE_HATING_NAMES = Set.of("bear", "panda", "wasp", "spider");
    private static final Set<class_1299<?>> SET_OF_BEE_HATED_NAMED_ENTITIES = new HashSet();
    private static final Set<class_1299<?>> SET_OF_BEE_NAMED_ENTITIES = new HashSet();

    public static void setupEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> BeeAggression.setupBeeHatingList());
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> BeeAggression.blockBreakAnger(playerEntity, blockState.method_26204()));
    }

    public static void setupBeeHatingList() {
        if (SET_OF_BEE_HATED_NAMED_ENTITIES.size() != 0) {
            return;
        }
        if (SET_OF_BEE_NAMED_ENTITIES.size() != 0) {
            return;
        }
        for (Map.Entry entry : class_2378.field_11145.method_29722()) {
            String mobName = ((class_5321)entry.getKey()).method_29177().method_12832();
            if (mobName.contains("bee")) {
                SET_OF_BEE_NAMED_ENTITIES.add((class_1299)entry.getValue());
            }
            if (!LIST_OF_BEE_HATING_NAMES.stream().anyMatch(mobName::contains)) continue;
            SET_OF_BEE_HATED_NAMED_ENTITIES.add((class_1299)entry.getValue());
        }
    }

    public static void blockBreakAnger(class_1657 player, class_2248 block) {
        if (block.method_9564().method_26164(BzTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED)) {
            BeeAggression.angerBees(player);
        }
    }

    public static void itemPickupAnger(class_1657 player, class_1792 item) {
        if (item.method_7854().method_31573(BzTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP)) {
            BeeAggression.angerBees(player);
        }
    }

    private static void angerBees(class_1657 player) {
        if ((player.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone) && Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees && !player.method_7337() && !player.method_7325() && !player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
            player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 2, false, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.showWrathOfTheHiveParticles, true));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void beeHitAndAngered(class_1297 entity, class_1297 attackerEntity) {
        if (entity.field_6002.method_8608()) return;
        if (!(entity instanceof class_4466)) return;
        if (attackerEntity == null) return;
        if (attackerEntity instanceof class_1657) {
            class_1657 player = (class_1657)attackerEntity;
            if (!((class_1657)attackerEntity).method_7337() && !attackerEntity.method_7325()) {
                if (player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    player.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
                    WrathOfTheHiveEffect.calmTheBees(player.field_6002, (class_1309)player);
                    return;
                }
                if (!entity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                    if (!Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone) return;
                }
                if (!Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees) return;
                if (player instanceof class_3222 && player.method_6059(BzEffects.WRATH_OF_THE_HIVE)) {
                    BzCriterias.EXTENDED_WRATH_OF_THE_HIVE_TRIGGER.trigger((class_3222)player, attackerEntity);
                }
                player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 2, false, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.showWrathOfTheHiveParticles, true));
                return;
            }
        }
        if (!(attackerEntity instanceof class_1308)) return;
        class_1308 mob = (class_1308)attackerEntity;
        if (mob.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
            mob.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
            WrathOfTheHiveEffect.calmTheBees(mob.field_6002, (class_1309)mob);
            return;
        }
        if (!entity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (!Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone) return;
        }
        if (!Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees) return;
        mob.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 2, false, true));
    }

    public static void entityTypeBeeAnger(class_1297 entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((class_1308)entity).method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 1, false, true));
        }
    }

    public static boolean doesBeesHateEntity(class_1297 entity) {
        if (entity != null && entity.field_6002 != null && !entity.field_6002.method_8608() && entity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) && Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees && entity instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            if (SET_OF_BEE_HATED_NAMED_ENTITIES.contains(entity.method_5864()) || !SET_OF_BEE_NAMED_ENTITIES.contains(entity.method_5864()) && mobEntity.method_6046() == class_1310.field_6293) {
                return !mobEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE);
            }
        }
        return false;
    }

    public static void playerTick(class_1657 playerEntity) {
        if (!playerEntity.field_6002.method_8608() && playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE) && !Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone && !playerEntity.field_6002.method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            playerEntity.method_6016(BzEffects.WRATH_OF_THE_HIVE);
            WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
        }
        if (playerEntity.field_6002.method_8608()) {
            boolean wrathEffect = playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE);
            if (wrathEffect) {
                if (Bumblezone.BZ_CONFIG.BZClientConfig.playWrathOfHiveEffectMusic) {
                    MusicHandler.playAngryBeeMusic(playerEntity);
                } else {
                    MusicHandler.stopAngryBeeMusic(playerEntity);
                }
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.stopAngryBeeMusic(playerEntity);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }
}

