/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class FluidClientOverlay {
    private static final class_2960 TEXTURE_UNDERWATER = new class_2960("the_bumblezone", "textures/misc/sugar_water_underwater.png");
    private static final class_2960 HONEY_TEXTURE_UNDERWATER = new class_2960("the_bumblezone:textures/misc/honey_fluid_underwater.png");

    public static boolean sugarWaterFluidOverlay(class_1657 player, class_4587 matrixStack) {
        if (!(player instanceof class_746)) {
            return false;
        }
        class_746 clientPlayerEntity = (class_746)player;
        class_2680 state = player.field_6002.method_8320(new class_2338(player.method_5836(0.0f)));
        if (state.method_27852(BzFluids.SUGAR_WATER_BLOCK)) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.enableTexture();
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_UNDERWATER);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            float brightnessAtEyes = clientPlayerEntity.method_5718();
            float textureAlpha = 0.42f;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)brightnessAtEyes, (float)brightnessAtEyes, (float)brightnessAtEyes, (float)textureAlpha);
            float modifiedYaw = -clientPlayerEntity.method_36454() / 64.0f;
            float modifiedPitch = clientPlayerEntity.method_36455() / 64.0f;
            class_1159 matrix4f = matrixStack.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f, -1.0f, -1.0f, -0.5f).method_22913(4.0f + modifiedYaw, 4.0f + modifiedPitch).method_1344();
            bufferBuilder.method_22918(matrix4f, 1.0f, -1.0f, -0.5f).method_22913(0.0f + modifiedYaw, 4.0f + modifiedPitch).method_1344();
            bufferBuilder.method_22918(matrix4f, 1.0f, 1.0f, -0.5f).method_22913(0.0f + modifiedYaw, 0.0f + modifiedPitch).method_1344();
            bufferBuilder.method_22918(matrix4f, -1.0f, 1.0f, -0.5f).method_22913(4.0f + modifiedYaw, 0.0f + modifiedPitch).method_1344();
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    public static boolean renderHoneyOverlay(class_746 clientPlayerEntity, class_4587 matrixStack) {
        if (!clientPlayerEntity.method_5777(BzTags.BZ_HONEY_FLUID)) {
            return false;
        }
        class_2680 state = clientPlayerEntity.field_6002.method_8320(new class_2338(clientPlayerEntity.method_5836(1.0f)));
        if (state.method_27852(BzFluids.HONEY_FLUID_BLOCK)) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.enableTexture();
            RenderSystem.setShaderTexture((int)0, (class_2960)HONEY_TEXTURE_UNDERWATER);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes((class_1297)clientPlayerEntity), 2.0), (double)clientPlayerEntity.field_6002.method_8597().method_28516(0));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.95f);
            float modifiedYaw = -clientPlayerEntity.method_36454() / 512.0f;
            float modifiedPitch = clientPlayerEntity.method_36455() / 512.0f;
            class_1159 matrix4f = matrixStack.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f, -1.0f, -1.0f, -0.5f).method_22913(1.0f + modifiedYaw, 1.0f + modifiedPitch).method_1344();
            bufferBuilder.method_22918(matrix4f, 1.0f, -1.0f, -0.5f).method_22913(0.0f + modifiedYaw, 2.0f + modifiedPitch).method_1344();
            bufferBuilder.method_22918(matrix4f, 1.0f, 1.0f, -0.5f).method_22913(1.0f + modifiedYaw, 1.0f + modifiedPitch).method_1344();
            bufferBuilder.method_22918(matrix4f, -1.0f, 1.0f, -0.5f).method_22913(2.0f + modifiedYaw, 0.0f + modifiedPitch).method_1344();
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    public static void renderHoneyFog(class_4184 camera) {
        class_3610 fluidstate = FluidClientOverlay.getNearbyHoneyFluid(camera);
        if (fluidstate.method_15767(BzTags.BZ_HONEY_FLUID)) {
            RenderSystem.setShaderFogStart((float)0.35f);
            RenderSystem.setShaderFogEnd((float)4.0f);
        }
    }

    public static float getDimensionBrightnessAtEyes(class_1297 entity) {
        float lightLevelAtEyes = entity.field_6002.method_22335(new class_2338(entity.method_5836(1.0f)), 0);
        return lightLevelAtEyes / 15.0f;
    }

    public static class_3610 getNearbyHoneyFluid(class_4184 camera) {
        class_1297 entity = camera.method_19331();
        class_1937 world = entity.field_6002;
        class_3610 fluidstate = world.method_8316(camera.method_19328());
        class_243 currentPos = camera.method_19326();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        double offsetDistanceCheck = 0.075;
        for (class_2350 direction : class_2350.values()) {
            class_3610 neighboringFluidstate;
            double x = currentPos.method_10216() + (double)direction.method_10148() * offsetDistanceCheck;
            double y = currentPos.method_10214() + (double)direction.method_10164() * offsetDistanceCheck;
            double z = currentPos.method_10215() + (double)direction.method_10165() * offsetDistanceCheck;
            mutable.method_10102(x, y, z);
            if (mutable.equals((Object)camera.method_19328()) || !(neighboringFluidstate = world.method_8316((class_2338)mutable)).method_15767(BzTags.BZ_HONEY_FLUID)) continue;
            fluidstate = neighboringFluidstate;
        }
        return fluidstate;
    }
}

