/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import architectury_inject_AdAstra_common_ce6bb8e55c1d4e31a5973d617a758f0d_ae41c5e4ab0f0374edc71f4a07262552977537027412595f7a4bda850f58988cadastra1141devjar.PlatformMethods;
import com.mojang.serialization.Codec;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.entity.vehicle.Lander;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.item.vehicle.VehicleItem;
import earth.terrarium.ad_astra.common.registry.ModCriteria;
import earth.terrarium.ad_astra.common.registry.ModEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.PlatformUtils;
import earth.terrarium.ad_astra.common.util.algorithm.LandFinder;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3862;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class ModUtils {
    public static final class_5321<class_1937> MOON_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "moon"));
    public static final class_5321<class_1937> MARS_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "mars"));
    public static final class_5321<class_1937> VENUS_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "venus"));
    public static final class_5321<class_1937> MERCURY_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "mercury"));
    public static final class_5321<class_1937> GLACIO_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("ad_astra", "glacio"));
    public static final float VANILLA_GRAVITY = 9.806f;
    public static final float ORBIT_TEMPERATURE = -270.0f;

    public static void teleportToLevel(class_5321<class_1937> targetWorld, class_1297 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 oldWorld = (class_3218)class_19372;
            class_3218 level = oldWorld.method_8503().method_3847(targetWorld);
            if (level == null) {
                return;
            }
            LinkedHashSet<Object> entitiesToTeleport = new LinkedHashSet<Object>();
            class_243 targetPos = new class_243(entity.method_23317(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, entity.method_23321());
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                class_1297 class_12972 = player.method_5854();
                if (class_12972 instanceof Rocket) {
                    Rocket rocket = (Rocket)class_12972;
                    rocket.method_5772();
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.ad_astra.hold_space"), false);
                    entity = ModUtils.createLander(rocket, level, targetPos);
                    rocket.method_31472();
                    entitiesToTeleport.add(entity);
                    entitiesToTeleport.add(player);
                } else if (player.method_5854() == null || player.method_5854().method_5685().size() <= 0) {
                    entitiesToTeleport.add(entity);
                }
            } else {
                entitiesToTeleport.add(entity);
            }
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                ModUtils.cookFood(itemEntity);
            }
            entitiesToTeleport.addAll(entity.method_5685());
            for (Object entityToTeleport : entitiesToTeleport) {
                if (!(entityToTeleport instanceof class_3222)) continue;
                class_1923 class_19232 = new class_1923(class_2338.method_49638((class_2374)targetPos));
                level.method_14178().method_17297(class_3230.field_19347, class_19232, 1, (Object)entityToTeleport.method_5628());
                break;
            }
            LinkedList<class_1297> teleportedEntities = new LinkedList<class_1297>();
            for (class_1297 class_12972 : entitiesToTeleport) {
                class_5454 target = new class_5454(targetPos, class_12972.method_18798(), class_12972.method_36454(), class_12972.method_36455());
                teleportedEntities.add(PlatformUtils.teleportToDimension(class_12972, level, target));
            }
            class_1297 first = (class_1297)teleportedEntities.poll();
            if (first instanceof Lander) {
                class_243 class_2432 = LandFinder.findNearestLand(first.method_37908(), new class_243(first.method_23317(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, first.method_23321()), 70);
                first.method_5808(class_2432.method_10216(), class_2432.method_10214(), class_2432.method_10215(), first.method_36454(), first.method_36455());
            }
            for (class_1297 teleportedEntity : teleportedEntities) {
                if (first instanceof Lander) {
                    class_243 nearestLand = LandFinder.findNearestLand(teleportedEntity.method_37908(), new class_243(teleportedEntity.method_23317(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, teleportedEntity.method_23321()), 70);
                    teleportedEntity.method_5808(nearestLand.method_10216(), nearestLand.method_10214(), nearestLand.method_10215(), teleportedEntity.method_36454(), teleportedEntity.method_36455());
                }
                if (teleportedEntity == null) continue;
                teleportedEntity.method_5873(first, true);
            }
        }
    }

    public static void teleportPlayer(class_5321<class_1937> targetWorld, class_3222 player) {
        class_3218 level = player.method_5682().method_3847(targetWorld);
        class_243 targetPos = new class_243((double)player.method_24515().method_10263(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, (double)player.method_24515().method_10260());
        class_1923 chunkPos = new class_1923(class_2338.method_49638((class_2374)targetPos));
        level.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)player.method_5628());
        class_5454 target = new class_5454(targetPos, player.method_18798(), player.method_36454(), player.method_36455());
        PlatformUtils.teleportToDimension(player, level, target);
    }

    public static Lander createLander(Rocket rocket, class_3218 targetWorld, class_243 target) {
        Lander lander = new Lander((class_1299)ModEntityTypes.LANDER.get(), (class_1937)targetWorld);
        lander.method_33574(target);
        for (int i = 0; i < rocket.getInventorySize(); ++i) {
            lander.getInventory().method_5447(i, rocket.getInventory().method_5438(i));
        }
        ItemStackHolder stack = new ItemStackHolder(rocket.getDropStack());
        ((VehicleItem)stack.getStack().method_7909()).insert(stack, rocket.getTankHolder());
        lander.getInventory().method_5447(10, stack.getStack());
        if (PlatformMethods.getCurrentTarget().equals("fabric")) {
            targetWorld.method_8649((class_1297)lander);
        }
        return lander;
    }

    public static void cookFood(class_1542 itemEntity) {
        class_1799 stack = itemEntity.method_6983();
        class_1799 foodOutput = class_1799.field_8037;
        for (class_3862 recipe : itemEntity.method_37908().method_8433().method_30027(class_3956.field_17548)) {
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!ingredient.method_8093(stack)) continue;
                foodOutput = recipe.method_8110(itemEntity.method_37908().method_30349());
            }
        }
        if (!foodOutput.method_7960()) {
            itemEntity.method_6979(new class_1799((class_1935)foodOutput.method_7909(), stack.method_7947()));
            class_1297 entity = itemEntity.method_24921();
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ModCriteria.FOOD_COOKED_IN_ATMOSPHERE.trigger(player);
            }
        }
    }

    public static class_5321<class_1937> getPlanetOrbit(class_1937 level) {
        return PlanetData.getPlanetFromOrbit((class_5321<class_1937>)level.method_27983()).map(Planet::level).orElse(class_1937.field_25179);
    }

    public static float getEntityGravity(class_1297 entity) {
        return ModUtils.getPlanetGravity(entity.method_37908());
    }

    public static float getPlanetGravity(class_1937 level) {
        if (!ModUtils.isSpacelevel(level)) {
            return 1.0f;
        }
        if (ModUtils.isOrbitlevel(level)) {
            return AdAstraConfig.orbitGravity / 9.806f;
        }
        return PlanetData.getPlanetFromLevel((class_5321<class_1937>)level.method_27983()).map(Planet::gravity).orElse(Float.valueOf(9.806f)).floatValue() / 9.806f;
    }

    public static boolean planetHasAtmosphere(class_1937 level) {
        return PlanetData.getPlanetFromLevel((class_5321<class_1937>)level.method_27983()).map(Planet::hasAtmosphere).orElse(false);
    }

    public static float getWorldTemperature(class_1937 level) {
        if (ModUtils.isOrbitlevel(level)) {
            return -270.0f;
        }
        return PlanetData.getPlanetFromLevel((class_5321<class_1937>)level.method_27983()).map(Planet::temperature).orElse(Float.valueOf(20.0f)).floatValue();
    }

    public static boolean isSpacelevel(class_1937 level) {
        return ModUtils.isPlanet(level) || ModUtils.isOrbitlevel(level);
    }

    public static boolean isPlanet(class_1937 level) {
        if (AdAstraConfig.avoidOverworldChecks && class_1937.field_25179.equals(level.method_27983())) {
            return false;
        }
        return PlanetData.isPlanetLevel(level);
    }

    public static boolean isOrbitlevel(class_1937 level) {
        return PlanetData.isOrbitLevel((class_5321<class_1937>)level.method_27983());
    }

    public static <T extends class_2394> void spawnForcedParticles(class_3218 level, T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        for (class_3222 player : level.method_18456()) {
            level.method_14166(player, particle, true, x, y, z, count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public static void rotateVehicleYaw(Vehicle vehicle, float newYaw) {
        vehicle.method_36456(newYaw);
        vehicle.method_5636(newYaw);
        vehicle.field_5982 = newYaw;
    }

    public static boolean checkTag(class_1297 entity, class_6862<class_1299<?>> tag) {
        return entity.method_5864().method_20210(tag);
    }

    public static boolean checkTag(class_1799 stack, class_6862<class_1792> tag) {
        return stack.method_31573(tag);
    }

    public static boolean armourIsFreezeResistant(class_1309 entity) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(s -> s.method_31573(ModTags.FREEZE_RESISTANT));
    }

    public static boolean armourIsHeatResistant(class_1309 entity) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(s -> s.method_31573(ModTags.HEAT_RESISTANT));
    }

    public static boolean armourIsOxygenated(class_1309 entity) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(s -> s.method_31573(ModTags.OXYGENATED_ARMOR));
    }

    public static long getSolarEnergy(class_1937 level) {
        if (ModUtils.isOrbitlevel(level)) {
            return PlanetData.getPlanetFromOrbit((class_5321<class_1937>)level.method_27983()).map(Planet::orbitSolarPower).orElse(15L);
        }
        if (ModUtils.isPlanet(level)) {
            return PlanetData.getPlanetFromLevel((class_5321<class_1937>)level.method_27983()).map(Planet::solarPower).orElse(15L);
        }
        return 15L;
    }

    public static <T extends Enum<T>> Codec<T> createEnumCodec(Class<T> enumClass) {
        return Codec.STRING.xmap(s -> Enum.valueOf(enumClass, s.toUpperCase(Locale.ROOT)), Enum::name);
    }

    public static void sendUpdatePacket(class_3222 player) {
        player.field_6037 = true;
    }
}

