/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item.armor;

import earth.terrarium.ad_astra.common.config.SpaceSuitConfig;
import earth.terrarium.ad_astra.common.item.FluidContainingItem;
import earth.terrarium.ad_astra.common.item.armor.ModArmourItem;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4057;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.NotNull;

public class SpaceSuit
extends class_4057
implements FluidContainingItem,
ModArmourItem {
    public SpaceSuit(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 properties) {
        super(material, type, properties);
    }

    public static boolean hasFullSet(class_1309 entity) {
        int slotCount = 0;
        int armorCount = 0;
        for (class_1799 stack : entity.method_5661()) {
            ++slotCount;
            if (!(stack.method_7909() instanceof SpaceSuit)) continue;
            ++armorCount;
        }
        return slotCount > 0 && armorCount == slotCount;
    }

    public static boolean hasOxygenatedSpaceSuit(class_1309 entity) {
        class_1799 chest = entity.method_6118(class_1304.field_6174);
        class_1792 class_17922 = chest.method_7909();
        if (class_17922 instanceof SpaceSuit) {
            SpaceSuit suit = (SpaceSuit)class_17922;
            return suit.getFluidAmount(chest) > 0L;
        }
        return false;
    }

    public static void consumeSpaceSuitOxygen(class_1309 entity, long amount) {
        ItemStackHolder chest = new ItemStackHolder(entity.method_6118(class_1304.field_6174));
        class_1792 class_17922 = chest.getStack().method_7909();
        if (class_17922 instanceof SpaceSuit) {
            SpaceSuit suit = (SpaceSuit)class_17922;
            suit.extract(chest, FluidHooks.newFluidHolder((class_3611)suit.getFluid(chest.getStack()), (long)amount, null));
            if (chest.isDirty()) {
                entity.method_5673(class_1304.field_6174, chest.getStack());
            }
        }
    }

    public void method_7851(class_1799 stack, class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        if (stack.method_31574((class_1792)ModItems.SPACE_SUIT.get()) || stack.method_31574((class_1792)ModItems.NETHERITE_SPACE_SUIT.get()) || stack.method_31574((class_1792)ModItems.JET_SUIT.get())) {
            long oxygen = FluidHooks.toMillibuckets((long)FluidHooks.getItemFluidManager((class_1799)stack).getFluidInTank(0).getFluidAmount());
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.ad_astra.space_suit", (Object[])new Object[]{oxygen, FluidHooks.toMillibuckets((long)this.getTankSize())}).method_10862(class_2583.field_24360.method_10977(oxygen > 0L ? class_124.field_1060 : class_124.field_1061)));
        }
    }

    @Override
    public long getTankSize() {
        return SpaceSuitConfig.spaceSuitTankSize;
    }

    @Override
    public BiPredicate<Integer, FluidHolder> getFilter() {
        return (i, f) -> f.getFluid().method_15791(ModTags.OXYGEN);
    }

    public Range<Integer> getTemperatureThreshold() {
        return Range.between((Comparable)Integer.valueOf(-300), (Comparable)Integer.valueOf(60));
    }

    public int method_7800(@NotNull class_1799 stack) {
        int colour = super.method_7800(stack);
        return colour == 10511680 ? 0xFFFFFF : colour;
    }

    @Override
    public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
        return new class_2960("ad_astra", "textures/entity/armour/space_suit.png").toString();
    }
}

