/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item.armor;

import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.config.SpaceSuitConfig;
import earth.terrarium.ad_astra.common.item.armor.NetheriteSpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.util.ModKeyBindings;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.common.energy.base.EnergyAttachment;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.PlatformItemEnergyManager;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedItemEnergyContainer;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_572;
import org.jetbrains.annotations.NotNull;

public class JetSuit
extends NetheriteSpaceSuit
implements EnergyAttachment.Item {
    private boolean isFallFlying;
    private boolean emitParticles;

    public JetSuit(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 properties) {
        super(material, type, properties);
    }

    public void spawnParticles(class_1937 level, class_1309 entity, class_572<class_1309> model) {
        if (!SpaceSuitConfig.spawnJetSuitParticles || !this.emitParticles) {
            return;
        }
        this.spawnParticles(level, entity, (double)model.field_3401.field_3654 + 0.05, entity.method_6128() ? 0.0 : 0.8, -0.45);
        this.spawnParticles(level, entity, (double)model.field_27433.field_3654 + 0.05, entity.method_6128() ? 0.0 : 0.8, 0.45);
        this.spawnParticles(level, entity, (double)model.field_3392.field_3654 + 0.05, entity.method_6128() ? 0.1 : 0.0, -0.1);
        this.spawnParticles(level, entity, (double)model.field_3397.field_3654 + 0.05, entity.method_6128() ? 0.1 : 0.0, 0.1);
    }

    private void spawnParticles(class_1937 level, class_1309 entity, double pitch, double yOffset, double zOffset) {
        double yaw = entity.field_6283;
        double xRotator = Math.cos(yaw * Math.PI / 180.0) * zOffset;
        double zRotator = Math.sin(yaw * Math.PI / 180.0) * zOffset;
        double xRotator1 = Math.cos((yaw - 90.0) * Math.PI / 180.0) * pitch;
        double zRotator1 = Math.sin((yaw - 90.0) * Math.PI / 180.0) * pitch;
        level.method_8466((class_2394)class_2398.field_22246, true, entity.method_23317() + xRotator + xRotator1, entity.method_23318() + yOffset, entity.method_23321() + zRotator1 + zRotator, 0.0, 0.0, 0.0);
    }

    public static boolean hasFullSet(class_1309 entity) {
        for (class_1799 stack : entity.method_5661()) {
            if (stack.method_7909() instanceof JetSuit) continue;
            return false;
        }
        return true;
    }

    public static void updateBatteryOverlay(class_1799 suit) {
        PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((class_1799)suit);
        PlayerOverlayScreen.batteryRatio = (double)energy.getStoredEnergy() / (double)energy.getCapacity();
    }

    @Override
    public long getTankSize() {
        return SpaceSuitConfig.jetSuitTankSize;
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        super.method_7851(stack, level, tooltip, context);
        if (stack.method_31574((class_1792)ModItems.JET_SUIT.get())) {
            long energy = EnergyHooks.getItemEnergyManager((class_1799)stack).getStoredEnergy();
            tooltip.add((class_2561)class_2561.method_43469((String)"gauge_text.ad_astra.storage", (Object[])new Object[]{energy, SpaceSuitConfig.jetSuitMaxEnergy}).method_10862(class_2583.field_24360.method_10977(energy > 0L ? class_124.field_1060 : class_124.field_1061)));
        }
    }

    public void fly(class_1657 player, class_1799 stack) {
        this.emitParticles = false;
        if (!SpaceSuitConfig.enableJetSuitFlight) {
            return;
        }
        ItemStackHolder stackHolder = new ItemStackHolder(stack);
        if (player.method_31549().field_7479) {
            return;
        }
        if (EnergyHooks.getItemEnergyManager((class_1799)stack).getStoredEnergy() <= 0L) {
            return;
        }
        if (ModKeyBindings.sprintKeyDown(player)) {
            this.fallFly(player, stackHolder);
        } else {
            this.flyUpward(player, stackHolder);
        }
        if (this.isFallFlying) {
            if (!player.method_6128()) {
                player.method_23669();
            }
        } else if (player.method_6128()) {
            player.method_23670();
        }
        this.emitParticles = true;
        if (stackHolder.isDirty()) {
            player.method_5673(class_1304.field_6174, stackHolder.getStack());
        }
        ModUtils.sendUpdatePacket((class_3222)player);
    }

    public void flyUpward(class_1657 player, ItemStackHolder stack) {
        if (EnergyHooks.isEnergyItem((class_1799)stack.getStack())) {
            player.field_6017 /= 2.0f;
            PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((class_1799)stack.getStack());
            long tickEnergy = SpaceSuitConfig.jetSuitEnergyPerTick;
            if (!player.method_7337()) {
                energy.extract(stack, tickEnergy, false);
            }
            this.isFallFlying = false;
            double speed = SpaceSuitConfig.jetSuitUpwardsSpeed;
            player.method_18799(player.method_18798().method_1031(0.0, speed, 0.0));
            if (player.method_18798().method_10214() > speed) {
                player.method_18800(player.method_18798().method_10216(), speed, player.method_18798().method_10215());
            }
        }
    }

    public void fallFly(class_1657 player, ItemStackHolder stack) {
        if (player.method_24828()) {
            player.field_6017 /= 2.0f;
        }
        PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((class_1799)stack.getStack());
        long tickEnergy = SpaceSuitConfig.jetSuitEnergyPerTick;
        if (!player.method_7337()) {
            energy.extract(stack, tickEnergy, false);
        }
        this.isFallFlying = true;
        double speed = SpaceSuitConfig.jetSuitSpeed - (double)ModUtils.getEntityGravity((class_1297)player) * 0.25;
        class_243 rotationVector = player.method_5720().method_1021(speed);
        class_243 velocity = player.method_18798();
        player.method_18799(velocity.method_1031(rotationVector.method_10216() * 0.1 + (rotationVector.method_10216() * 1.5 - velocity.method_10216()) * 0.5, rotationVector.method_10214() * 0.1 + (rotationVector.method_10214() * 1.5 - velocity.method_10214()) * 0.5, rotationVector.method_10215() * 0.1 + (rotationVector.method_10215() * 1.5 - velocity.method_10215()) * 0.5));
    }

    public WrappedItemEnergyContainer getEnergyStorage(class_1799 holder) {
        return new WrappedItemEnergyContainer(holder, (EnergyContainer)new SimpleEnergyContainer(SpaceSuitConfig.jetSuitMaxEnergy){

            public long maxInsert() {
                return 512L;
            }

            public long maxExtract() {
                return 256L;
            }
        });
    }

    @Override
    public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
        if (!slot.equals((Object)class_1304.field_6174)) {
            return new class_2960("ad_astra", "textures/entity/armour/jet_suit/jet_suit_5.png").toString();
        }
        if (stack.method_7909() instanceof JetSuit) {
            PlatformItemEnergyManager energy = EnergyHooks.getItemEnergyManager((class_1799)stack);
            return new class_2960("ad_astra", "textures/entity/armour/jet_suit/jet_suit_" + (energy.getStoredEnergy() <= 0L ? 0 : (int)Math.min(energy.getStoredEnergy() * 5L / Math.max(1L, energy.getCapacity()) + 1L, 5L)) + ".png").toString();
        }
        return new class_2960("ad_astra", "textures/entity/armour/jet_suit/jet_suit_5.png").toString();
    }

    public void setFallFlying(boolean fallFlying) {
        this.isFallFlying = fallFlying;
    }

    public boolean setEmitParticles(boolean emitParticles) {
        this.emitParticles = emitParticles;
        return this.emitParticles;
    }

    private static /* synthetic */ void lambda$elytraFlightTick$0(class_1309 e) {
        e.method_20235(class_1304.field_6174);
    }
}

