/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.networking.PacketHelper;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.networking.NetworkHandling;
import earth.terrarium.ad_astra.common.networking.packet.client.RequestPlanetDataPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import org.slf4j.Logger;

public class PlanetData
extends class_4309 {
    private static final Set<Planet> PLANETS = new HashSet<Planet>();
    private static final Map<class_5321<class_1937>, Planet> LEVEL_TO_PLANET = new HashMap<class_5321<class_1937>, Planet>();
    private static final Map<class_5321<class_1937>, Planet> ORBIT_TO_PLANET = new HashMap<class_5321<class_1937>, Planet>();
    private static final Set<class_5321<class_1937>> PLANET_LEVELS = new HashSet<class_5321<class_1937>>();
    private static final Set<class_5321<class_1937>> ORBITS_LEVELS = new HashSet<class_5321<class_1937>>();
    private static final Set<class_5321<class_1937>> OXYGEN_LEVELS = new HashSet<class_5321<class_1937>>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public PlanetData() {
        super(GSON, "planet_data/planets");
    }

    protected void apply(Map<class_2960, JsonElement> objects, class_3300 resourceManager, class_3695 profiler) {
        profiler.method_15396("Ad Astra Planet Deserialization");
        ArrayList<Planet> planets = new ArrayList<Planet>();
        for (Map.Entry<class_2960, JsonElement> entry : objects.entrySet()) {
            JsonObject jsonObject = class_3518.method_15295((JsonElement)entry.getValue(), (String)"planet");
            Planet newPlanet = (Planet)Planet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
            planets.removeIf(planet -> planet.level().equals(newPlanet.level()));
            planets.add(newPlanet);
        }
        PlanetData.updatePlanets(planets);
        profiler.method_15407();
    }

    public static void updatePlanets(Collection<Planet> planets) {
        PlanetData.clear();
        for (Planet planet : new HashSet<Planet>(planets)) {
            PLANETS.add(planet);
            LEVEL_TO_PLANET.put(planet.level(), planet);
            ORBIT_TO_PLANET.put(planet.orbitWorld(), planet);
            PLANET_LEVELS.add(planet.level());
            ORBITS_LEVELS.add(planet.orbitWorld());
            if (!planet.hasOxygen()) continue;
            OXYGEN_LEVELS.add(planet.level());
        }
    }

    private static void clear() {
        PLANETS.clear();
        LEVEL_TO_PLANET.clear();
        ORBIT_TO_PLANET.clear();
        ORBITS_LEVELS.clear();
        OXYGEN_LEVELS.clear();
    }

    public static void writePlanetData(class_2540 buf) {
        PacketHelper.writeWithYabn((class_2540)buf, (Codec)Planet.CODEC.listOf(), PlanetData.planets().stream().toList(), (boolean)true).get().mapRight(DataResult.PartialResult::message).ifRight(arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
    }

    public static void readPlanetData(class_2540 buf) {
        PacketHelper.readWithYabn((class_2540)buf, (Codec)Planet.CODEC.listOf(), (boolean)true).get().ifLeft(PlanetData::updatePlanets).mapRight(DataResult.PartialResult::message).ifRight(arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
    }

    public static Set<Planet> planets() {
        return PLANETS;
    }

    public static Optional<Planet> getPlanetFromLevel(class_5321<class_1937> level) {
        return Optional.ofNullable(LEVEL_TO_PLANET.get(level));
    }

    public static Optional<Planet> getPlanetFromOrbit(class_5321<class_1937> level) {
        return Optional.ofNullable(ORBIT_TO_PLANET.get(level));
    }

    public static boolean isOrbitLevel(class_5321<class_1937> level) {
        return ORBITS_LEVELS.contains(level);
    }

    public static boolean isPlanetLevel(class_1937 level) {
        if (level.field_9236 && !AdAstraClient.hasUpdatedPlanets) {
            NetworkHandling.CHANNEL.sendToServer((Packet)new RequestPlanetDataPacket());
            AdAstraClient.hasUpdatedPlanets = true;
        }
        return PLANET_LEVELS.contains(level.method_27983());
    }

    public static boolean isOxygenated(class_5321<class_1937> level) {
        return OXYGEN_LEVELS.contains(level);
    }
}

