/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.ad_astra.common.compat.emi.EmiFluidBarWidget;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class EmiTextures {
    public static final class_2960 ENERGY_EMPTY = new class_2960("ad_astra", "textures/gui/energy_bar_empty.png");
    public static final class_2960 ENERGY_FULL = new class_2960("ad_astra", "textures/gui/energy_full.png");
    public static final class_2960 FLUID_TANK_BACK = new class_2960("ad_astra", "textures/gui/fluid_tank_back.png");
    public static final class_2960 FLUID_TANK_OVERLAY = new class_2960("ad_astra", "textures/gui/fluid_tank.png");
    public static final EmiTexture EMPTY_ENERGY_TEXTURE = new EmiTexture(ENERGY_EMPTY, 0, 0, 19, 64, 19, 64, 19, 64);
    public static final EmiTexture FULL_ENERGY_TEXTURE = new EmiTexture(ENERGY_FULL, 0, 0, 13, 46, 13, 46, 13, 46);
    public static final EmiTexture FLUID_TANK_EMPTY_TEXTURE = new EmiTexture(FLUID_TANK_BACK, 0, 0, 24, 59, 24, 59, 24, 59);
    public static final EmiTexture FLUID_TANK_OVERLAY_TEXTURE = new EmiTexture(FLUID_TANK_OVERLAY, 0, 0, 12, 46, 12, 46, 12, 46);

    public static void createEnergyWidget(WidgetHolder widgets, int x, int y, int energyPerTick, boolean increase) {
        widgets.addTexture(EMPTY_ENERGY_TEXTURE, x, y).tooltip((mx, my) -> List.of(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)(increase ? "rei.tooltip.ad_astra.energy_generating" : "rei.tooltip.ad_astra.energy_using"), (Object[])new Object[]{energyPerTick})))));
        widgets.addAnimatedTexture(FULL_ENERGY_TEXTURE, x + 3, y + 8, 250000 / energyPerTick, false, true, !increase);
    }

    public static void createFluidWidget(WidgetHolder widgets, int x, int y, FluidVariant fluid, int speed, boolean increase) {
        widgets.addTexture(FLUID_TANK_EMPTY_TEXTURE, x, y).tooltip((mx, my) -> FluidVariantRendering.getTooltip((FluidVariant)fluid).stream().map(t -> class_5684.method_32662((class_5481)t.method_30937())).collect(Collectors.toList()));
        widgets.add((Widget)new EmiFluidBarWidget(x, y, fluid, speed, increase));
    }
}

