/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.AbstractMachineBlock;
import earth.terrarium.ad_astra.common.block.machine.entity.FluidMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.OxygenDistributorConfig;
import earth.terrarium.ad_astra.common.recipe.OxygenConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.screen.menu.OxygenDistributorMenu;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.ad_astra.common.util.algorithm.FloodFiller3D;
import earth.terrarium.botarium.common.energy.base.EnergyAttachment;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OxygenDistributorBlockEntity
extends FluidMachineBlockEntity
implements EnergyAttachment.Block {
    private WrappedBlockEnergyContainer energyContainer;
    private int oxygenFillCheckTicks = OxygenDistributorConfig.refreshTicks;
    private boolean showOxygen = false;

    public OxygenDistributorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.OXYGEN_DISTRIBUTOR.get(), blockPos, blockState);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.showOxygen = nbt.method_10577("ShowOxygen");
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("ShowOxygen", this.showOxygen);
    }

    public boolean shouldShowOxygen() {
        return this.showOxygen;
    }

    public void setShowOxygen(boolean value) {
        this.showOxygen = value;
    }

    @Override
    public long getInputTankCapacity() {
        return OxygenDistributorConfig.tankSize;
    }

    @Override
    public long getOutputTankCapacity() {
        return OxygenDistributorConfig.tankSize;
    }

    @Override
    public Predicate<FluidHolder> getInputFilter() {
        return f -> OxygenConversionRecipe.getRecipes(this.method_10997()).stream().anyMatch(r -> r.matches(f.getFluid()));
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new OxygenDistributorMenu(syncId, inv, this);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public int getMaxBlockChecks() {
        return OxygenDistributorConfig.maxBlockChecks;
    }

    public long getFluidToExtract(long oxygenBlocks, boolean client) {
        long value = (long)((double)(FluidHooks.buckets((double)1.0) / 1000L * oxygenBlocks / 60L) * OxygenDistributorConfig.oxygenMultiplier);
        if (client) {
            return value;
        }
        return value == 0L ? 1L : value;
    }

    public long getEnergyToConsume(long oxygenBlocks, boolean client) {
        long value = (long)((double)oxygenBlocks * OxygenDistributorConfig.energyMultiplier / 75.0);
        if (client) {
            return value;
        }
        return value == 0L ? 1L : value;
    }

    public void extractResources() {
        long oxygenBlocks = OxygenUtils.getOxygenBlocksCount(this.field_11863, this.method_11016());
        long amountOfFluidToExtract = this.getFluidToExtract(oxygenBlocks, false);
        long amountOfEnergyToConsume = this.getEnergyToConsume(oxygenBlocks, false);
        if (this.field_11863.method_8510() % 20L == 0L) {
            this.getFluidContainer(this).extractFluid(FluidHooks.newFluidHolder((class_3611)this.getOutputTank().getFluid(), (long)amountOfFluidToExtract, null), false);
        }
        if (this.getEnergyStorage(this).internalExtract(amountOfEnergyToConsume, false) > 0L) {
            ModUtils.spawnForcedParticles((class_3218)this.method_10997(), (class_2400)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.03);
        }
    }

    public boolean canDistribute(int oxygenBlocks) {
        long amountOfFluidToExtract = this.getFluidToExtract(oxygenBlocks, false);
        long amountOfEnergyToConsume = this.getEnergyToConsume(oxygenBlocks, false);
        if (this.getOutputTank().isEmpty()) {
            return false;
        }
        if (((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.POWERED)).booleanValue()) {
            return false;
        }
        if (this.getEnergyStorage(this).internalExtract(amountOfEnergyToConsume, true) == 0L) {
            return false;
        }
        if (this.getOutputTank().getFluid().equals(class_3612.field_15906)) {
            return false;
        }
        return this.getOutputTank().getFluidAmount() >= amountOfFluidToExtract;
    }

    @Override
    public void tick() {
        class_1799 insertSlot = (class_1799)this.getItems().get(0);
        class_1799 extractSlot = (class_1799)this.getItems().get(1);
        if (!this.field_11863.field_9236) {
            if (!insertSlot.method_7960() && extractSlot.method_7947() < extractSlot.method_7914() && FluidHooks.isFluidContainingItem((class_1799)insertSlot)) {
                FluidUtils.insertItemFluidToTank((FluidContainer)this.getFluidContainer(this), this, 0, 1, 0, f -> OxygenConversionRecipe.getRecipes(this.field_11863).stream().anyMatch(r -> r.matches((class_3611)f)));
                FluidUtils.extractTankFluidToItem(this.getDoubleFluidTank().getInput(), this, 0, 1, 0, f -> true);
            }
            if (this.getEnergyStorage(this).internalExtract(this.getEnergyPerTick(), true) > 0L) {
                List<OxygenConversionRecipe> recipes = OxygenConversionRecipe.getRecipes(this.field_11863);
                if (FluidUtils.convertFluid(this.getDoubleFluidTank(), recipes, FluidHooks.buckets((double)1.0) / 10L)) {
                    this.getEnergyStorage(this).internalExtract(this.getEnergyPerTick(), false);
                }
            }
        }
        if (this.oxygenFillCheckTicks >= OxygenDistributorConfig.refreshTicks) {
            this.runAlgorithm();
            this.oxygenFillCheckTicks = 0;
        } else {
            ++this.oxygenFillCheckTicks;
        }
        if (!this.field_11863.field_9236) {
            boolean active = OxygenUtils.getOxygenBlocksCount(this.field_11863, this.method_11016()) > 0;
            this.setActive(active);
            if (active) {
                this.extractResources();
            }
        }
    }

    public void runAlgorithm() {
        if (this.field_11863.method_8608() ? (Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.LIT) == false : this.getOutputTank().getFluidAmount() <= 0L && this.getEnergyStorage(this).getStoredEnergy() <= 0L) {
            return;
        }
        Set<class_2338> positions = FloodFiller3D.run(this.field_11863, this.field_11867);
        if (this.canDistribute(positions.size())) {
            OxygenUtils.setEntry(this.field_11863, this.field_11867, positions);
        } else if (!this.field_11863.method_8608()) {
            OxygenUtils.removeEntry(this.field_11863, this.method_11016());
        }
        if (this.shouldShowOxygen()) {
            this.spawnParticles(positions);
        }
    }

    public void spawnParticles(Set<class_2338> positions) {
        if (!this.field_11863.method_8608() && ((Boolean)this.method_11010().method_11654((class_2769)AbstractMachineBlock.LIT)).booleanValue()) {
            for (class_2338 pos : positions) {
                ModUtils.spawnForcedParticles((class_3218)this.method_10997(), (class_2400)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public long getEnergyPerTick() {
        return OxygenDistributorConfig.fluidConversionEnergyPerTick;
    }

    @Override
    public long getMaxCapacity() {
        return this.getEnergyStorage(this).getMaxCapacity();
    }

    @Override
    public WrappedBlockEnergyContainer getEnergyStorage(class_2586 holder) {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(OxygenDistributorConfig.maxEnergy))) : this.energyContainer;
    }
}

