/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.resourcepack.Galaxy;
import earth.terrarium.ad_astra.client.resourcepack.PlanetRing;
import earth.terrarium.ad_astra.client.resourcepack.SolarSystem;
import earth.terrarium.ad_astra.client.screen.util.ButtonType;
import earth.terrarium.ad_astra.client.screen.util.Category;
import earth.terrarium.ad_astra.client.screen.util.CustomButton;
import earth.terrarium.ad_astra.client.screen.util.ScreenUtils;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.data.ButtonColor;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.networking.NetworkHandling;
import earth.terrarium.ad_astra.common.networking.packet.client.CreateSpaceStationPacket;
import earth.terrarium.ad_astra.common.networking.packet.client.TeleportToPlanetPacket;
import earth.terrarium.ad_astra.common.recipe.SpaceStationRecipe;
import earth.terrarium.ad_astra.common.screen.menu.PlanetSelectionMenu;
import earth.terrarium.ad_astra.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6328;
import net.minecraft.class_757;

@class_6328
@Environment(value=EnvType.CLIENT)
public class PlanetSelectionScreen
extends class_437
implements class_3936<PlanetSelectionMenu> {
    public static final class_2960 SMALL_MENU_LIST = new class_2960("ad_astra", "textures/gui/selection_menu.png");
    public static final class_2960 LARGE_MENU_TEXTURE = new class_2960("ad_astra", "textures/gui/selection_menu_large.png");
    public static final class_2960 SCROLL_BAR = new class_2960("ad_astra", "textures/gui/scroll_bar.png");
    public static final int SCROLL_BAR_X = 92;
    public static final int SCROLL_SENSITIVITY = 5;
    public static final class_2561 CATALOG_TEXT = ScreenUtils.createText("catalog");
    public static final class_2561 BACK_TEXT = ScreenUtils.createText("back");
    public static final class_2561 PLANET_TEXT = ScreenUtils.createText("planet");
    public static final class_2561 MOON_TEXT = ScreenUtils.createText("moon");
    public static final class_2561 ORBIT_TEXT = ScreenUtils.createText("orbit");
    public static final class_2561 NO_GRAVITY_TEXT = ScreenUtils.createText("no_gravity");
    public static final class_2561 SPACE_STATION_TEXT = ScreenUtils.createText("space_station");
    public static final class_2561 SOLAR_SYSTEM_TEXT = ScreenUtils.createText("solar_system");
    public static final class_2561 GALAXY_TEXT = ScreenUtils.createText("galaxy");
    public static final class_2561 CATEGORY_TEXT = ScreenUtils.createText("category");
    public static final class_2561 PROVIDED_TEXT = ScreenUtils.createText("provided");
    public static final class_2561 TYPE_TEXT = ScreenUtils.createText("type");
    public static final class_2561 GRAVITY_TEXT = ScreenUtils.createText("gravity");
    public static final class_2561 OXYGEN_TEXT = ScreenUtils.createText("oxygen");
    public static final class_2561 TEMPERATURE_TEXT = ScreenUtils.createText("temperature");
    public static final class_2561 OXYGEN_TRUE_TEXT = ScreenUtils.createText("oxygen.true");
    public static final class_2561 OXYGEN_FALSE_TEXT = ScreenUtils.createText("oxygen.false");
    public static final class_2561 ITEM_REQUIREMENT_TEXT = ScreenUtils.createText("item_requirement");
    public final List<Pair<class_1799, Integer>> ingredients = new ArrayList<Pair<class_1799, Integer>>();
    final Set<Category> solarSystemsCategories = new HashSet<Category>();
    final Set<Category> galaxyCategories = new HashSet<Category>();
    private final PlanetSelectionMenu handler;
    private final Map<Category, LinkedList<CustomButton>> categoryButtons = new HashMap<Category, LinkedList<CustomButton>>();
    public int minScrollY = 177;
    public int maxScrollY = 274;
    private Category currentCategory = Category.GALAXY_CATEGORY;
    private float guiTime;
    private class_4185 scrollBar;

    public PlanetSelectionScreen(PlanetSelectionMenu handler, class_1661 inventory, class_2561 title) {
        super(title);
        this.handler = handler;
        if (AdAstraClient.galaxies.size() <= 1) {
            this.currentCategory = Category.MILKY_WAY_CATEGORY;
        }
        this.guiTime = handler.getPlayer().field_6002.method_8409().method_43057() * 100000.0f;
        SpaceStationRecipe.getRecipes(handler.getPlayer().field_6002).forEach(recipe -> {
            if (recipe != null) {
                for (int i = 0; i < recipe.method_8117().size(); ++i) {
                    if (((class_1856)recipe.method_8117().get(i)).method_8105().length == 0) {
                        return;
                    }
                    class_1799 stack = ((class_1856)recipe.method_8117().get(i)).method_8105()[0].method_7972();
                    stack.method_7977(stack.method_7964());
                    stack.method_7939(0);
                    for (class_1799 slot : inventory.field_7547) {
                        if (slot == null || slot.method_7960() || !((class_1856)recipe.method_8117().get(i)).method_8093(slot)) continue;
                        stack.method_7939(inventory.method_18861(slot.method_7909()));
                    }
                    this.ingredients.add((Pair<class_1799, Integer>)Pair.of((Object)stack, (Object)recipe.getHolders().get(i).count()));
                }
            }
        });
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        this.guiTime += delta;
        this.renderBackground(poseStack, mouseX, mouseY, delta);
        super.method_25394(poseStack, mouseX, mouseY, delta);
        this.field_22793.method_30883(poseStack, CATALOG_TEXT, 29.0f, (float)this.field_22790 / 2.0f - 71.5f, -1);
    }

    private void drawBackground(class_4587 poseStack) {
        class_332.method_25294((class_4587)poseStack, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-16776167);
        for (int i = 0; i < this.field_22789 / 24; ++i) {
            ScreenUtils.drawLine(i * 24, this.field_22789 + i * 24, 0, this.field_22789, -15784615);
            ScreenUtils.drawLine(0, this.field_22789 - i * 24, i * 24, this.field_22789, -15784615);
            ScreenUtils.drawLine(i * 24, 0, 0, i * 24, -15784615);
            ScreenUtils.drawLine(this.field_22789, i * 24, i * 24, this.field_22789, -15784615);
        }
        RenderSystem.enableBlend();
    }

    private void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        super.method_25420(poseStack);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawBackground(poseStack);
        int currentPage = this.getPage();
        SolarSystem solarSystem = null;
        HashSet<PlanetRing> planetRings = new HashSet<PlanetRing>();
        for (SolarSystem system : AdAstraClient.solarSystems) {
            if (!this.currentCategory.id().equals((Object)system.solarSystem()) && (this.currentCategory.parent() == null || !this.currentCategory.parent().id().equals((Object)system.solarSystem()))) continue;
            solarSystem = system;
            break;
        }
        for (PlanetRing ring : AdAstraClient.planetRings) {
            if (!this.currentCategory.id().equals((Object)ring.solarSystem()) && (this.currentCategory.parent() == null || !this.currentCategory.parent().id().equals((Object)ring.solarSystem()))) continue;
            planetRings.add(ring);
        }
        if (currentPage == 1) {
            AdAstraClient.galaxies.stream().filter(g -> g.galaxy().equals((Object)this.currentCategory.id())).findFirst().ifPresent(galaxy -> ScreenUtils.addRotatingTexture(this, poseStack, -125, -125, galaxy.scale(), galaxy.scale(), galaxy.texture(), 0.6f));
        } else if (solarSystem != null) {
            ScreenUtils.addTexture(poseStack, (this.field_22789 - solarSystem.sunScale()) / 2, (this.field_22790 - solarSystem.sunScale()) / 2, solarSystem.sunScale(), solarSystem.sunScale(), solarSystem.sun());
            for (PlanetRing ring : planetRings) {
                ScreenUtils.drawCircle((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, ring.radius() * 24.0, 75, solarSystem.ringColour());
            }
            for (PlanetRing ring : planetRings) {
                int coordinates = (int)(ring.radius() * 17.0 - (double)ring.scale() / 1.9);
                ScreenUtils.addRotatingTexture(this, poseStack, coordinates, coordinates, ring.scale(), ring.scale(), ring.texture(), 365.0f / (float)ring.speed());
            }
        }
        if (currentPage == 3) {
            ScreenUtils.addTexture(poseStack, 0, this.field_22790 / 2 - 88, 215, 177, LARGE_MENU_TEXTURE);
            this.scrollBar.method_46421(210);
        } else {
            ScreenUtils.addTexture(poseStack, 0, this.field_22790 / 2 - 88, 105, 177, SMALL_MENU_LIST);
            this.scrollBar.method_46421(92);
        }
        this.categoryButtons.forEach((category, buttons) -> buttons.forEach(button -> {
            button.field_22764 = this.currentCategory.equals(category);
        }));
        CustomButton backButton = this.categoryButtons.get(Category.BACK).get(0);
        boolean bl = backButton.field_22764 = this.currentCategory.parent() != null;
        if (currentPage == 1 && AdAstraClient.galaxies.size() <= 1) {
            backButton.field_22764 = false;
        }
        if (this.categoryButtons.containsKey(this.currentCategory)) {
            this.scrollBar.field_22764 = this.categoryButtons.get(this.currentCategory).size() > (currentPage == 3 ? 13 : 5);
        }
        this.minScrollY = this.field_22790 / 2 - 33;
        this.maxScrollY = this.field_22790 / 2 + 64;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableScissor();
    }

    protected void method_25426() {
        super.method_25426();
        LinkedList<CustomButton> backButtonList = new LinkedList<CustomButton>();
        CustomButton backButton = new CustomButton(10, this.field_22790 / 2 - 36, BACK_TEXT, ButtonType.NORMAL, ButtonColor.BLUE, TooltipType.NONE, null, pressed -> this.onNavigationButtonClick(this.currentCategory.parent()));
        this.method_37063((class_364)backButton);
        backButtonList.add(backButton);
        this.categoryButtons.put(Category.BACK, backButtonList);
        ArrayList<Planet> planets = new ArrayList<Planet>(PlanetData.planets());
        planets.sort(Comparator.comparing(g -> g.translation().substring(Math.abs(g.translation().indexOf(".text")))));
        planets.forEach(planet -> {
            if (this.handler.getTier() >= planet.rocketTier()) {
                Category galaxyCategory = new Category(planet.galaxy(), Category.GALAXY_CATEGORY);
                Category solarSystemCategory = new Category(planet.solarSystem(), galaxyCategory);
                Category planetCategory = new Category(planet.parentWorld() == null ? planet.level().method_29177() : planet.parentWorld().method_29177(), solarSystemCategory);
                class_5250 label = class_2561.method_43471((String)planet.translation());
                this.galaxyCategories.add(galaxyCategory);
                this.solarSystemsCategories.add(solarSystemCategory);
                List<String> disabledPlanets = List.of(AdAstraConfig.disabledPlanets.split(","));
                if (planet.parentWorld() == null && !disabledPlanets.contains(planet.level().method_29177().toString())) {
                    this.createNavigationButton((class_2561)label, solarSystemCategory, ButtonType.NORMAL, planet.buttonColor(), TooltipType.CATEGORY, (Planet)planet, planetCategory);
                }
                this.createTeleportButton(1, (class_2561)label, planetCategory, ButtonType.NORMAL, planet.buttonColor(), TooltipType.PLANET, (Planet)planet, planet.level());
                this.createTeleportButton(2, ORBIT_TEXT, planetCategory, ButtonType.SMALL, planet.buttonColor(), TooltipType.ORBIT, null, planet.orbitWorld());
                this.createSpaceStationTeleportButton(3, SPACE_STATION_TEXT, planetCategory, ButtonType.NORMAL, planet.buttonColor(), planet.orbitWorld());
            }
        });
        this.galaxyCategories.forEach(this::createGalaxyButton);
        this.solarSystemsCategories.forEach(this::createSolarSystemButton);
        this.scrollBar = new class_4185(92, this.minScrollY, 4, 8, class_2561.method_30163((String)""), pressed -> {}, Supplier::get){

            public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
                if (this.field_22764) {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)SCROLL_BAR);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.enableDepthTest();
                    class_332.method_25290((class_4587)poseStack, (int)this.method_46426(), (int)this.method_46427(), (float)0.0f, (float)0.0f, (int)this.field_22758, (int)this.field_22759, (int)this.field_22758, (int)this.field_22759);
                }
            }
        };
        this.method_37063((class_364)this.scrollBar);
    }

    public boolean method_25421() {
        return true;
    }

    public void onNavigationButtonClick(Category target) {
        this.resetButtonScroll();
        this.scrollBar.method_46419(this.minScrollY);
        this.currentCategory = target;
    }

    public void createGalaxyButton(Category galaxyCategory) {
        class_2561 label = ScreenUtils.createText(galaxyCategory.id());
        Galaxy galaxy = AdAstraClient.galaxies.stream().filter(g -> g.galaxy().equals((Object)galaxyCategory.id())).findFirst().orElse(null);
        this.createNavigationButton(label, Category.GALAXY_CATEGORY, ButtonType.LARGE, galaxy != null ? galaxy.buttonColor() : ButtonColor.PURPLE, TooltipType.GALAXY, null, galaxyCategory);
    }

    public void createSolarSystemButton(Category solarSystemCategory) {
        class_2561 label = ScreenUtils.createText(solarSystemCategory.id());
        SolarSystem solarSystem = AdAstraClient.solarSystems.stream().filter(g -> g.solarSystem().equals((Object)solarSystemCategory.id())).findFirst().orElse(null);
        this.createNavigationButton(label, solarSystemCategory.parent(), ButtonType.NORMAL, solarSystem != null ? solarSystem.buttonColor() : ButtonColor.BLUE, TooltipType.SOLAR_SYSTEM, null, solarSystemCategory);
    }

    public void createNavigationButton(class_2561 label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Category target) {
        this.createButton(label, category, size, colour, tooltip, planetInfo, press -> this.onNavigationButtonClick(target));
    }

    public void createSpaceStationTeleportButton(int row, class_2561 label, Category category, ButtonType size, ButtonColor colour, class_5321<class_1937> level) {
        this.createTeleportButton(row, label, category, size, colour, TooltipType.SPACE_STATION, null, level, press -> {
            if (!this.handler.getPlayer().method_7337() && !this.handler.getPlayer().method_7325()) {
                for (Pair<class_1799, Integer> ingredient : this.ingredients) {
                    boolean isEnough = ((class_1799)ingredient.getFirst()).method_7947() >= (Integer)ingredient.getSecond();
                    if (isEnough) continue;
                    return;
                }
            }
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7346();
                NetworkHandling.CHANNEL.sendToServer((Packet)new CreateSpaceStationPacket(level.method_29177()));
                this.teleportPlayer(level);
            }
        });
    }

    public void createTeleportButton(int row, class_2561 label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, class_5321<class_1937> level) {
        this.createTeleportButton(row, label, category, size, colour, tooltip, planetInfo, level, press -> this.teleportPlayer(level));
    }

    public void createTeleportButton(int row, class_2561 label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, class_5321<class_1937> level, Consumer<class_4185> onClick) {
        int newRow = 0;
        if (row == 2) {
            newRow = 76;
        } else if (row == 3) {
            newRow = 118;
        }
        LinkedList buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        int column = this.getColumn(category) - (row - 1) * 22;
        this.createButton(newRow + 10, column -= 44 * (buttons.size() / 3), label, category, size, colour, tooltip, planetInfo, onClick);
    }

    public void teleportPlayer(class_5321<class_1937> level) {
        this.field_22787.field_1724.method_7346();
        NetworkHandling.CHANNEL.sendToServer((Packet)new TeleportToPlanetPacket(level.method_29177()));
    }

    public CustomButton createButton(class_2561 label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Consumer<class_4185> onClick) {
        return this.createButton(10, label, category, size, colour, tooltip, planetInfo, onClick);
    }

    public CustomButton createButton(int row, class_2561 label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Consumer<class_4185> onClick) {
        int column = this.getColumn(category);
        return this.createButton(row, column, label, category, size, colour, tooltip, planetInfo, onClick);
    }

    public CustomButton createButton(int row, int column, class_2561 label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Consumer<class_4185> onClick) {
        LinkedList<CustomButton> buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        CustomButton button = new CustomButton(row, column, label, size, colour, tooltip, planetInfo, onClick::accept);
        this.method_37063((class_364)button);
        buttons.add(button);
        this.categoryButtons.put(category, buttons);
        return button;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        for (Map.Entry<Category, LinkedList<CustomButton>> entry : this.categoryButtons.entrySet()) {
            if (!this.currentCategory.equals(entry.getKey())) continue;
            LinkedList<CustomButton> buttons = new LinkedList<CustomButton>();
            CustomButton backButton = this.categoryButtons.get(Category.BACK).get(0);
            buttons.add(backButton);
            buttons.addAll((Collection)entry.getValue());
            boolean isLargePage = this.getPage() == 3;
            int overflowButtons = buttons.size() - (isLargePage ? 13 : 5);
            if (overflowButtons <= 0) break;
            int referencePoint = backButton.method_46427();
            int minThreshold = this.field_22790 / 2 - 35;
            int maxThreshold = this.field_22790 / 2 - 38 - overflowButtons * (isLargePage ? 7 : 21);
            int sensitivity = (int)(5.0 * amount);
            if (amount > 0.0) {
                if (referencePoint >= minThreshold) {
                    sensitivity = 0;
                }
            } else if (amount < 0.0 && referencePoint <= maxThreshold) {
                sensitivity = 0;
            }
            for (CustomButton button2 : buttons) {
                button2.method_46419(button2.method_46427() + sensitivity);
                if (referencePoint >= minThreshold) {
                    button2.method_46419(button2.method_46427() - class_3532.method_15340((int)(referencePoint - minThreshold), (int)-1, (int)1));
                    continue;
                }
                if (referencePoint > maxThreshold) continue;
                button2.method_46419(button2.method_46427() - class_3532.method_15340((int)(referencePoint - maxThreshold), (int)-1, (int)1));
            }
            float min = (float)maxThreshold / (float)minThreshold;
            float ratio = (float)backButton.method_46427() / (float)minThreshold;
            ratio = MathUtil.invLerp(ratio, 1.0f, min);
            this.scrollBar.method_46419((int)class_3532.method_16439((float)ratio, (float)this.maxScrollY, (float)this.minScrollY));
            this.scrollBar.method_46419(class_3532.method_15340((int)this.scrollBar.method_46427(), (int)this.minScrollY, (int)this.maxScrollY));
            break;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void resetButtonScroll() {
        this.categoryButtons.values().forEach(list -> list.forEach(button -> button.method_46419(button.getStartY())));
    }

    private int getPage() {
        Category category = this.currentCategory;
        if (category.parent() == null) {
            return 0;
        }
        if (category.parent().parent() == null) {
            return 1;
        }
        if (category.parent().parent().parent() == null) {
            return 2;
        }
        if (category.parent().parent().parent().parent() == null) {
            return 3;
        }
        AdAstra.LOGGER.warn("Invalid page!");
        return 0;
    }

    public int getColumn(Category category) {
        LinkedList buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        int index = buttons.size() + 1;
        int startY = this.field_22790 / 2 - 58;
        if (Category.GALAXY_CATEGORY.equals(category.parent()) && AdAstraClient.galaxies.size() <= 1) {
            return startY + 22 * index;
        }
        return startY + 22 * index + (category.parent() != null ? 22 : 0);
    }

    public float getGuiTime() {
        return this.guiTime;
    }

    public PlanetSelectionMenu getMenu() {
        return this.handler;
    }

    public List<Pair<class_1799, Integer>> getIngredients() {
        return this.ingredients;
    }

    public void method_25419() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null && (minecraft.field_1724.method_7337() || minecraft.field_1724.method_7325())) {
            super.method_25419();
        }
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.categoryButtons.clear();
        this.resetButtonScroll();
        super.method_25410(minecraft, width, height);
    }

    public static enum TooltipType {
        NONE,
        GALAXY,
        SOLAR_SYSTEM,
        CATEGORY,
        PLANET,
        ORBIT,
        SPACE_STATION;

    }
}

