/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.awt.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class GuiUtil {
    public static final int FIRE_WIDTH = 14;
    public static final int FIRE_HEIGHT = 14;
    public static final int SNOWFLAKE_WIDTH = 13;
    public static final int SNOWFLAKE_HEIGHT = 13;
    public static final int SUN_WIDTH = 21;
    public static final int SUN_HEIGHT = 21;
    public static final int HAMMER_WIDTH = 13;
    public static final int HAMMER_HEIGHT = 13;
    public static final int ENERGY_WIDTH = 13;
    public static final int ENERGY_HEIGHT = 46;
    public static final int FLUID_TANK_WIDTH = 14;
    public static final int FLUID_TANK_HEIGHT = 48;
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;
    public static final class_2960 FIRE_TEXTURE = new class_2960("ad_astra", "textures/gui/fire_on.png");
    public static final class_2960 SNOWFLAKE_TEXTURE = new class_2960("ad_astra", "textures/gui/snowflake.png");
    public static final class_2960 SUN_TEXTURE = new class_2960("ad_astra", "textures/gui/sun.png");
    public static final class_2960 HAMMER_TEXTURE = new class_2960("ad_astra", "textures/gui/hammer.png");
    public static final class_2960 ENERGY_TEXTURE = new class_2960("ad_astra", "textures/gui/energy_full.png");
    public static final class_2960 FLUID_TANK_TEXTURE = new class_2960("ad_astra", "textures/gui/fluid_tank.png");
    public static final class_2960 ARROW_TEXTURE = new class_2960("ad_astra", "textures/gui/arrow.png");

    public static boolean isHovering(Rectangle bounds, double x, double y) {
        double left = bounds.getX();
        double right = left + bounds.getWidth();
        double top = bounds.getY();
        double bottom = top + bounds.getHeight();
        return left <= x && x < right && top <= y && y < bottom;
    }

    public static Rectangle getFluidTankBounds(int x, int y) {
        return new Rectangle(x, y, 14, 48);
    }

    public static Rectangle getHammerBounds(int x, int y) {
        return new Rectangle(x, y, 13, 13);
    }

    public static Rectangle getEnergyBounds(int x, int y) {
        return new Rectangle(x, y, 13, 46);
    }

    public static Rectangle getFireBounds(int x, int y) {
        return new Rectangle(x, y, 14, 14);
    }

    public static void drawEnergy(class_4587 poseStack, int x, int y, long energy, long maxEnergy) {
        double ratio = maxEnergy > 0L ? (double)((float)energy / (float)maxEnergy) : 0.0;
        GuiUtil.drawVertical(poseStack, x, y, 13, 46, ENERGY_TEXTURE, ratio);
    }

    public static void drawFluidTank(class_4587 poseStack, int x, int y, long fluidCapacity, FluidHolder fluid) {
        double ratio = fluidCapacity > 0L ? (double)((float)fluid.getFluidAmount() / (float)fluidCapacity) : 0.0;
        GuiUtil.drawFluidTank(poseStack, x, y, ratio, fluid);
    }

    public static void drawFluidTank(class_4587 poseStack, int x, int y, double ratio, FluidHolder fluid) {
        GuiUtil.drawFluid(poseStack, x, y, ratio, fluid);
        RenderSystem.enableBlend();
        GuiUtil.drawVertical(poseStack, x, y, 14, 48, FLUID_TANK_TEXTURE, 1.0);
        RenderSystem.disableBlend();
    }

    private static void drawFluid(class_4587 poseStack, int x, int y, double ratio, FluidHolder fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        class_1058 sprite = ClientFluidHooks.getFluidSprite((FluidHolder)fluid);
        int colour = ClientFluidHooks.getFluidColor((FluidHolder)fluid);
        int spriteHeight = sprite.method_45851().method_45815();
        RenderSystem.setShaderColor((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        int calcHeight = (int)(49.0 * ratio);
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((class_310)class_310.method_1551(), (class_4587)poseStack, (int)x, (int)(y + 48 - calcHeight), (int)14, (int)calcHeight);){
            for (int i = 1; i < 4; ++i) {
                class_332.method_25298((class_4587)poseStack, (int)(x + 1), (int)(48 + y - spriteHeight * i), (int)0, (int)12, (int)spriteHeight, (class_1058)sprite);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawFire(class_4587 poseStack, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawVertical(poseStack, x, y, 14, 14, FIRE_TEXTURE, ratio);
    }

    public static void drawSnowflake(class_4587 poseStack, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawHorizontal(poseStack, x, y, 13, 13, SNOWFLAKE_TEXTURE, ratio);
    }

    public static void drawSun(class_4587 poseStack, int x, int y) {
        GuiUtil.drawHorizontal(poseStack, x, y, 21, 21, SUN_TEXTURE, 1.0);
    }

    public static void drawHammer(class_4587 poseStack, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawHorizontal(poseStack, x, y, 13, 13, HAMMER_TEXTURE, ratio);
    }

    public static void drawVertical(class_4587 poseStack, int x, int y, int width, int height, class_2960 resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.setShaderTexture((int)0, (class_2960)resource);
        class_332.method_25290((class_4587)poseStack, (int)x, (int)(y + remainHeight), (float)0.0f, (float)remainHeight, (int)width, (int)ratioHeight, (int)width, (int)height);
    }

    public static void drawVerticalReverse(class_4587 poseStack, int x, int y, int width, int height, class_2960 resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.setShaderTexture((int)0, (class_2960)resource);
        class_332.method_25290((class_4587)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)remainHeight, (int)width, (int)height);
    }

    public static void drawHorizontal(class_4587 poseStack, int x, int y, int width, int height, class_2960 resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        RenderSystem.setShaderTexture((int)0, (class_2960)resource);
        class_332.method_25290((class_4587)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)ratioWidth, (int)height, (int)width, (int)height);
    }

    public static void drawEnergyTooltip(class_437 screen, class_4587 poseStack, long energy, long energyCapacity, int mouseX, int mouseY) {
        screen.method_25424(poseStack, (class_2561)class_2561.method_43469((String)"gauge_text.ad_astra.storage", (Object[])new Object[]{Float.valueOf(class_3532.method_15363((float)energy, (float)0.0f, (float)energyCapacity)), energyCapacity}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)), mouseX, mouseY);
    }

    public static void drawTankTooltip(class_437 screen, class_4587 poseStack, FluidHolder tank, long capacity, int mouseX, int mouseY) {
        screen.method_25424(poseStack, (class_2561)class_2561.method_43469((String)"gauge_text.ad_astra.liquid_storage", (Object[])new Object[]{FluidHooks.toMillibuckets((long)tank.getFluidAmount()), FluidHooks.toMillibuckets((long)capacity)}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852(class_2561.method_30163((String)", ")).method_10852(ClientPlatformUtils.getFluidTranslation(tank.getFluid())), mouseX, mouseY);
    }

    public static class FloatGuiComponent {
        public static void drawTexture(class_4587 poseStack, float x, float y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexture(poseStack, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
        }

        public static void drawTexture(class_4587 poseStack, float x, float y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexture(poseStack, x, x + (float)width, y, y + (float)height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
        }

        private static void drawTexture(class_4587 poseStack, float x0, float x1, float y0, float y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexturedQuad(poseStack.method_23760().method_23761(), x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
        }

        private static void drawTexturedQuad(Matrix4f matrix, float x0, float x1, float y0, float y1, int z, float u0, float u1, float v0, float v1) {
            RenderSystem.setShader(class_757::method_34542);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix, x0, y1, (float)z).method_22913(u0, v1).method_1344();
            bufferBuilder.method_22918(matrix, x1, y1, (float)z).method_22913(u1, v1).method_1344();
            bufferBuilder.method_22918(matrix, x1, y0, (float)z).method_22913(u1, v0).method_1344();
            bufferBuilder.method_22918(matrix, x0, y0, (float)z).method_22913(u0, v0).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
    }
}

