/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.block.flag;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.renderer.block.flag.FlagTexture;
import earth.terrarium.ad_astra.common.block.flag.EightDirectionProperty;
import earth.terrarium.ad_astra.common.block.flag.FlagBlock;
import earth.terrarium.ad_astra.common.block.flag.FlagBlockEntity;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_1921;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4844;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class FlagBlockEntityRenderer
implements class_827<FlagBlockEntity> {
    public FlagBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public void render(FlagBlockEntity entity, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        if (((class_2756)entity.method_11010().method_11654(FlagBlock.HALF)).equals((Object)class_2756.field_12607)) {
            class_2960 texture = new class_2960("ad_astra", "block/flag/" + class_7923.field_41175.method_10221((Object)entity.method_11010().method_26204()).method_12832());
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)((EightDirectionProperty.Direction)((Object)entity.method_11010().method_11654((class_2769)FlagBlock.FACING))).asRotation()));
            poseStack.method_22904(-0.5, 0.0, -0.5);
            AdAstraClient.renderBlock(texture, poseStack, buffer, packedLight, packedOverlay);
            poseStack.method_22909();
        } else {
            String url = entity.getUrl();
            if (url != null) {
                FlagBlockEntityRenderer.renderFullTexture(entity, poseStack, buffer, packedLight, packedOverlay, false);
                FlagBlockEntityRenderer.renderFullTexture(entity, poseStack, buffer, packedLight, packedOverlay, true);
            } else {
                FlagBlockEntityRenderer.renderFace(entity, poseStack, buffer, packedLight, packedOverlay, false);
                FlagBlockEntityRenderer.renderFace(entity, poseStack, buffer, packedLight, packedOverlay, true);
            }
        }
    }

    private static void renderFullTexture(FlagBlockEntity entity, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, boolean flip) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.0, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)((EightDirectionProperty.Direction)((Object)entity.method_11010().method_11654((class_2769)FlagBlock.FACING))).asRotation()));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        poseStack.method_22904(-1.375, -0.375, flip ? -0.01 : 0.01);
        if (!flip) {
            FlagBlockEntityRenderer.flipY(poseStack, 1.25f);
        }
        class_4588 vertexConsumer = buffer.getBuffer(FlagBlockEntityRenderer.getFlagImage(entity.getUrl()));
        FlagBlockEntityRenderer.renderQuad(poseStack, vertexConsumer, 1.25f, 0.875f, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        poseStack.method_22909();
    }

    private static void renderFace(FlagBlockEntity entity, class_4587 poseStack, class_4597 buffer, int packedLight, int overlay, boolean flip) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.0, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)((EightDirectionProperty.Direction)((Object)entity.method_11010().method_11654((class_2769)FlagBlock.FACING))).asRotation()));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        poseStack.method_22904(-1.0, -0.25, flip ? -0.01 : 0.01);
        if (flip) {
            FlagBlockEntityRenderer.flipY(poseStack, 0.5f);
        }
        class_4588 vertexConsumer = buffer.getBuffer(FlagBlockEntityRenderer.getRenderLayer(entity.getOwner()));
        FlagBlockEntityRenderer.renderQuad(poseStack, vertexConsumer, 0.5f, 0.5f, 0.125f, 0.125f, 0.125f, 0.125f, packedLight, overlay);
        FlagBlockEntityRenderer.renderQuad(poseStack, vertexConsumer, 0.5f, 0.5f, 0.5f, 0.125f, 0.125f, 0.125f, packedLight, overlay);
        poseStack.method_22909();
    }

    private static void renderQuad(class_4587 poseStack, class_4588 consumer, float width, float height, float u, float v, float uWidth, float vHeight, int light, int overlay) {
        consumer.method_22918(poseStack.method_23760().method_23761(), 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        consumer.method_22918(poseStack.method_23760().method_23761(), 0.0f, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(u, v + vHeight).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        consumer.method_22918(poseStack.method_23760().method_23761(), width, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(u + uWidth, v + vHeight).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        consumer.method_22918(poseStack.method_23760().method_23761(), width, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(u + uWidth, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
    }

    private static void flipY(class_4587 poseStack, float width) {
        Vector4f vec3f = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        poseStack.method_23760().method_23761().transform(vec3f);
        poseStack.method_46416(-vec3f.x(), -vec3f.y(), -vec3f.z());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        poseStack.method_46416(vec3f.x(), vec3f.y(), vec3f.z());
        poseStack.method_46416(-width, 0.0f, 0.0f);
    }

    public static class_1921 getRenderLayer(@Nullable GameProfile profile) {
        if (profile == null) {
            return class_1921.method_28116((class_2960)new class_2960("textures/entity/zombie/zombie.png"));
        }
        class_310 minecraftClient = class_310.method_1551();
        Map map = minecraftClient.method_1582().method_4654(profile);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return class_1921.method_23580((class_2960)minecraftClient.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return class_1921.method_23578((class_2960)class_1068.method_4648((UUID)class_4844.method_43343((GameProfile)profile)));
    }

    public static class_1921 getFlagImage(String url) {
        class_2960 id = FlagTexture.getTextureId(url);
        class_1060 manager = class_310.method_1551().method_1531();
        class_1044 texture = manager.method_34590(id, (class_1044)class_1047.method_4540());
        if (texture == class_1047.method_4540()) {
            manager.method_4616(id, (class_1044)new FlagTexture(url));
        }
        return class_1921.method_23580((class_2960)id);
    }
}

