/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlight;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlightable;
import com.teamresourceful.resourcefullib.client.highlights.state.HighlightStates;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class HighlightHandler
extends class_4309 {
    private static final Map<class_2680, Highlight> STATE_CACHE = new HashMap<class_2680, Highlight>();
    private static final Map<class_2960, Highlight> BOX_CACHE = new HashMap<class_2960, Highlight>();
    public static final Codec<Highlight> HIGHLIGHT_CODEC = class_2960.field_25139.xmap(HighlightHandler::getOrThrow, Highlight::id);

    public HighlightHandler() {
        super(new Gson(), "resourcefullib/highlights");
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> jsons, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        BOX_CACHE.clear();
        STATE_CACHE.clear();
        HashMap<class_2960, JsonElement> highlights = new HashMap<class_2960, JsonElement>();
        HashMap<class_2960, JsonElement> blocks = new HashMap<class_2960, JsonElement>();
        jsons.forEach((key, json) -> (json.isJsonObject() && json.getAsJsonObject().has("lines") ? highlights : blocks).put(key, json));
        highlights.forEach((key, value) -> Highlight.codec(key).parse((DynamicOps)JsonOps.INSTANCE, value).result().ifPresent(box -> BOX_CACHE.put((class_2960)key, (Highlight)box)));
        blocks.forEach((key, value) -> class_7923.field_41175.method_17966(key).flatMap(block -> HighlightStates.codec(block).parse((DynamicOps)JsonOps.INSTANCE, value).result()).ifPresent(variants -> variants.states().forEach((states, box) -> states.forEach(state -> STATE_CACHE.put((class_2680)state, (Highlight)box)))));
    }

    public static boolean onBlockHighlight(class_243 cameraPos, class_1297 cameraEntity, class_4587 stack, class_2338 blockPos, class_2680 state, class_4588 consumer) {
        Highlightable highlightable;
        Highlight highlight;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof Highlightable && (highlight = (highlightable = (Highlightable)class_22482).getHighlight(cameraEntity.field_6002, blockPos, state)) != null) {
            highlight.render(consumer, stack, cameraPos, blockPos);
            return true;
        }
        if (STATE_CACHE.containsKey(state)) {
            STATE_CACHE.get(state).render(consumer, stack, cameraPos, blockPos);
            return true;
        }
        return false;
    }

    private static Highlight getOrThrow(class_2960 id) {
        Highlight highlight = BOX_CACHE.get(id);
        if (highlight == null) {
            throw new RuntimeException("No highlight with the id '" + id + "' was found!");
        }
        return highlight;
    }
}

