/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidHandler;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public record FabricFluidHandler(Storage<FluidVariant> storage) implements PlatformFluidHandler
{
    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            FabricFluidHolder fabricFluidHolder = FabricFluidHolder.of(fluid);
            long inserted = this.storage.insert((Object)fabricFluidHolder.toVariant(), fabricFluidHolder.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            FabricFluidHolder fabricFluidHolder = FabricFluidHolder.of(fluid);
            long extracted = this.storage.extract((Object)fabricFluidHolder.toVariant(), fabricFluidHolder.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            FluidHolder fluidHolder = extracted == 0L ? FabricFluidHolder.of(fabricFluidHolder.toVariant(), extracted) : fluid;
            return fluidHolder;
        }
    }

    @Override
    public int getTankAmount() {
        int size = 0;
        for (StorageView ignored : this.storage) {
            ++size;
        }
        return size;
    }

    @Override
    public FluidHolder getFluidInTank(int tank) {
        ArrayList fluids = new ArrayList();
        this.storage.iterator().forEachRemaining(variant -> fluids.add(FabricFluidHolder.of((FluidVariant)variant.getResource(), variant.getAmount())));
        return (FluidHolder)fluids.get(tank);
    }

    @Override
    public List<FluidHolder> getFluidTanks() {
        ArrayList<FluidHolder> fluids = new ArrayList<FluidHolder>();
        this.storage.iterator().forEachRemaining(variant -> fluids.add(FabricFluidHolder.of((FluidVariant)variant.getResource(), variant.getAmount())));
        return fluids;
    }

    @Override
    public long getTankCapacity(int tank) {
        ArrayList fluids = new ArrayList();
        this.storage.iterator().forEachRemaining(fluids::add);
        return ((StorageView)fluids.get(tank)).getCapacity();
    }

    @Override
    public boolean supportsInsertion() {
        return this.insertFluid(this.getFluidInTank(0), true) > 0L;
    }

    @Override
    public boolean supportsExtraction() {
        return this.extractFluid(this.getFluidInTank(0), true).getFluidAmount() > 0L;
    }
}

