/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2521;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class TagReplaceProcessor
extends class_3491 {
    public static final Codec<TagReplaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)class_6862.method_40090((class_5321)class_7924.field_41254).fieldOf("output_block_tag").forGetter(config -> config.outputBlockTag), (App)class_6862.method_40090((class_5321)class_7924.field_41254).fieldOf("blacklisted_output_block_tag").forGetter(config -> config.blacklistedOutputBlockTag), (App)Codec.BOOL.fieldOf("double_tall_flower").orElse((Object)false).forGetter(config -> config.doubleTallFlower), (App)Codec.BOOL.fieldOf("same_throughout_piece").orElse((Object)false).forGetter(config -> config.sameThroughoutPiece), (App)Codec.INT.fieldOf("seed_random_addition").orElse((Object)0).forGetter(config -> config.seedRandomAddition)).apply((Applicative)instance, instance.stable(TagReplaceProcessor::new)));
    private final class_2248 inputBlock;
    private final class_6862<class_2248> outputBlockTag;
    private final class_6862<class_2248> blacklistedOutputBlockTag;
    private final boolean doubleTallFlower;
    private final boolean sameThroughoutPiece;
    private final int seedRandomAddition;

    public TagReplaceProcessor(class_2248 inputBlock, class_6862<class_2248> outputBlockTag, class_6862<class_2248> blacklistedOutputBlockTag, boolean doubleTallFlower, boolean sameThroughoutPiece, int seedRandomAddition) {
        this.inputBlock = inputBlock;
        this.outputBlockTag = outputBlockTag;
        this.blacklistedOutputBlockTag = blacklistedOutputBlockTag;
        this.doubleTallFlower = doubleTallFlower;
        this.sameThroughoutPiece = sameThroughoutPiece;
        this.seedRandomAddition = seedRandomAddition;
    }

    public class_3499.class_3501 method_15110(class_4538 worldReader, class_2338 pos, class_2338 pos2, class_3499.class_3501 infoIn1, class_3499.class_3501 infoIn2, class_3492 settings) {
        Optional optionalBlocks;
        class_3499.class_3501 returnInfo = infoIn2;
        if (infoIn2.field_15596.method_26204() == this.inputBlock && settings.method_15124() != null && settings.method_15124().method_14662((class_2382)infoIn2.field_15597) && (optionalBlocks = class_7923.field_41175.method_40266(this.outputBlockTag)).isPresent()) {
            class_5819 randomSource = this.sameThroughoutPiece ? settings.method_15115(pos.method_10086(this.seedRandomAddition)) : settings.method_15115(infoIn2.field_15597);
            List<Object> blockList = GeneralUtils.getListOfNonDummyBlocks(optionalBlocks).stream().filter(block -> !block.method_9564().method_26164(this.blacklistedOutputBlockTag)).toList();
            if (this.doubleTallFlower) {
                blockList = blockList.stream().filter(f -> f instanceof class_2521).collect(Collectors.toList());
            }
            if (blockList.size() > 0) {
                class_2680 newBlockState = blockList.get(randomSource.method_43048(blockList.size())).method_9564();
                for (class_2769 property : infoIn2.field_15596.method_28501()) {
                    if (!newBlockState.method_28498(property)) continue;
                    newBlockState = this.getStateWithProperty(newBlockState, infoIn2.field_15596, property);
                }
                if (this.doubleTallFlower) {
                    returnInfo = new class_3499.class_3501(infoIn2.field_15597, newBlockState, infoIn2.field_15595);
                } else {
                    if (newBlockState.method_26204() instanceof class_5778) {
                        for (class_2350 direction : class_2350.values()) {
                            class_2746 faceProperty = class_5778.method_33374((class_2350)direction);
                            if (!newBlockState.method_28498((class_2769)faceProperty)) continue;
                            newBlockState = (class_2680)newBlockState.method_11657((class_2769)faceProperty, (Comparable)Boolean.valueOf(direction == class_2350.field_11033));
                        }
                    }
                    class_2791 chunk = worldReader.method_22350(infoIn2.field_15597);
                    class_2680 oldBlockstate = chunk.method_8320(infoIn2.field_15597);
                    class_2680 belowOldBlockstate = chunk.method_8320(infoIn2.field_15597.method_10074());
                    chunk.method_12010(infoIn2.field_15597, class_2246.field_10124.method_9564(), false);
                    chunk.method_12010(infoIn2.field_15597.method_10074(), class_2246.field_10219.method_9564(), false);
                    if (newBlockState.method_26184(worldReader, infoIn2.field_15597)) {
                        returnInfo = new class_3499.class_3501(infoIn2.field_15597, newBlockState, infoIn2.field_15595);
                    }
                    chunk.method_12010(infoIn2.field_15597, oldBlockstate, false);
                    chunk.method_12010(infoIn2.field_15597.method_10074(), belowOldBlockstate, false);
                }
            }
        }
        return returnInfo;
    }

    private <T extends Comparable<T>> class_2680 getStateWithProperty(class_2680 state, class_2680 stateToCopy, class_2769<T> property) {
        return (class_2680)state.method_11657(property, stateToCopy.method_11654(property));
    }

    protected class_3828<?> method_16772() {
        return BzProcessors.TAG_REPLACE_PROCESSOR.get();
    }
}

