/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modules;

import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import com.telepathicgrunt.the_bumblezone.events.entity.BabySpawnEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.FinishUseItemEvent;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerCraftedItemEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4466;
import net.minecraft.class_4481;

public class EntityMiscHandler {
    public static void initEvents() {
        PlayerCraftedItemEvent.EVENT.addListener(EntityMiscHandler::onItemCrafted);
        BabySpawnEvent.EVENT.addListener(EntityMiscHandler::onBeeBreed);
        BabySpawnEvent.EVENT.addListener(EntityMiscHandler::onHoneySlimeBred);
        EntityDeathEvent.EVENT_LOWEST.addListener(EntityMiscHandler::onEntityKilled);
        FinishUseItemEvent.EVENT.addListener(EntityMiscHandler::onHoneyBottleDrank);
    }

    public static void onItemCrafted(PlayerCraftedItemEvent event) {
        class_1799 createdItem = event.item();
        class_1657 class_16572 = event.player();
        if (class_16572 instanceof class_3222) {
            class_1747 blockItem;
            class_3222 serverPlayer = (class_3222)class_16572;
            class_16572 = createdItem.method_7909();
            if (class_16572 instanceof class_1747 && (blockItem = (class_1747)class_16572).method_7711() instanceof class_4481 && EntityMiscHandler.rootAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((class_1297)event.player(), ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                    ++module.craftedBeehives;
                    BzCriterias.BEEHIVE_CRAFTED_TRIGGER.trigger(serverPlayer, module.craftedBeehives);
                });
            }
        }
    }

    public static void onBeeBreed(boolean cancelled, BabySpawnEvent event) {
        class_3222 player;
        if (cancelled) {
            return;
        }
        if (!(event.child() instanceof class_4466)) {
            return;
        }
        class_1657 class_16572 = event.player();
        if (class_16572 instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(player = (class_3222)class_16572)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.beesBred;
                BzCriterias.BEE_BREEDING_TRIGGER.trigger(player, module.beesBred);
            });
        }
    }

    public static void onFlowerSpawned(class_1657 player) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)player)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.flowersSpawned;
                BzCriterias.POLLEN_PUFF_SPAWN_FLOWERS_TRIGGER.trigger(serverPlayer, module.flowersSpawned);
            });
        }
    }

    public static void onEntityKilled(boolean cancelled, EntityDeathEvent event) {
        class_3222 player;
        if (cancelled) {
            return;
        }
        if (event.entity() == null) {
            return;
        }
        if (event.source() == null) {
            return;
        }
        class_1297 class_12972 = event.source().method_5529();
        if (class_12972 instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(player = (class_3222)class_12972)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                class_2960 id = class_1299.method_5890((class_1299)event.entity().method_5864());
                if (id != null) {
                    module.mobsKilledTracker.merge(id, 1, Integer::sum);
                    BzCriterias.KILLED_COUNTER_TRIGGER.trigger(player, id, module.mobsKilledTracker.get(id));
                }
            });
        }
    }

    public static void onHoneyBottleDrank(class_1799 result, FinishUseItemEvent event) {
        class_3222 player;
        if (!event.item().method_31573(BzTags.HONEY_DRUNK_TRIGGER_ITEMS)) {
            return;
        }
        class_1309 class_13092 = event.user();
        if (class_13092 instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(player = (class_3222)class_13092)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.honeyBottleDrank;
                BzCriterias.HONEY_BOTTLE_DRANK_TRIGGER.trigger(player, module.honeyBottleDrank);
            });
        }
    }

    public static void onBeeStingerFired(class_1657 player) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)player)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.beeStingersFired;
                BzCriterias.BEE_STINGER_SHOOTER_TRIGGER.trigger(serverPlayer, module.beeStingersFired);
            });
        }
    }

    public static void onBeesSaved(class_1657 player) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)player)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.beeSaved;
                BzCriterias.BEE_SAVED_BY_STINGER_TRIGGER.trigger(serverPlayer, module.beeSaved);
            });
        }
    }

    public static void onPollenHit(class_1657 player) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)player)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.pollenPuffHits;
                BzCriterias.POLLEN_PUFF_HIT_TRIGGER.trigger(serverPlayer, module.pollenPuffHits);
            });
        }
    }

    public static void onHoneySlimeBred(boolean cancelled, BabySpawnEvent event) {
        class_3222 serverPlayer;
        if (cancelled) {
            return;
        }
        if (!(event.child() instanceof HoneySlimeEntity)) {
            return;
        }
        class_1657 class_16572 = event.player();
        if (class_16572 instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)class_16572)) {
            ModuleHelper.getModule((class_1297)serverPlayer, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.honeySlimeBred;
                BzCriterias.HONEY_SLIME_BRED_TRIGGER.trigger(serverPlayer, module.honeySlimeBred);
            });
        }
    }

    public static void onBeesFed(class_1657 player) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)player)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                ++module.beesFed;
                BzCriterias.BEE_FED_TRIGGER.trigger(serverPlayer, module.beesFed);
            });
        }
    }

    public static void onQueenBeeTrade(class_1657 player, int tradedItems) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && EntityMiscHandler.rootAdvancementDone(serverPlayer = (class_3222)player)) {
            ModuleHelper.getModule((class_1297)player, ModuleRegistry.ENTITY_MISC).ifPresent(module -> {
                module.queenBeeTrade += tradedItems;
                BzCriterias.BEE_QUEEN_TRADING_TRIGGER.trigger(serverPlayer, module.queenBeeTrade);
            });
        }
    }

    public static void onQueenBeeTrade(class_1657 player) {
        EntityMiscHandler.onQueenBeeTrade(player, 1);
    }

    public static boolean rootAdvancementDone(class_3222 serverPlayer) {
        class_161 advancement = serverPlayer.field_13995.method_3851().method_12896(BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
        Map<class_161, class_167> progress = ((PlayerAdvancementsAccessor)serverPlayer.method_14236()).getProgress();
        return advancement != null && progress.containsKey(advancement) && progress.get(advancement).method_740();
    }
}

