/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.BackpackedCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.FriendsAndFoesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.GoodallCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ProjectileDamageAttributeCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.TwilightForestCompat;
import com.telepathicgrunt.the_bumblezone.platform.ModInfo;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public class ModChecker {
    public static final List<ModCompat> SPAWNING_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> BROOD_EMPTY_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> DUNGEON_COMB_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> DIM_SPAWN_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> BLOCK_TELEPORT_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> COMB_ORE_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> HOST_BEE_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> PROJECTILE_IMPACT_HANDLED_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> CUSTOM_EQUIPMENT_SLOTS_COMPATS = new ArrayList<ModCompat>();
    public static final List<ModCompat> BEE_GEAR_BOOSTING_COMPATS = new ArrayList<ModCompat>();
    public static boolean productiveBeesPresent = false;
    public static boolean resourcefulBeesPresent = false;
    public static boolean buzzierBeesPresent = false;
    public static boolean pokecubePresent = false;
    public static boolean friendsAndFoesPresent = false;
    public static boolean beekeeperPresent = false;
    public static boolean quarkPresent = false;
    public static boolean potionOfBeesPresent = false;
    public static boolean requiemPresent = false;
    public static boolean twilightForestPresent = false;
    public static boolean dragonEnchantsPresent = false;
    public static boolean sodiumPresent = false;
    public static boolean rubidiumPresent = false;
    public static boolean goodallPresent = false;
    public static boolean backpackedPresent = false;
    public static boolean projectileDamageAttributePresent = false;
    public static boolean jonnTrophiesPresent = false;

    public static void setupModCompat() {
        String modid = "";
        try {
            modid = "friendsandfoes";
            ModChecker.loadupModCompat(modid, () -> new FriendsAndFoesCompat());
            modid = "resourcefulbees";
            ModChecker.loadupModCompat(modid, () -> new ResourcefulBeesCompat());
            modid = "twilightforest";
            ModChecker.loadupModCompat(modid, () -> new TwilightForestCompat());
            modid = "goodall";
            ModChecker.loadupModCompat(modid, () -> new GoodallCompat());
            modid = "backpacked";
            ModChecker.loadupModCompat(modid, () -> new BackpackedCompat());
            modid = "projectile_damage";
            ModChecker.loadupModCompat(modid, () -> new ProjectileDamageAttributeCompat());
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs("classloading " + modid + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    @ApiStatus.Internal
    public static void loadupModCompat(String modid, Supplier<ModCompat> loader) {
        try {
            if (PlatformHooks.isModLoaded(modid)) {
                ModCompat compat = loader.get();
                if (compat.compatTypes().contains((Object)ModCompat.Type.SPAWNS)) {
                    SPAWNING_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.EMPTY_BROOD)) {
                    BROOD_EMPTY_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.COMBS)) {
                    DUNGEON_COMB_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.DIMENSION_SPAWN)) {
                    DIM_SPAWN_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.BLOCK_TELEPORT)) {
                    BLOCK_TELEPORT_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.COMB_ORE)) {
                    COMB_ORE_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.HAS_HOST_BEES)) {
                    HOST_BEE_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.PROJECTILE_IMPACT_HANDLED)) {
                    PROJECTILE_IMPACT_HANDLED_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.CUSTOM_EQUIPMENT_SLOTS)) {
                    CUSTOM_EQUIPMENT_SLOTS_COMPATS.add(compat);
                }
                if (compat.compatTypes().contains((Object)ModCompat.Type.BEE_GEAR_BOOSTING)) {
                    BEE_GEAR_BOOSTING_COMPATS.add(compat);
                }
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    @ApiStatus.Internal
    public static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.error("  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n\n  ERROR: Something broke when trying to add mod compatibility with %s. Please let The Bumblezone developer (TelepathicGrunt) know about this!\n\n  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n".formatted(currentModID));
    }

    private static boolean isNotOutdated(String currentModID, String minVersion, boolean checkQualifierInstead) {
        if (!PlatformHooks.isModLoaded(currentModID)) {
            return true;
        }
        ModInfo info = PlatformHooks.getModInfo(currentModID, checkQualifierInstead);
        if (info != null && info.compare(minVersion) < 0) {
            Bumblezone.LOGGER.info("------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.info(" ");
            Bumblezone.LOGGER.info("BUMBLEZONE: You're using a version of " + info.displayName() + " that is outdated. Please update " + info.displayName() + " to the latest version of that mod to enable compat with Bumblezone again.");
            Bumblezone.LOGGER.info(" ");
            Bumblezone.LOGGER.info("------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return false;
        }
        return true;
    }
}

