/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.Set;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3518;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class PrefillMap
extends class_120 {
    final int scaleLevel;

    public PrefillMap(class_5341[] lootItemConditions, int scaleLevel) {
        super(lootItemConditions);
        this.scaleLevel = scaleLevel;
    }

    public class_5339 method_29321() {
        return BzLootFunctionTypes.PREFILL_MAP.get();
    }

    public Set<class_169<?>> method_293() {
        return ImmutableSet.of((Object)class_181.field_24424);
    }

    public class_1799 method_522(class_1799 itemStack, class_47 lootContext) {
        if (itemStack.method_31574(class_1802.field_8895)) {
            class_243 vec3 = (class_243)lootContext.method_296(class_181.field_24424);
            if (vec3 != null) {
                class_2338 blockPos = class_2338.method_49638((class_2374)vec3);
                class_1799 newFilledMap = class_1806.method_8005((class_1937)lootContext.method_299(), (int)blockPos.method_10263(), (int)blockPos.method_10260(), (byte)((byte)this.scaleLevel), (boolean)true, (boolean)true);
                Integer mapId = class_1806.method_8003((class_1799)newFilledMap);
                class_22 data = class_1806.method_7997((Integer)mapId, (class_1937)lootContext.method_299());
                if (data != null) {
                    ThreadExecutor.mapFilling(lootContext.method_299(), blockPos, data);
                    newFilledMap.method_7980(newFilledMap.method_7948().method_10543(itemStack.method_7948()));
                    return newFilledMap;
                }
            } else if (itemStack.method_7985()) {
                itemStack.method_7980(new class_2487());
            }
        }
        return itemStack;
    }

    public static void update(class_1937 level, class_2338 blockPos, class_22 data) {
        if (level.method_27983() == data.field_118) {
            boolean bumblezoneDim = level.method_27983().equals(BzDimension.BZ_WORLD_KEY);
            boolean ceilingDim = level.method_8597().comp_643();
            int scale = 1 << data.field_119;
            int xStart = data.field_116;
            int zStart = data.field_115;
            int intervalSpacing = 2;
            int radiusToSkip = ceilingDim ? 64 : 128;
            for (int scanX = 0; scanX < 128; scanX += intervalSpacing) {
                double d0 = 0.0;
                for (int scanZ = 0; scanZ < 128; scanZ += intervalSpacing) {
                    double slopeState;
                    double d2;
                    int zDiff;
                    int blockPosX = (xStart / scale + scanX - 64) * scale;
                    int blockPosZ = (zStart / scale + scanZ - 64) * scale;
                    int xDiff = Math.abs(blockPos.method_10263() - blockPosX);
                    if (xDiff * xDiff + (zDiff = Math.abs(blockPos.method_10260() - blockPosZ)) * zDiff < radiusToSkip * radiusToSkip || scanX % 18 > 9 || scanZ % 18 > 9 || (scanX % 9 == 0 || scanX % 9 == 8) && (scanZ % 9 == 0 || scanZ % 9 == 8)) continue;
                    class_2338 currentPos = new class_2338(blockPosX, 0, blockPosZ);
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    class_2818 levelchunk = level.method_8500(currentPos);
                    if (levelchunk.method_12223()) continue;
                    class_1923 chunkpos = levelchunk.method_12004();
                    int k3 = 0;
                    double d1 = 0.0;
                    if (ceilingDim && !bumblezoneDim) {
                        int l3 = blockPosX + blockPosZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)class_2246.field_10566.method_9564().method_26205((class_1922)level, class_2338.field_10980), 10);
                        } else {
                            multiset.add((Object)class_2246.field_10340.method_9564().method_26205((class_1922)level, class_2338.field_10980), 100);
                        }
                        d1 = 100.0;
                    } else {
                        class_2680 blockstate;
                        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                        class_2338.class_2339 mutableBlockPos1 = new class_2338.class_2339();
                        int scanY = levelchunk.method_12005(class_2902.class_2903.field_13202, blockPosX, blockPosZ) + 1;
                        if (scanY >= 255 && bumblezoneDim) {
                            scanY = 110;
                        }
                        if (scanY <= level.method_31607() + 1) {
                            blockstate = class_2246.field_9987.method_9564();
                        } else {
                            do {
                                mutableBlockPos.method_10103(chunkpos.method_8326() + blockPosX, --scanY, chunkpos.method_8328() + blockPosZ);
                            } while ((blockstate = levelchunk.method_8320((class_2338)mutableBlockPos)).method_26205((class_1922)level, (class_2338)mutableBlockPos) == class_3620.field_16008 && scanY > level.method_31607());
                            if (scanY > level.method_31607() && !blockstate.method_26227().method_15769()) {
                                class_2680 blockstate1;
                                int secondScanY = scanY - 1;
                                mutableBlockPos1.method_10101((class_2382)mutableBlockPos);
                                do {
                                    mutableBlockPos1.method_33098(secondScanY--);
                                    blockstate1 = levelchunk.method_8320((class_2338)mutableBlockPos1);
                                    ++k3;
                                } while (secondScanY > level.method_31607() && !blockstate1.method_26227().method_15769());
                                blockstate = PrefillMap.getCorrectStateForFluidBlock(level, blockstate, (class_2338)mutableBlockPos);
                            }
                        }
                        d1 += (double)scanY / (double)(scale * scale);
                        multiset.add((Object)blockstate.method_26205((class_1922)level, (class_2338)mutableBlockPos));
                    }
                    class_3620 materialcolor = (class_3620)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)class_3620.field_16008);
                    class_3620.class_6594 materialcolor$brightness = materialcolor == class_3620.field_16019 ? ((d2 = (double)(k3 /= scale * scale) * 0.1) < 0.5 ? class_3620.class_6594.field_34761 : (d2 > 0.9 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760)) : ((slopeState = (d1 - d0) * 4.0 / (double)(scale + 4) - 0.2) > 0.6 ? class_3620.class_6594.field_34761 : (slopeState < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760));
                    d0 = d1;
                    data.method_32365(scanX, scanZ, materialcolor.method_38481(materialcolor$brightness));
                }
            }
        }
    }

    private static class_2680 getCorrectStateForFluidBlock(class_1937 level, class_2680 state, class_2338 pos) {
        class_3610 fluidstate = state.method_26227();
        return !fluidstate.method_15769() && !state.method_26206((class_1922)level, pos, class_2350.field_11036) ? fluidstate.method_15759() : state;
    }

    public static class Serializer
    extends class_120.class_123<PrefillMap> {
        public void serialize(JsonObject jsonObject, PrefillMap prefillMap, JsonSerializationContext context) {
            super.method_529(jsonObject, (class_120)prefillMap, context);
            if (prefillMap.scaleLevel != 0) {
                jsonObject.addProperty("scale", (Number)prefillMap.scaleLevel);
            }
        }

        public PrefillMap deserialize(JsonObject jsonObject, JsonDeserializationContext context, class_5341[] lootItemConditions) {
            return new PrefillMap(lootItemConditions, class_3518.method_15282((JsonObject)jsonObject, (String)"scale", (int)0));
        }
    }
}

