/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.items.BzShieldItem;
import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShieldBehavior;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class HoneyCrystalShield
extends BzShieldItem
implements ItemExtension {
    private static final int[] shieldDurabilityBoostPerLevel = new int[]{0, 20, 45, 75, 110, 150, 195, 245, 316, 632};
    private static final int maxShieldLevel = shieldDurabilityBoostPerLevel.length - 1;

    public HoneyCrystalShield(class_1792.class_1793 properties) {
        super(properties.method_7895(40));
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return repair.method_31573(BzTags.HONEY_CRYSTAL_SHIELD_REPAIR_ITEMS);
    }

    @Override
    public class_1304 bz$getEquipmentSlot(class_1799 stack) {
        return class_1304.field_6171;
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_7985()) {
            int shieldLevel = Math.max(Math.min(stack.method_7948().method_10550("ShieldLevel"), maxShieldLevel), 0);
            tooltip.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.honey_crystal_shield.level_tooltip").method_27693(": " + (shieldLevel + 1)));
        }
    }

    @Override
    public int bz$getMaxDamage(class_1799 stack) {
        if (stack.method_7985()) {
            this.upgradeLegacyShield(stack);
            int shieldLevel = Math.max(Math.min(stack.method_7948().method_10550("ShieldLevel"), maxShieldLevel), 0);
            if (shieldLevel != 0) {
                return stack.method_7909().method_7841() + shieldDurabilityBoostPerLevel[shieldLevel];
            }
        }
        return stack.method_7909().method_7841();
    }

    private void upgradeLegacyShield(class_1799 stack) {
        if (stack.method_7985() && !stack.method_7969().method_10545("ShieldLevel")) {
            int repairCost = stack.method_7948().method_10550("RepairCost");
            if (repairCost >= 32) {
                stack.method_7948().method_10569("ShieldLevel", maxShieldLevel);
            } else if (repairCost >= 16) {
                stack.method_7948().method_10569("ShieldLevel", maxShieldLevel - 1);
            } else if (repairCost >= 5) {
                stack.method_7948().method_10569("ShieldLevel", maxShieldLevel / 2);
            }
        }
    }

    @Override
    public void bz$setDamage(class_1799 stack, int damage) {
        int newDamage = damage;
        int oldDamage = stack.method_7919();
        int damageCaused = oldDamage - damage;
        int shieldLevel = stack.method_7948().method_10550("ShieldLevel");
        if (damageCaused < 0) {
            int reducedDamage = -1 * Math.min(-1, damageCaused + shieldLevel / 4);
            newDamage = Math.max(0, stack.method_7919() + reducedDamage);
        } else if (damageCaused > stack.method_7936() / 5) {
            stack.method_7948().method_10569("ShieldLevel", Math.min(maxShieldLevel, shieldLevel + 1));
        }
        stack.method_7948().method_10569("Damage", Math.max(0, newDamage));
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        if (enchantment == class_1893.field_9101) {
            return OptionalBoolean.FALSE;
        }
        return OptionalBoolean.of(enchantment.field_9083.method_8177(stack.method_7909()));
    }

    public int method_31569(class_1799 itemStack) {
        return Math.round(13.0f - (float)itemStack.method_7919() * 13.0f / (float)itemStack.method_7936());
    }

    public int method_31571(class_1799 itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.method_7936() - (float)itemStack.method_7919()) / (float)itemStack.method_7936());
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean bz$canPerformAction(class_1799 stack, String toolAction) {
        return toolAction.equals("shield_block") && stack.method_31574((class_1792)this);
    }

    public static boolean handledPlayerHurtBehavior(EntityAttackedEvent event) {
        class_1309 class_13092 = event.entity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            HoneyCrystalShieldBehavior.slowPhysicalAttackers(event.source(), player);
            return HoneyCrystalShieldBehavior.damageShieldFromExplosionAndFire(event.source(), player);
        }
        return false;
    }
}

