/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.items.BzArmor;
import com.telepathicgrunt.the_bumblezone.modcompat.BackpackedCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public abstract class BeeArmor
extends BzArmor
implements ItemExtension {
    private final int variant;
    private final boolean transTexture;

    public BeeArmor(class_1741 material, class_1738.class_8051 armorType, class_1792.class_1793 properties, int variant, boolean transTexture) {
        super(material, armorType, properties);
        this.variant = variant;
        this.transTexture = transTexture;
    }

    public boolean hasTransTexture() {
        return this.transTexture;
    }

    public int getVariant() {
        return this.variant;
    }

    @Override
    public void bz$onArmorTick(class_1799 itemstack, class_1937 world, class_1657 player) {
    }

    public static int getBeeThemedGearCount(class_1297 entity) {
        int beeGearCount = 0;
        for (class_1799 armor : entity.method_5661()) {
            if (!armor.method_31573(BzTags.BZ_ARMOR_ABILITY_ENHANCING_GEAR) || !BeeArmor.isAllowedBeeArmorBoosting(armor)) continue;
            ++beeGearCount;
        }
        for (ModCompat compat : ModChecker.CUSTOM_EQUIPMENT_SLOTS_COMPATS) {
            beeGearCount += compat.getNumberOfMatchingEquippedItemsInCustomSlots(entity, itemStack -> {
                if (itemStack.method_31573(BzTags.BZ_ARMOR_ABILITY_ENHANCING_GEAR)) {
                    return !ModChecker.backpackedPresent || BackpackedCompat.isBackpackedHoneyThemedOrOtherItem(itemStack);
                }
                return false;
            });
        }
        return beeGearCount;
    }

    private static boolean isAllowedBeeArmorBoosting(class_1799 armor) {
        for (ModCompat compat : ModChecker.BEE_GEAR_BOOSTING_COMPATS) {
            if (!compat.isItemExplicitlyDisallowedFromBeeGearBoosting(armor)) continue;
            return false;
        }
        return true;
    }
}

