/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityTravelingToDimensionEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.EntityPosAndDimModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3614;
import net.minecraft.class_4481;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class EntityTeleportationBackend {
    public static class_243 destPostFromOutOfBoundsTeleport(class_1297 entity, class_3218 destination) {
        class_1297 player = entity.method_5685().stream().filter(e -> e instanceof class_1657).findFirst().orElse(null);
        if (player != null) {
            entity = player;
        }
        Optional<EntityPosAndDimModule> capOptional = ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM);
        if (BzDimensionConfigs.forceBumblezoneOriginMobToOverworldCenter && capOptional.isPresent() && capOptional.orElseThrow(RuntimeException::new).getNonBZPos() == null) {
            destination.method_22350(class_2338.field_10980);
            int heightMapY = destination.method_8624(class_2902.class_2903.field_13197, 0, 0);
            if (heightMapY > destination.method_31607() && heightMapY < destination.method_31600()) {
                return new class_243(0.0, (double)heightMapY + 0.5, 0.0);
            }
            return new class_243(0.0, (double)((float)(destination.method_31607() + destination.method_31600()) / 2.0f), 0.0);
        }
        class_243 entitySavedPastPos = null;
        if (capOptional.isPresent()) {
            EntityPosAndDimModule capability = capOptional.orElseThrow(RuntimeException::new);
            entitySavedPastPos = capability.getNonBZPos();
        }
        class_2338 finalSpawnPos = entity.method_24515();
        if (entitySavedPastPos != null) {
            finalSpawnPos = class_2338.method_49638(entitySavedPastPos);
        }
        return new class_243((double)finalSpawnPos.method_10263() + 0.5, (double)(finalSpawnPos.method_10264() + 1), (double)finalSpawnPos.method_10260() + 0.5);
    }

    public static class_243 getBzCoordinate(class_1297 entity, class_3218 originalWorld, class_3218 bumblezoneWorld) {
        int heightCheck;
        double coordinateScale = originalWorld.method_8597().comp_646() / bumblezoneWorld.method_8597().comp_646();
        class_2338 blockpos = class_2338.method_49637((double)Doubles.constrainToRange((double)(entity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), (double)Doubles.constrainToRange((double)entity.method_19538().method_10214(), (double)45.0, (double)200.0), (double)Doubles.constrainToRange((double)(entity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
        Object validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocation((class_1937)bumblezoneWorld, blockpos, 32);
        if (validBlockPos == null) {
            validBlockPos = new class_2338(blockpos.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((class_1936)bumblezoneWorld, blockpos.method_10264(), 0, blockpos) + 1, blockpos.method_10260());
            if (validBlockPos.method_10264() == 0) {
                validBlockPos = blockpos;
            } else if (bumblezoneWorld.method_8320(validBlockPos).method_26207() == class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() == class_3614.field_15920) {
                class_2338.class_2339 mutable = new class_2338.class_2339(validBlockPos.method_10263(), validBlockPos.method_10264(), validBlockPos.method_10260());
                while (mutable.method_10264() < 255 && !bumblezoneWorld.method_22347((class_2338)mutable) || bumblezoneWorld.method_8320((class_2338)mutable).method_26207() == class_3614.field_15920) {
                    mutable.method_10098(class_2350.field_11036);
                }
                validBlockPos = !bumblezoneWorld.method_8320((class_2338)mutable).method_26215() ? blockpos : mutable;
            } else if (!bumblezoneWorld.method_22347(validBlockPos) && bumblezoneWorld.method_8320(validBlockPos).method_26207() != class_3614.field_15920 && !bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26215()) {
                validBlockPos = blockpos;
            }
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.method_10264() && bumblezoneWorld.method_8320(validBlockPos.method_10087(heightCheck)).method_26215(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.method_10264()) {
            bumblezoneWorld.method_8501(validBlockPos.method_10264() == 0 ? validBlockPos : validBlockPos.method_10074(), class_2246.field_21212.method_9564());
        }
        return new class_243((double)validBlockPos.method_10263() + 0.5, (double)validBlockPos.method_10264(), (double)validBlockPos.method_10260() + 0.5);
    }

    private static class_2338 validPlayerSpawnLocation(class_1937 world, class_2338 position, int maximumRange) {
        class_2338.class_2339 currentPos = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        class_2791 chunk = null;
        for (int range = 0; range <= maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = -range; y <= range; y += 4) {
                for (int x = -range; x <= range; x += 4) {
                    for (int z = -range; z <= range; z += 4) {
                        boolean isCurrentPosAir;
                        int distanceSq = x * x + z * z + y * y;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.method_10101((class_2382)position.method_10069(x, y, z));
                        if (currentPos.method_10264() > 250 || currentPos.method_10264() < 45 || !(isCurrentPosAir = (chunk = EntityTeleportationBackend.getChunkForSpot(world, chunk, (class_2338)currentPos)).method_8320((class_2338)currentPos).method_26215())) continue;
                        boolean isBelowSolid = chunk.method_8320(currentPos.method_10074()).method_26225();
                        if (isBelowSolid) {
                            if (!chunk.method_8320(currentPos.method_10084()).method_26215()) continue;
                            return currentPos;
                        }
                        while (!isBelowSolid && currentPos.method_10264() >= 45) {
                            currentPos.method_10098(class_2350.field_11033);
                            class_2680 belowState = chunk.method_8320(currentPos.method_10074());
                            isBelowSolid = belowState.method_26225() || !belowState.method_26227().method_15769();
                        }
                        if (!isBelowSolid) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    private static class_2791 getChunkForSpot(class_1937 world, class_2791 chunkAccess, class_2338 blockPos) {
        if (chunkAccess == null || chunkAccess.method_12004().field_9181 != blockPos.method_10263() >> 4 || chunkAccess.method_12004().field_9180 != blockPos.method_10260() >> 4) {
            return world.method_22350(blockPos);
        }
        return chunkAccess;
    }

    public static boolean isValidBeeHive(class_2680 blockState) {
        if (blockState.method_26164(BzTags.FORCED_ALLOWED_TELEPORTABLE_BLOCK)) {
            return true;
        }
        if (blockState.method_26164(BzTags.DISALLOWED_TELEPORTABLE_BEEHIVE)) {
            return false;
        }
        if ((blockState.method_26164(class_3481.field_20340) || blockState.method_26204() instanceof class_4481) && (class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12836().equals("minecraft") || BzDimensionConfigs.allowTeleportationWithModdedBeehives)) {
            return true;
        }
        if (BzDimensionConfigs.allowTeleportationWithModdedBeehives) {
            for (ModCompat compat : ModChecker.BLOCK_TELEPORT_COMPATS) {
                if (!compat.isValidBeeHiveForTeleportation(blockState)) continue;
                return true;
            }
        }
        return false;
    }

    public static void entityChangingDimension(EntityTravelingToDimensionEvent event) {
        class_1297 entity = event.entity();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!livingEntity.field_6002.method_8608() && event.dimension().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                Optional<EntityPosAndDimModule> lazyOptional = ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM);
                if (lazyOptional.isPresent()) {
                    EntityPosAndDimModule capability = lazyOptional.orElseThrow(RuntimeException::new);
                    capability.setNonBZDim(entity.field_6002.method_27983().method_29177());
                    capability.setNonBZPos(entity.method_19538());
                } else {
                    String string;
                    Object[] objectArray = new Object[7];
                    objectArray[0] = entity.method_5864();
                    objectArray[1] = entity.getClass().getName();
                    class_2561 class_25612 = entity.method_5476();
                    if (class_25612 instanceof class_5250) {
                        class_5250 mutableComponent = (class_5250)class_25612;
                        string = mutableComponent.toString();
                    } else {
                        string = "N/A";
                    }
                    objectArray[2] = string;
                    objectArray[3] = entity.method_5667();
                    objectArray[4] = entity.method_19538();
                    objectArray[5] = entity.field_6002.method_27983();
                    objectArray[6] = event.dimension();
                    Bumblezone.LOGGER.error("Bumblezone entity pos/dim cap was not found for given entity: {}, {}, {}, {}, at {} which has the internal dimension of: {} and is coming from: {}", objectArray);
                }
            }
        }
    }
}

