/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.events.player.PlayerBreakSpeedEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.platform.BzEnchantment;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4481;
import net.minecraft.class_7923;

public class CombCutterEnchantment
extends BzEnchantment {
    private static final GeneralUtils.Lazy<Set<class_2248>> TARGET_BLOCKS = new GeneralUtils.Lazy();
    private static final GeneralUtils.Lazy<Set<class_2248>> LESSER_TARGET_BLOCKS = new GeneralUtils.Lazy();

    public CombCutterEnchantment() {
        super(class_1887.class_1888.field_9088, class_1886.field_9082, new class_1304[]{class_1304.field_6173});
    }

    public Set<class_2248> getTargetBlocks() {
        return TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<class_2248> validBlocks = new HashSet<class_2248>();
            for (class_2960 key : class_7923.field_41175.method_10235()) {
                if (!key.method_12832().contains("comb")) continue;
                validBlocks.add((class_2248)class_7923.field_41175.method_10223(key));
            }
            return validBlocks;
        });
    }

    public Set<class_2248> getLesserTargetBlocks() {
        return LESSER_TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<class_2248> validBlocks = new HashSet<class_2248>();
            for (class_2960 key : class_7923.field_41175.method_10235()) {
                String path = key.method_12832();
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(key);
                if (!(block instanceof class_4481) && !path.contains("hive") && !path.contains("nest") && (!path.contains("wax") || path.contains("waxed"))) continue;
                validBlocks.add(block);
            }
            return validBlocks;
        });
    }

    public static void attemptFasterMining(PlayerBreakSpeedEvent event) {
        if (BzEnchantments.COMB_CUTTER.get().getTargetBlocks().contains(event.state().method_26204())) {
            CombCutterEnchantment.mineFaster(event, false);
        } else if (BzEnchantments.COMB_CUTTER.get().getLesserTargetBlocks().contains(event.state().method_26204())) {
            CombCutterEnchantment.mineFaster(event, true);
        }
    }

    private static void mineFaster(PlayerBreakSpeedEvent event, boolean lesserTarget) {
        class_1657 playerEntity = event.player();
        class_1799 itemStack = playerEntity.method_6047();
        int equipmentLevel = class_1890.method_8203((class_1887)BzEnchantments.COMB_CUTTER.get(), (class_1309)playerEntity);
        if (equipmentLevel > 0 && !itemStack.method_7960()) {
            event.speed().addAndGet((double)(equipmentLevel * equipmentLevel + (lesserTarget ? 3 : 13)));
        }
    }

    public static void increasedCombDrops(class_1657 playerEntity, class_1937 world, class_2338 pos) {
        class_1799 itemStack = playerEntity.method_6047();
        int equipmentLevel = class_1890.method_8203((class_1887)BzEnchantments.COMB_CUTTER.get(), (class_1309)playerEntity);
        if (equipmentLevel > 0 && !itemStack.method_7960()) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_20414, equipmentLevel * 3));
            if (playerEntity instanceof class_3222) {
                BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.trigger((class_3222)playerEntity);
            }
        }
    }

    public int method_8182(int level) {
        return 10 * (level - 1);
    }

    public int method_20742(int level) {
        return super.method_8182(level) + 13;
    }

    public int method_8183() {
        return 1;
    }

    public boolean method_8192(class_1799 stack) {
        return stack.method_7909() instanceof class_1820 || stack.method_7909() instanceof class_1829 || stack.method_31574(class_1802.field_8529);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(class_1799 stack) {
        return OptionalBoolean.of(this.method_8192(stack));
    }
}

