/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.telepathicgrunt.the_bumblezone.client.BeehemothControls;
import com.telepathicgrunt.the_bumblezone.client.armor.BeeArmorModelProvider;
import com.telepathicgrunt.the_bumblezone.client.items.HoneyCompassItemProperty;
import com.telepathicgrunt.the_bumblezone.client.items.IncenseCandleColoring;
import com.telepathicgrunt.the_bumblezone.client.particles.HoneyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.PollenPuffParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.RoyalJellyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.SparkleParticle;
import com.telepathicgrunt.the_bumblezone.client.rendering.HiddenEffectIconRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beearmor.BeeArmorModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth.BeehemothRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beequeen.BeeQueenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.beestinger.BeeStingerRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.fluids.HoneyFluidClientProperties;
import com.telepathicgrunt.the_bumblezone.client.rendering.fluids.RoyalJellyClientProperties;
import com.telepathicgrunt.the_bumblezone.client.rendering.fluids.SugarWaterClientProperties;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeyslime.HoneySlimeRendering;
import com.telepathicgrunt.the_bumblezone.client.rendering.pileofpollen.PileOfPollenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.stingerspear.StingerSpearRenderer;
import com.telepathicgrunt.the_bumblezone.events.client.BlockRenderedOnScreenEvent;
import com.telepathicgrunt.the_bumblezone.events.client.ClientTickEvent;
import com.telepathicgrunt.the_bumblezone.events.client.KeyInputEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterArmorProviderEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterBlockColorEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterClientFluidPropertiesEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterDimensionEffectsEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEffectRenderersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEntityLayersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterEntityRenderersEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterItemColorEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterItemPropertiesEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterKeyMappingEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterMenuScreenEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterParticleEvent;
import com.telepathicgrunt.the_bumblezone.events.client.RegisterRenderTypeEvent;
import com.telepathicgrunt.the_bumblezone.items.BeeCannon;
import com.telepathicgrunt.the_bumblezone.items.CrystalCannon;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.registry.RegistryEntry;
import com.telepathicgrunt.the_bumblezone.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.screens.StrictChestScreen;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzSkyProperty;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_953;

public class BumblezoneClient {
    public static void init() {
        RegisterParticleEvent.EVENT.addListener(BumblezoneClient::onParticleSetup);
        RegisterEntityRenderersEvent.EVENT.addListener(BumblezoneClient::registerEntityRenderers);
        RegisterEntityLayersEvent.EVENT.addListener(BumblezoneClient::registerEntityLayers);
        RegisterKeyMappingEvent.EVENT.addListener(BumblezoneClient::registerKeyBinding);
        RegisterDimensionEffectsEvent.EVENT.addListener(BumblezoneClient::registerDimensionEffects);
        RegisterBlockColorEvent.EVENT.addListener(IncenseCandleColoring::registerBlockColors);
        RegisterItemColorEvent.EVENT.addListener(IncenseCandleColoring::registerItemColors);
        ClientTickEvent.EVENT.addListener(event -> {
            if (event.end()) {
                StinglessBeeHelmet.decrementHighlightingCounter((class_1657)class_310.method_1551().field_1724);
            }
        });
        BlockRenderedOnScreenEvent.EVENT.addListener(PileOfPollenRenderer::pileOfPollenOverlay);
        KeyInputEvent.EVENT.addListener(BeehemothControls::keyInput);
        RegisterMenuScreenEvent.EVENT.addListener(BumblezoneClient::registerScreens);
        RegisterClientFluidPropertiesEvent.EVENT.addListener(BumblezoneClient::onRegisterClientFluidProperties);
        RegisterItemPropertiesEvent.EVENT.addListener(BumblezoneClient::registerItemProperties);
        RegisterRenderTypeEvent.EVENT.addListener(BumblezoneClient::registerRenderTypes);
        RegisterArmorProviderEvent.EVENT.addListener(BumblezoneClient::registerArmorProviders);
        RegisterEffectRenderersEvent.EVENT.addListener(BumblezoneClient::registerEffectRenderers);
    }

    public static void registerEffectRenderers(RegisterEffectRenderersEvent event) {
        event.register(BzEffects.HIDDEN.get(), new HiddenEffectIconRenderer());
    }

    public static void registerArmorProviders(RegisterArmorProviderEvent event) {
        event.register(BzItems.STINGLESS_BEE_HELMET_1.get(), BeeArmorModelProvider::new);
        event.register(BzItems.STINGLESS_BEE_HELMET_2.get(), BeeArmorModelProvider::new);
        event.register(BzItems.BUMBLE_BEE_CHESTPLATE_1.get(), BeeArmorModelProvider::new);
        event.register(BzItems.BUMBLE_BEE_CHESTPLATE_2.get(), BeeArmorModelProvider::new);
        event.register(BzItems.TRANS_BUMBLE_BEE_CHESTPLATE_1.get(), BeeArmorModelProvider::new);
        event.register(BzItems.TRANS_BUMBLE_BEE_CHESTPLATE_2.get(), BeeArmorModelProvider::new);
        event.register(BzItems.HONEY_BEE_LEGGINGS_1.get(), BeeArmorModelProvider::new);
        event.register(BzItems.HONEY_BEE_LEGGINGS_2.get(), BeeArmorModelProvider::new);
        event.register(BzItems.CARPENTER_BEE_BOOTS_1.get(), BeeArmorModelProvider::new);
        event.register(BzItems.CARPENTER_BEE_BOOTS_2.get(), BeeArmorModelProvider::new);
    }

    public static void onRegisterClientFluidProperties(RegisterClientFluidPropertiesEvent event) {
        event.register(BzFluids.HONEY_FLUID_TYPE.get(), HoneyFluidClientProperties::create);
        event.register(BzFluids.ROYAL_JELLY_FLUID_TYPE.get(), RoyalJellyClientProperties::create);
        event.register(BzFluids.SUGAR_WATER_FLUID_TYPE.get(), SugarWaterClientProperties::create);
    }

    public static void registerKeyBinding(RegisterKeyMappingEvent event) {
        event.register(BeehemothControls.KEY_BIND_BEEHEMOTH_UP);
        event.register(BeehemothControls.KEY_BIND_BEEHEMOTH_DOWN);
    }

    private static void registerScreens(RegisterMenuScreenEvent event) {
        event.register(BzMenuTypes.STRICT_9x1.get(), StrictChestScreen::new);
        event.register(BzMenuTypes.STRICT_9x2.get(), StrictChestScreen::new);
        event.register(BzMenuTypes.STRICT_9x3.get(), StrictChestScreen::new);
        event.register(BzMenuTypes.STRICT_9x4.get(), StrictChestScreen::new);
        event.register(BzMenuTypes.STRICT_9x5.get(), StrictChestScreen::new);
        event.register(BzMenuTypes.STRICT_9x6.get(), StrictChestScreen::new);
        event.register(BzMenuTypes.CRYSTALLINE_FLOWER.get(), CrystallineFlowerScreen::new);
    }

    private static void registerItemProperties(RegisterItemPropertiesEvent event) {
        event.register(BzItems.HONEY_CRYSTAL_SHIELD.get(), new class_2960("blocking"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        event.register(BzItems.STINGER_SPEAR.get(), new class_2960("throwing"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        event.register(BzItems.HONEY_COMPASS.get(), new class_2960("angle"), HoneyCompassItemProperty.getClampedItemPropertyFunction());
        event.register(BzItems.BEE_CANNON.get(), new class_2960("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        event.register(BzItems.CRYSTAL_CANNON.get(), new class_2960("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        event.register(BzItems.BEE_CANNON.get(), new class_2960("bee_count"), (itemStack, world, livingEntity, int1) -> (float)BeeCannon.getNumberOfBees(itemStack) / 10.0f);
        event.register(BzItems.CRYSTAL_CANNON.get(), new class_2960("crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        event.register(BzItems.CRYSTAL_CANNON.get(), new class_2960("crystal_count"), (itemStack, world, livingEntity, int1) -> (float)CrystalCannon.getNumberOfCrystals(itemStack) / 10.0f);
        event.register(BzItems.HONEYCOMB_BROOD.get(), new class_2960("is_creative_tab_icon"), (itemStack, world, livingEntity, integer) -> itemStack.method_7985() && itemStack.method_7969().method_10577("isCreativeTabIcon") ? 1.0f : 0.0f);
    }

    private static void registerRenderTypes(RegisterRenderTypeEvent event) {
        event.register(class_1921.method_23583(), (class_3611)BzFluids.SUGAR_WATER_FLUID.get(), (class_3611)BzFluids.SUGAR_WATER_FLUID_FLOWING.get(), (class_3611)BzFluids.HONEY_FLUID.get(), (class_3611)BzFluids.HONEY_FLUID_FLOWING.get(), (class_3611)BzFluids.ROYAL_JELLY_FLUID.get(), (class_3611)BzFluids.ROYAL_JELLY_FLUID_FLOWING.get());
        event.register(class_1921.method_23581(), BzBlocks.STICKY_HONEY_REDSTONE.get(), BzBlocks.STICKY_HONEY_RESIDUE.get(), BzBlocks.HONEY_WEB.get(), BzBlocks.REDSTONE_HONEY_WEB.get(), BzBlocks.SUPER_CANDLE_WICK.get(), BzBlocks.SUPER_CANDLE_WICK_SOUL.get(), BzBlocks.INCENSE_BASE_CANDLE.get(), BzBlocks.CRYSTALLINE_FLOWER.get(), BzBlocks.POROUS_HONEYCOMB.get(), BzBlocks.EMPTY_HONEYCOMB_BROOD.get());
        BzBlocks.CURTAINS.stream().map(RegistryEntry::get).forEach(block -> event.register(class_1921.method_23581(), (class_2248)block));
        event.register(class_1921.method_23583(), BzBlocks.HONEY_CRYSTAL.get(), BzBlocks.GLISTERING_HONEY_CRYSTAL.get(), BzBlocks.ROYAL_JELLY_BLOCK.get());
    }

    public static void registerEntityLayers(RegisterEntityLayersEvent event) {
        event.register(BeehemothModel.LAYER_LOCATION, BeehemothModel::createBodyLayer);
        event.register(BeeQueenModel.LAYER_LOCATION, BeeQueenModel::createBodyLayer);
        event.register(StingerSpearModel.LAYER_LOCATION, StingerSpearModel::createLayer);
        event.register(BeeStingerModel.LAYER_LOCATION, BeeStingerModel::createLayer);
        event.register(HoneyCrystalShardModel.LAYER_LOCATION, HoneyCrystalShardModel::createLayer);
        event.register(BeeArmorModel.VARIANT_1_LAYER_LOCATION, BeeArmorModel::createVariant1);
        event.register(BeeArmorModel.VARIANT_2_LAYER_LOCATION, BeeArmorModel::createVariant2);
    }

    public static void registerEntityRenderers(RegisterEntityRenderersEvent event) {
        event.register(BzEntities.HONEY_SLIME.get(), HoneySlimeRendering::new);
        event.register(BzEntities.BEEHEMOTH.get(), BeehemothRenderer::new);
        event.register(BzEntities.BEE_QUEEN.get(), BeeQueenRenderer::new);
        event.register(BzEntities.POLLEN_PUFF_ENTITY.get(), class_953::new);
        event.register(BzEntities.THROWN_STINGER_SPEAR_ENTITY.get(), StingerSpearRenderer::new);
        event.register(BzEntities.BEE_STINGER_ENTITY.get(), BeeStingerRenderer::new);
        event.register(BzEntities.HONEY_CRYSTAL_SHARD.get(), HoneyCrystalShardRenderer::new);
    }

    public static void onParticleSetup(RegisterParticleEvent event) {
        event.register((class_2396)BzParticles.POLLEN_PARTICLE.get(), PollenPuffParticle.Factory::new);
        event.register((class_2396)BzParticles.SPARKLE_PARTICLE.get(), SparkleParticle.Factory::new);
        event.register((class_2396)BzParticles.HONEY_PARTICLE.get(), HoneyParticle.Factory::new);
        event.register((class_2396)BzParticles.ROYAL_JELLY_PARTICLE.get(), RoyalJellyParticle.Factory::new);
    }

    public static void registerDimensionEffects(RegisterDimensionEffectsEvent event) {
        event.register(new class_2960("the_bumblezone", "sky_property"), new BzSkyProperty());
    }
}

