/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import com.telepathicgrunt.the_bumblezone.items.HoneyBeeLeggings;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4466;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class HoneyWeb
extends class_2248 {
    public static final class_2746 NORTHSOUTH = class_2746.method_11825((String)"northsouth");
    public static final class_2746 EASTWEST = class_2746.method_11825((String)"eastwest");
    public static final class_2746 UPDOWN = class_2746.method_11825((String)"updown");
    protected final class_265[] collisionShapeByIndex;
    protected final class_265[] shapeByIndex;
    private final Object2IntMap<class_2680> stateToIndex = new Object2IntOpenHashMap();
    public static final Map<class_2350.class_2351, class_2746> AXIS_TO_PROP = ImmutableMap.copyOf((Map)((Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class_2351.class), map -> {
        map.put(class_2350.class_2351.field_11048, NORTHSOUTH);
        map.put(class_2350.class_2351.field_11051, EASTWEST);
        map.put(class_2350.class_2351.field_11052, UPDOWN);
    })));

    public HoneyWeb() {
        this(class_4970.class_2251.method_9639((class_3614)class_3614.field_15913, (class_3620)class_3620.field_15987).method_22488().method_9634().method_29292().method_9632(4.0f));
    }

    public HoneyWeb(class_4970.class_2251 properties) {
        super(properties);
        this.collisionShapeByIndex = this.makeShapes();
        this.shapeByIndex = this.makeShapes();
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EASTWEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UPDOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> blockStateBuilder) {
        blockStateBuilder.method_11667(new class_2769[]{NORTHSOUTH, EASTWEST, UPDOWN});
    }

    protected class_265[] makeShapes() {
        class_265 voxelshape1 = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        class_265 voxelshape2 = class_2248.method_9541((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        class_265 voxelshape3 = class_2248.method_9541((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
        return new class_265[]{class_259.method_1073(), voxelshape1, voxelshape2, class_259.method_1084((class_265)voxelshape1, (class_265)voxelshape2), voxelshape3, class_259.method_1084((class_265)voxelshape1, (class_265)voxelshape3), class_259.method_1084((class_265)voxelshape2, (class_265)voxelshape3), class_259.method_1084((class_265)class_259.method_1084((class_265)voxelshape1, (class_265)voxelshape2), (class_265)voxelshape3)};
    }

    protected int getAABBIndex(class_2680 blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, a -> {
            int bitFlag = 0;
            if (((Boolean)blockState.method_11654((class_2769)NORTHSOUTH)).booleanValue()) {
                bitFlag |= 1;
            }
            if (((Boolean)blockState.method_11654((class_2769)EASTWEST)).booleanValue()) {
                bitFlag |= 2;
            }
            if (((Boolean)blockState.method_11654((class_2769)UPDOWN)).booleanValue()) {
                bitFlag |= 4;
            }
            return bitFlag;
        });
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return this.shapeByIndex[this.getAABBIndex(blockState)];
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        class_1657 player;
        if (entity instanceof class_4466 || entity instanceof BeehemothEntity || entity instanceof HoneySlimeEntity) {
            return;
        }
        if (!(entity instanceof class_1657) || !(player = (class_1657)entity).method_7337()) {
            class_1799 beeLeggings = HoneyBeeLeggings.getEntityBeeLegging(entity);
            class_265 shape = this.shapeByIndex[this.getAABBIndex(blockState)];
            if (class_259.method_1074((class_265)(shape = shape.method_1096((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260())), (class_265)class_259.method_1078((class_238)entity.method_5829()), (class_247)class_247.field_16896)) {
                if (entity instanceof class_1676) {
                    speedReduction = 0.015f;
                    class_243 deltaMovement = entity.method_18798();
                    double magnitude = deltaMovement.method_1033();
                    if (magnitude != 0.0) {
                        entity.method_5844(blockState, new class_243(speedReduction /= magnitude, speedReduction, speedReduction));
                    }
                } else {
                    speedReduction = 0.1f;
                    if (!beeLeggings.method_7960()) {
                        speedReduction = 0.9f;
                    } else {
                        class_243 deltaMovement = entity.method_18798();
                        double magnitude = deltaMovement.method_1033();
                        if (magnitude != 0.0) {
                            speedReduction /= magnitude;
                        }
                    }
                    entity.method_5844(blockState, new class_243(speedReduction, speedReduction, speedReduction));
                }
                if (beeLeggings.method_7960() && entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.method_6092(new class_1293(class_1294.field_5909, 200, 1, false, false, true));
                }
            }
        }
        super.method_9548(blockState, level, blockPos, entity);
    }

    public class_2680 method_9605(class_1750 placeContext) {
        class_2338 blockpos;
        class_1937 level = placeContext.method_8045();
        class_2680 state = this.getStateForSpot((class_1922)level, blockpos = placeContext.method_8037());
        if (!(((Boolean)state.method_11654((class_2769)NORTHSOUTH)).booleanValue() || ((Boolean)state.method_11654((class_2769)EASTWEST)).booleanValue() || ((Boolean)state.method_11654((class_2769)UPDOWN)).booleanValue())) {
            if (placeContext.method_8038().method_10166() != class_2350.class_2351.field_11052) {
                state = (class_2680)this.method_9564().method_11657((class_2769)UPDOWN, (Comparable)Boolean.valueOf(true));
            } else {
                class_2350.class_2351 horizontalFacing = class_2350.class_2351.field_11051;
                for (class_2350 direction : placeContext.method_7718()) {
                    if (direction.method_10166() == class_2350.class_2351.field_11052) continue;
                    horizontalFacing = direction.method_10166();
                    break;
                }
                state = horizontalFacing == class_2350.class_2351.field_11048 ? (class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTHSOUTH, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)EASTWEST, (Comparable)Boolean.valueOf(false)) : (class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EASTWEST, (Comparable)Boolean.valueOf(true));
            }
        }
        this.updateNeighboringStates(level, state, blockpos);
        return state;
    }

    public class_1269 method_9534(class_2680 blockstate, class_1937 world, class_2338 position, class_1657 playerEntity, class_1268 playerHand, class_3965 raytraceResult) {
        class_1755 bucketItem;
        class_1799 itemstack = playerEntity.method_5998(playerHand);
        class_1792 class_17922 = itemstack.method_7909();
        if (class_17922 instanceof class_1755 && PlatformHooks.getBucketFluid(bucketItem = (class_1755)class_17922).method_15791(class_3486.field_15517) || itemstack.method_7985() && itemstack.method_7948().method_10558("Potion").contains("water") || itemstack.method_7909() == class_1802.field_8554 || itemstack.method_7909() == BzItems.SUGAR_WATER_BOTTLE.get()) {
            if (!itemstack.method_7960()) {
                playerEntity.method_7259(class_3468.field_15372.method_14956((Object)itemstack.method_7909()));
            }
            if (itemstack.method_7909() == class_1802.field_8554 && playerEntity instanceof class_3222) {
                BzCriterias.CLEANUP_HONEY_WEB_TRIGGER.trigger((class_3222)playerEntity);
            }
            world.method_22352(position, false);
            world.method_43128(playerEntity, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), BzSounds.WASHING_RESIDUES.get(), class_3419.field_15248, 1.0f, 1.0f);
            if (world.method_8608()) {
                for (int i = 0; i < 25; ++i) {
                    this.addParticle((class_2394)class_2398.field_18306, world, playerEntity.method_6051(), position, blockstate.method_26218((class_1922)world, position));
                }
            }
            return class_1269.field_5812;
        }
        return super.method_9534(blockstate, world, position, playerEntity, playerHand, raytraceResult);
    }

    private void updateNeighboringStates(class_1937 level, class_2680 centerState, class_2338 blockpos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 sidePos = blockpos.method_10093(direction);
            class_2680 neighboringBlockstate = level.method_8320(sidePos);
            if (!(neighboringBlockstate.method_26204() instanceof HoneyWeb)) continue;
            boolean changedState = false;
            if (direction.method_10166() != class_2350.class_2351.field_11048 && ((Boolean)centerState.method_11654((class_2769)NORTHSOUTH)).booleanValue() && !((Boolean)neighboringBlockstate.method_11654((class_2769)NORTHSOUTH)).booleanValue()) {
                neighboringBlockstate = (class_2680)neighboringBlockstate.method_11657((class_2769)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (direction.method_10166() != class_2350.class_2351.field_11051 && ((Boolean)centerState.method_11654((class_2769)EASTWEST)).booleanValue() && !((Boolean)neighboringBlockstate.method_11654((class_2769)EASTWEST)).booleanValue()) {
                neighboringBlockstate = (class_2680)neighboringBlockstate.method_11657((class_2769)EASTWEST, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (direction.method_10166() != class_2350.class_2351.field_11052 && ((Boolean)centerState.method_11654((class_2769)UPDOWN)).booleanValue() && !((Boolean)neighboringBlockstate.method_11654((class_2769)UPDOWN)).booleanValue()) {
                neighboringBlockstate = (class_2680)neighboringBlockstate.method_11657((class_2769)UPDOWN, (Comparable)Boolean.valueOf(true));
                changedState = true;
            }
            if (!changedState) continue;
            level.method_8652(sidePos, neighboringBlockstate, 3);
        }
    }

    @NotNull
    private class_2680 getStateForSpot(class_1922 blockgetter, class_2338 blockpos) {
        class_2680 currentBlockstate = this.method_9564();
        for (class_2350 direction : class_2350.values()) {
            class_2680 neighboringBlockstate = blockgetter.method_8320(blockpos.method_10093(direction));
            if (!(neighboringBlockstate.method_26204() instanceof HoneyWeb)) continue;
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                if (((Boolean)neighboringBlockstate.method_11654((class_2769)NORTHSOUTH)).booleanValue()) {
                    currentBlockstate = (class_2680)currentBlockstate.method_11657((class_2769)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
                }
                if (!((Boolean)neighboringBlockstate.method_11654((class_2769)EASTWEST)).booleanValue()) continue;
                currentBlockstate = (class_2680)currentBlockstate.method_11657((class_2769)EASTWEST, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (direction.method_10166() == class_2350.class_2351.field_11048) {
                if (((Boolean)neighboringBlockstate.method_11654((class_2769)UPDOWN)).booleanValue()) {
                    currentBlockstate = (class_2680)currentBlockstate.method_11657((class_2769)UPDOWN, (Comparable)Boolean.valueOf(true));
                }
                if (!((Boolean)neighboringBlockstate.method_11654((class_2769)EASTWEST)).booleanValue()) continue;
                currentBlockstate = (class_2680)currentBlockstate.method_11657((class_2769)EASTWEST, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (direction.method_10166() != class_2350.class_2351.field_11051) continue;
            if (((Boolean)neighboringBlockstate.method_11654((class_2769)UPDOWN)).booleanValue()) {
                currentBlockstate = (class_2680)currentBlockstate.method_11657((class_2769)UPDOWN, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)neighboringBlockstate.method_11654((class_2769)NORTHSOUTH)).booleanValue()) continue;
            currentBlockstate = (class_2680)currentBlockstate.method_11657((class_2769)NORTHSOUTH, (Comparable)Boolean.valueOf(true));
        }
        return currentBlockstate;
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> (class_2680)((class_2680)blockState.method_11657((class_2769)NORTHSOUTH, (Comparable)((Boolean)blockState.method_11654((class_2769)EASTWEST)))).method_11657((class_2769)EASTWEST, (Comparable)((Boolean)blockState.method_11654((class_2769)NORTHSOUTH)));
            default -> blockState;
        };
    }

    public void method_9496(class_2680 blockState, class_1937 world, class_2338 position, class_5819 random) {
        for (int i = 0; i == random.method_43048(50); ++i) {
            this.addParticle((class_2394)class_2398.field_20534, world, random, position, blockState.method_26218((class_1922)world, position));
        }
    }

    protected void addParticle(class_2394 particleType, class_1937 world, class_5819 random, class_2338 blockPos, class_265 blockShape) {
        this.addParticle(particleType, world, random, (double)blockPos.method_10263() + blockShape.method_1091(class_2350.class_2351.field_11048), (double)blockPos.method_10263() + blockShape.method_1105(class_2350.class_2351.field_11048), (double)blockPos.method_10264() + blockShape.method_1091(class_2350.class_2351.field_11052), (double)blockPos.method_10264() + blockShape.method_1105(class_2350.class_2351.field_11052), (double)blockPos.method_10260() + blockShape.method_1091(class_2350.class_2351.field_11051), (double)blockPos.method_10260() + blockShape.method_1105(class_2350.class_2351.field_11051));
    }

    private void addParticle(class_2394 particleType, class_1937 world, class_5819 random, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin) {
        world.method_8406(particleType, class_3532.method_16436((double)random.method_43058(), (double)xMin, (double)xMax), class_3532.method_16436((double)random.method_43058(), (double)yMin, (double)yMax), class_3532.method_16436((double)random.method_43058(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

