/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.structures.trees;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.world.structures.TreePlacer;
import com.legacy.blue_skies.world.structures.trees.FrostbrightTreePieces;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FrostbrightTreeGenerator
extends TreePlacer {
    private static final IBlockState LOG = BlocksSkies.frostbright_log.func_176223_P();
    private boolean natural;

    public FrostbrightTreeGenerator(boolean notify, boolean natural) {
        super(notify);
        this.natural = natural;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        if (this.natural) {
            pos = worldIn.func_175725_q(pos);
        }
        Material material1 = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
        Material material2 = worldIn.func_180495_p(pos.func_177982_a(1, -1, 1)).func_185904_a();
        if (!(material1 != Material.field_151577_b && material1 != Material.field_151578_c || material2 != Material.field_151577_b && material2 != Material.field_151578_c)) {
            int h = rand.nextInt(7) + (rand.nextInt(9) == 0 ? 25 : 15);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < 2; ++x) {
                    for (int z = 0; z < 2; ++z) {
                        this.setLog(worldIn, pos.func_177982_a(x, y, z), BlockLog.EnumAxis.Y);
                    }
                }
            }
            FrostbrightTreePieces.top.placeBlocks(worldIn, pos.func_177981_b(h));
            FrostbrightTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(2, rand.nextInt(h - 9) + 3, -1 + rand.nextInt(2)));
            FrostbrightTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(2 - rand.nextInt(2), rand.nextInt(h - 9) + 3, 2), Rotation.CLOCKWISE_90);
            FrostbrightTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(-1, rand.nextInt(h - 9) + 3, 2 - rand.nextInt(2)), Rotation.CLOCKWISE_180);
            FrostbrightTreePieces.branch.placeBlocks(worldIn, pos.func_177982_a(-1 + rand.nextInt(2), rand.nextInt(h - 9) + 3, -1), Rotation.COUNTERCLOCKWISE_90);
            for (int c = 0; c < 4; ++c) {
                int l;
                int y = h - 2 - rand.nextInt(2);
                int xz = rand.nextInt(2);
                int length = rand.nextInt(2) + 1;
                for (l = y; l < h; ++l) {
                    if (c == 0) {
                        this.setLog(worldIn, pos.func_177982_a(2 + length, l + 1, xz), BlockLog.EnumAxis.Y);
                    }
                    if (c == 1) {
                        this.setLog(worldIn, pos.func_177982_a(xz, l + 1, 2 + length), BlockLog.EnumAxis.Y);
                    }
                    if (c == 2) {
                        this.setLog(worldIn, pos.func_177982_a(-1 - length, l + 1, xz), BlockLog.EnumAxis.Y);
                    }
                    if (c != 3) continue;
                    this.setLog(worldIn, pos.func_177982_a(xz, l + 1, -1 - length), BlockLog.EnumAxis.Y);
                }
                for (l = 0; l < length + 1; ++l) {
                    if (c == 0) {
                        this.setLog(worldIn, pos.func_177982_a(2 + l, y, xz), BlockLog.EnumAxis.X);
                    }
                    if (c == 1) {
                        this.setLog(worldIn, pos.func_177982_a(xz, y, 2 + l), BlockLog.EnumAxis.Z);
                    }
                    if (c == 2) {
                        this.setLog(worldIn, pos.func_177982_a(-1 - l, y, xz), BlockLog.EnumAxis.X);
                    }
                    if (c != 3) continue;
                    this.setLog(worldIn, pos.func_177982_a(xz, y, -1 - l), BlockLog.EnumAxis.Z);
                }
            }
            for (int x = -1; x <= 2; ++x) {
                for (int z = -1; z <= 2; ++z) {
                    if (!((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                    this.setLog(worldIn, pos.func_177982_a(x, 0, z), BlockLog.EnumAxis.Y);
                    this.setLog(worldIn, pos.func_177982_a(x, 1, z), BlockLog.EnumAxis.NONE);
                    if (!rand.nextBoolean()) continue;
                    this.setLog(worldIn, pos.func_177982_a(x, 2, z), BlockLog.EnumAxis.NONE);
                }
            }
            return true;
        }
        return false;
    }

    protected void setLog(World worldIn, BlockPos pos, BlockLog.EnumAxis axis) {
        if (worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) || worldIn.func_180495_p(pos).func_177230_c() instanceof BlockLeaves) {
            this.func_175903_a(worldIn, pos, LOG.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
        }
    }

    @Override
    public void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
    }
}

