/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.structures.misc;

import com.legacy.blue_skies.blocks.BlocksSkies;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WitchHouseGenerator
extends WorldGenerator {
    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        pos = worldIn.func_175725_q(pos);
        WorldServer worldserver = (WorldServer)worldIn;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        TemplateManager templatemanager = worldserver.func_184163_y();
        Template houseTemplate = templatemanager.func_186237_a(minecraftserver, new ResourceLocation("blue_skies:misc/witch_house"));
        if (houseTemplate == null) {
            System.out.println("NO STRUCTURE");
            return false;
        }
        if (this.canHouseSpawnHere(houseTemplate, (World)worldserver, pos)) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
            BlockPos placementPos = worldIn.func_175725_q(pos).func_177979_c(1);
            PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186226_b(false);
            houseTemplate.func_189962_a(worldIn, placementPos, placementsettings, 3);
            Map map = houseTemplate.func_186258_a(placementPos, placementsettings);
            for (Map.Entry entry : map.entrySet()) {
                String s = (String)entry.getValue();
                this.handleDataMarker(s, (BlockPos)entry.getKey(), worldIn, rand);
            }
            System.out.println("Witch House at: (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")");
            return true;
        }
        return false;
    }

    protected void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
        if (function.startsWith("witch")) {
            EntityWitch witch = new EntityWitch(worldIn);
            witch.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
            witch.func_110163_bv();
            worldIn.func_72838_d((Entity)witch);
            worldIn.func_175698_g(pos);
        } else if (function.contains("brewing_stand")) {
            BlockPos blockpos = pos.func_177979_c(2);
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityBrewingStand) {
                if (rand.nextInt(2) == 0) {
                    ((TileEntityBrewingStand)tileentity).func_70299_a(0, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionType.func_185168_a((String)"regeneration")));
                } else {
                    ((TileEntityBrewingStand)tileentity).func_70299_a(0, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionType.func_185168_a((String)"poison")));
                }
                if (rand.nextInt(2) == 0) {
                    ((TileEntityBrewingStand)tileentity).func_70299_a(2, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionType.func_185168_a((String)"luck")));
                } else {
                    ((TileEntityBrewingStand)tileentity).func_70299_a(2, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionType.func_185168_a((String)"blue_skies:unluck")));
                }
            }
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canHouseSpawnHere(Template template, World worldIn, BlockPos posAboveGround) {
        int zwidth = template.func_186259_a().func_177952_p() - 2;
        int xwidth = template.func_186259_a().func_177958_n() - 2;
        boolean corner1 = this.isCornerValid(worldIn, posAboveGround);
        boolean corner2 = this.isCornerValid(worldIn, posAboveGround.func_177982_a(xwidth, 0, zwidth));
        boolean corner3 = this.isCornerValid(worldIn, posAboveGround.func_177982_a(0, 0, zwidth));
        boolean corner4 = this.isCornerValid(worldIn, posAboveGround.func_177982_a(xwidth, 0, 0));
        return posAboveGround.func_177956_o() > 50 && corner1 && corner2 && corner3 && corner4;
    }

    private boolean isCornerValid(World worldIn, BlockPos pos) {
        Block block1 = worldIn.func_180495_p(pos.func_177981_b(1)).func_177230_c();
        Block block2 = worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c();
        Block block3 = worldIn.func_180495_p(pos).func_177230_c();
        return (block1.func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(1)) || block2.func_176200_f((IBlockAccess)worldIn, pos.func_177981_b(2))) && block3 != Blocks.field_150355_j && block3 == BlocksSkies.lunar_grass;
    }
}

