/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.structures;

import com.legacy.blue_skies.SkiesConfig;
import com.legacy.blue_skies.world.SkyWorldManager;
import com.legacy.blue_skies.world.structures.dungeons.BlindingEverbrightDungeonGenerator;
import com.legacy.blue_skies.world.structures.dungeons.BlindingEverdawnDungeonGenerator;
import com.legacy.blue_skies.world.structures.misc.GateKeeperGenerator;
import com.legacy.blue_skies.world.structures.misc.WitchHouseGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StructureGenerator
extends WorldGenerator
implements IWorldGenerator {
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (world.field_73011_w.getDimension() == 0) {
            this.generateOverworld(world, rand, blockX + 8, blockZ + 8);
        } else if (world.field_73011_w.getDimension() == SkiesConfig.dimension.everbright_dimension_id) {
            this.generateEverbright(world, rand, blockX + 8, blockZ + 8);
        } else if (world.field_73011_w.getDimension() == SkiesConfig.dimension.everdawn_dimension_id) {
            this.generateEverdawn(world, rand, blockX + 8, blockZ + 8);
        }
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        if (rand.nextInt(240) == 0) {
            BlockPos pos = new BlockPos(blockX, 0, blockZ);
            GateKeeperGenerator gateKeeper = new GateKeeperGenerator();
            gateKeeper.func_180709_b(world, rand, pos);
        }
    }

    private void generateEverbright(World world, Random rand, int blockX, int blockZ) {
        if (rand.nextInt(230) == 0 && (world.field_73011_w.getBiomeForCoords(new BlockPos(blockX, 0, blockZ)) == SkyWorldManager.calming_skies || world.field_73011_w.getBiomeForCoords(new BlockPos(blockX, 0, blockZ)) == SkyWorldManager.brightlands)) {
            BlockPos pos = new BlockPos(blockX, 0, blockZ);
            BlindingEverbrightDungeonGenerator silverDungeon = new BlindingEverbrightDungeonGenerator();
            silverDungeon.func_180709_b(world, rand, pos);
        }
    }

    private void generateEverdawn(World world, Random rand, int blockX, int blockZ) {
        BlockPos pos;
        if (rand.nextInt(250) == 0) {
            pos = new BlockPos(blockX, 0, blockZ);
            BlindingEverdawnDungeonGenerator silverDungeon = new BlindingEverdawnDungeonGenerator();
            silverDungeon.func_180709_b(world, rand, pos);
        }
        if (rand.nextInt(2) == 0 && world.field_73011_w.getBiomeForCoords(new BlockPos(blockX, 0, blockZ)) != SkyWorldManager.crystal_dunes) {
            pos = new BlockPos(blockX, 0, blockZ);
            WitchHouseGenerator witchHouse = new WitchHouseGenerator();
            witchHouse.func_180709_b(world, rand, pos);
        }
    }

    public static int getLakeFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 31) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150355_j || blockAt == Blocks.field_150358_i;
        }
        return y;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return false;
    }
}

