/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.biome.decoration.trees;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.natural.BlockSkyFruitLeaves;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenNectarineTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = BlocksSkies.dusk_log.func_176223_P();
    private static final IBlockState LEAF = BlocksSkies.nectarine_leaves.func_176223_P().func_177226_a((IProperty)BlockSkyFruitLeaves.MATURE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockSkyFruitLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockSkyFruitLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState LEAF2 = BlocksSkies.nectarine_leaves.func_176223_P().func_177226_a((IProperty)BlockSkyFruitLeaves.MATURE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockSkyFruitLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockSkyFruitLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final boolean useExtraRandomHeight;

    public WorldGenNectarineTree(boolean notify, boolean useExtraRandomHeightIn) {
        super(notify);
        this.useExtraRandomHeight = useExtraRandomHeightIn;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + 6;
        if (this.useExtraRandomHeight) {
            i += rand.nextInt(7);
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            if (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                this.setLeaves(worldIn, position, rand, i);
                for (int j2 = 0; j2 < i; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), LOG);
                }
                this.setSideLogs(worldIn, position, rand);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void setLeaves(World worldIn, BlockPos position, Random rand, int height) {
        int i;
        BlockPos blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o() - 1 + height, position.func_177952_p());
        for (i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -3; k <= -1; ++k) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    if (k == -3 && rand.nextInt(3) == 0) {
                        this.setLeaf(worldIn, rand, blockpos.func_177982_a(i, k, j));
                    }
                    if (k < -2) continue;
                    this.setLeaf(worldIn, rand, blockpos.func_177982_a(i, k, j));
                }
            }
        }
        for (i = 0; i <= 1; ++i) {
            if (i == 0) {
                this.setLeaf(worldIn, rand, blockpos.func_177982_a(1, i, 1));
                this.setLeaf(worldIn, rand, blockpos.func_177982_a(1, i, -1));
                this.setLeaf(worldIn, rand, blockpos.func_177982_a(-1, i, 1));
                this.setLeaf(worldIn, rand, blockpos.func_177982_a(-1, i, -1));
            }
            this.setLeaf(worldIn, rand, blockpos.func_177982_a(1, i, 0));
            this.setLeaf(worldIn, rand, blockpos.func_177982_a(0, i, 1));
            this.setLeaf(worldIn, rand, blockpos.func_177982_a(0, i, 0));
            this.setLeaf(worldIn, rand, blockpos.func_177982_a(0, i, -1));
            this.setLeaf(worldIn, rand, blockpos.func_177982_a(-1, i, 0));
        }
        this.setLeaf(worldIn, rand, blockpos.func_177982_a(2, 0, 0));
        this.setLeaf(worldIn, rand, blockpos.func_177982_a(-2, 0, 0));
        this.setLeaf(worldIn, rand, blockpos.func_177982_a(0, 0, 2));
        this.setLeaf(worldIn, rand, blockpos.func_177982_a(0, 0, -2));
    }

    protected void setSideLogs(World worldIn, BlockPos position, Random rand) {
        BlockPos blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        for (int i = 0; i >= -1; --i) {
            this.setLog(worldIn, blockpos.func_177982_a(1, i, 0));
            this.setLog(worldIn, blockpos.func_177982_a(-1, i, 0));
            this.setLog(worldIn, blockpos.func_177982_a(0, i, 1));
            this.setLog(worldIn, blockpos.func_177982_a(0, i, -1));
        }
        this.setLog(worldIn, blockpos.func_177982_a(rand.nextInt(3) - 1, 1, 0));
        this.setLog(worldIn, blockpos.func_177982_a(0, 1, rand.nextInt(3) - 1));
    }

    protected void setLeaf(World worldIn, Random rand, BlockPos position) {
        IBlockState state = worldIn.func_180495_p(position);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, position) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, position) || state.func_185904_a() == Material.field_151582_l) {
            if (rand.nextInt(3) == 0) {
                this.func_175903_a(worldIn, position, LEAF2);
            } else {
                this.func_175903_a(worldIn, position, LEAF);
            }
        }
    }

    protected void setLog(World worldIn, BlockPos position) {
        if (this.isReplaceable(worldIn, position)) {
            this.func_175903_a(worldIn, position, LOG);
        }
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151585_k || blockType instanceof BlockBush;
    }
}

