/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.village;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.construction.BlockSkyDoor;
import com.legacy.blue_skies.blocks.misc.BlockSkyWallMoonstone;
import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.entities.villager.SkyProfession;
import com.legacy.blue_skies.entities.villager.SkyVillagerProfessionRegistry;
import com.legacy.blue_skies.tile_entities.TileEntityBluebrightChest;
import com.legacy.blue_skies.variables.SkiesLootTables;
import com.legacy.blue_skies.world.everbright.biome.BiomeBrightlands;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class StructureEverbrightVillagePieces {
    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"ViBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"ViDF");
        MapGenStructureIO.func_143031_a(Field2.class, (String)"ViF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"ViL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"ViPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"ViSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"ViSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"ViST");
        MapGenStructureIO.func_143031_a(House2.class, (String)"ViS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"ViStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"ViSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"ViTRH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"ViW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random random, int size) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(1 + size))));
        list.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(5 + size * 3))));
        list.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(2 + size))));
        list.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a((Random)random, (int)(1 + size), (int)(4 + size))));
        list.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a((Random)random, (int)(2 + size), (int)(4 + size * 2))));
        list.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a((Random)random, (int)0, (int)(1 + size))));
        list.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a((Random)random, (int)(0 + size), (int)(3 + size * 2))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int updatePieceWeight(List<PieceWeight> p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight StructureEverbrightVillagePieces$pieceweight : p_75079_0_) {
            if (StructureEverbrightVillagePieces$pieceweight.villagePiecesLimit > 0 && StructureEverbrightVillagePieces$pieceweight.villagePiecesSpawned < StructureEverbrightVillagePieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += StructureEverbrightVillagePieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village findAndCreateComponentFactory(Start start, PieceWeight weight, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        Class<? extends Village> oclass = weight.villagePieceClass;
        Village StructureEverbrightVillagePieces$village = null;
        if (oclass == House4Garden.class) {
            StructureEverbrightVillagePieces$village = House4Garden.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Church.class) {
            StructureEverbrightVillagePieces$village = Church.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == House1.class) {
            StructureEverbrightVillagePieces$village = House1.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == WoodHut.class) {
            StructureEverbrightVillagePieces$village = WoodHut.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Hall.class) {
            StructureEverbrightVillagePieces$village = Hall.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Field1.class) {
            StructureEverbrightVillagePieces$village = Field1.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == Field2.class) {
            StructureEverbrightVillagePieces$village = Field2.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == House2.class) {
            StructureEverbrightVillagePieces$village = House2.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        } else if (oclass == House3.class) {
            StructureEverbrightVillagePieces$village = House3.createPiece(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
        }
        return StructureEverbrightVillagePieces$village;
    }

    private static Village generateComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        int i = StructureEverbrightVillagePieces.updatePieceWeight(start.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = rand.nextInt(i);
            for (PieceWeight StructureEverbrightVillagePieces$pieceweight : start.structureVillageWeightedPieceList) {
                if ((k -= StructureEverbrightVillagePieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!StructureEverbrightVillagePieces$pieceweight.canSpawnMoreVillagePiecesOfType(componentType) || StructureEverbrightVillagePieces$pieceweight == start.structVillagePieceWeight && start.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village StructureEverbrightVillagePieces$village = StructureEverbrightVillagePieces.findAndCreateComponentFactory(start, StructureEverbrightVillagePieces$pieceweight, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType);
                if (StructureEverbrightVillagePieces$village == null) continue;
                ++StructureEverbrightVillagePieces$pieceweight.villagePiecesSpawned;
                start.structVillagePieceWeight = StructureEverbrightVillagePieces$pieceweight;
                if (!StructureEverbrightVillagePieces$pieceweight.canSpawnMoreVillagePieces()) {
                    start.structureVillageWeightedPieceList.remove(StructureEverbrightVillagePieces$pieceweight);
                }
                return StructureEverbrightVillagePieces$village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.findPieceBox(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing);
        if (structureboundingbox != null) {
            return new Torch(start, componentType, rand, structureboundingbox, facing);
        }
        return null;
    }

    private static StructureComponent generateAndAddComponent(Start start, List<StructureComponent> structureComponents, Random rand, int structureMinX, int structureMinY, int structureMinZ, EnumFacing facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(structureMinX - start.func_74874_b().field_78897_a) <= 112 && Math.abs(structureMinZ - start.func_74874_b().field_78896_c) <= 112) {
            Village structurecomponent = StructureEverbrightVillagePieces.generateComponent(start, structureComponents, rand, structureMinX, structureMinY, structureMinZ, facing, componentType + 1);
            if (structurecomponent != null) {
                structureComponents.add(structurecomponent);
                start.pendingHouses.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    private static StructureComponent generateAndAddRoadPiece(Start start, List<StructureComponent> p_176069_1_, Random rand, int p_176069_3_, int p_176069_4_, int p_176069_5_, EnumFacing facing, int p_176069_7_) {
        if (p_176069_7_ > 3 + start.terrainType) {
            return null;
        }
        if (Math.abs(p_176069_3_ - start.func_74874_b().field_78897_a) <= 112 && Math.abs(p_176069_5_ - start.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = Path.findPieceBox(start, p_176069_1_, rand, p_176069_3_, p_176069_4_, p_176069_5_, facing);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                Path structurecomponent = new Path(start, p_176069_7_, rand, structureboundingbox, facing);
                p_176069_1_.add(structurecomponent);
                start.pendingRoads.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start start, int type, Random rand, StructureBoundingBox structurebb, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = structurebb;
            this.isTallHouse = rand.nextBoolean();
            this.tablePosition = rand.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("T", this.tablePosition);
            tagCompound.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.tablePosition = tagCompound.func_74762_e("T");
            this.isTallHouse = tagCompound.func_74767_n("C");
        }

        public static WoodHut createPiece(Start start, List<StructureComponent> p_175853_1_, Random rand, int p_175853_3_, int p_175853_4_, int p_175853_5_, EnumFacing facing, int p_175853_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175853_3_, (int)p_175853_4_, (int)p_175853_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (EnumFacing)facing);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175853_1_, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(start, p_175853_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_log.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_fence.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 3, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 3, BlocksSkies.turquoise_dirt.func_176223_P(), BlocksSkies.turquoise_dirt.func_176223_P(), false);
            if (this.isTallHouse) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 2, 4, 3, iblockstate3, iblockstate3, false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 2, 5, 3, iblockstate3, iblockstate3, false);
            }
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 2, 4, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 4, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 4, 0, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 4, 3, 3, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 2, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 3, 2, 2, structureBoundingBoxIn);
            if (this.tablePosition > 0) {
                this.func_175811_a(worldIn, iblockstate4, this.tablePosition, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150404_cg.func_176223_P(), this.tablePosition, 2, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate2, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.coarse_turquoise_dirt) {
                    this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.func_74871_b(worldIn, j, 6, i, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, i, structureBoundingBoxIn);
                }
            }
            this.spawnWarriors(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start start, int type, Random rand, int x, int z) {
            super(start, type);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, 65, z, x + 6 - 1, 78, z + 6 - 1) : new StructureBoundingBox(x, 65, z, x + 6 - 1, 78, z + 6 - 1);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 2, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_stonebrick.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_fence.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 4, 12, 4, iblockstate, Blocks.field_150358_i.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 13, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 14, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 14, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 13, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 14, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 15, 1, 4, 15, 4, iblockstate, iblockstate, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(worldIn, iblockstate, j, 11, i, structureBoundingBoxIn);
                    this.func_74871_b(worldIn, j, 12, i, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int averageGroundLvl = -1;
        private int villagersSpawned;
        private int warriorsSpawned;
        protected int structureType;
        protected boolean isZombieInfested;
        protected Start startPiece;

        public Village() {
        }

        protected Village(Start start, int type) {
            super(type);
            if (start != null) {
                this.structureType = start.structureType;
                this.isZombieInfested = start.isZombieInfested;
                this.startPiece = start;
            }
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.averageGroundLvl);
            tagCompound.func_74768_a("VCount", this.villagersSpawned);
            tagCompound.func_74774_a("Type", (byte)this.structureType);
            tagCompound.func_74757_a("Zombie", this.isZombieInfested);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.averageGroundLvl = tagCompound.func_74762_e("HPos");
            this.villagersSpawned = tagCompound.func_74762_e("VCount");
            this.structureType = tagCompound.func_74771_c("Type");
            if (tagCompound.func_74767_n("Desert")) {
                this.structureType = 1;
            }
            this.isZombieInfested = tagCompound.func_74767_n("Zombie");
        }

        @Nullable
        protected StructureComponent getNextComponentNN(Start start, List<StructureComponent> structureComponents, Random rand, int p_74891_4_, int p_74891_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentPP(Start start, List<StructureComponent> structureComponents, Random rand, int p_74894_4_, int p_74894_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return StructureEverbrightVillagePieces.generateAndAddComponent(start, structureComponents, rand, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int getAverageGroundLevel(World worldIn, StructureBoundingBox structurebb) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 65, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i() - 1);
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox structurebb) {
            return structurebb != null && structurebb.field_78895_b > 10;
        }

        protected void spawnVillagers(World worldIn, StructureBoundingBox structurebb, int x, int y, int z, int count) {
            if (this.villagersSpawned < count) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < count && structurebb.func_175898_b((Vec3i)new BlockPos(j = this.func_74865_a(x + i, z), k = this.func_74862_a(y), l = this.func_74873_b(x + i, z))); ++i) {
                    ++this.villagersSpawned;
                    if (this.isZombieInfested) {
                        int chances = worldIn.field_73012_v.nextInt(5);
                        EntityZombieVillager entityzombievillager = new EntityZombieVillager(worldIn);
                        SkyProfession profs = chances == 0 ? SkyVillagerProfessionRegistry.stargazer : (chances == 1 ? SkyVillagerProfessionRegistry.wrangler : (chances == 2 ? SkyVillagerProfessionRegistry.gatekeeper : (chances == 3 ? SkyVillagerProfessionRegistry.shoveler : VillagerRegistry.FARMER)));
                        entityzombievillager.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                        entityzombievillager.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityzombievillager)), (IEntityLivingData)null);
                        entityzombievillager.func_110163_bv();
                        entityzombievillager.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 99999, 0, false, false));
                        entityzombievillager.setForgeProfession((VillagerRegistry.VillagerProfession)profs);
                        worldIn.func_72838_d((Entity)entityzombievillager);
                        continue;
                    }
                    EntityVillager entityvillager = new EntityVillager(worldIn);
                    entityvillager.func_70012_b((double)j + 0.5, (double)k, (double)l + 0.5, 0.0f, 0.0f);
                    entityvillager.setProfession(this.chooseForgeProfession(i, entityvillager.getProfessionForge(), worldIn));
                    entityvillager.func_190672_a(worldIn.func_175649_E(new BlockPos((Entity)entityvillager)), (IEntityLivingData)null, false);
                    worldIn.func_72838_d((Entity)entityvillager);
                }
            }
        }

        protected void spawnWarriors(World worldIn, StructureBoundingBox structurebb, int x, int y, int z, int count) {
            int j = this.func_74865_a(x, z);
            int k = this.func_74862_a(y);
            int l = this.func_74873_b(x, z);
            if (this.warriorsSpawned < count && !this.isZombieInfested) {
                for (int i = this.warriorsSpawned; i < count; ++i) {
                    ++this.warriorsSpawned;
                    EntityVillagerWarrior warrior = new EntityVillagerWarrior(worldIn);
                    warrior.setVillagerType(8);
                    warrior.func_98053_h(false);
                    warrior.func_70012_b((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    worldIn.func_72838_d((Entity)warrior);
                }
            }
        }

        @Deprecated
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return currentVillagerProfession;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof, World world) {
            return VillagerRegistry.getById((int)this.chooseProfession(count, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof)));
        }

        protected IBlockState getBiomeSpecificBlockState(IBlockState blockstateIn) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, blockstateIn);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            if (this.structureType == 1) {
                if (blockstateIn.func_177230_c() == BlocksSkies.bluebright_log) {
                    return BlocksSkies.starlit_log.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == BlocksSkies.bluebright_planks) {
                    return BlocksSkies.starlit_planks.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == BlocksSkies.bluebright_stairs) {
                    return BlocksSkies.starlit_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, blockstateIn.func_177229_b((IProperty)BlockStairs.field_176309_a));
                }
                if (blockstateIn.func_177230_c() == BlocksSkies.bluebright_fence) {
                    return BlocksSkies.starlit_fence.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == Blocks.field_150351_n) {
                    return BlocksSkies.coarse_turquoise_dirt.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == BlocksSkies.bluebright_bookshelf) {
                    return BlocksSkies.starlit_bookshelf.func_176223_P();
                }
                if (blockstateIn.func_177230_c() == BlocksSkies.bluebright_crafting_table) {
                    return BlocksSkies.starlit_crafting_table.func_176223_P();
                }
            }
            return blockstateIn;
        }

        protected Block biomeDoor() {
            switch (this.structureType) {
                case 1: {
                    return BlocksSkies.starlit_door;
                }
            }
            return BlocksSkies.bluebright_door;
        }

        protected void generateSkyDoor(World worldIn, StructureBoundingBox sbb, Random rand, int x, int y, int z, EnumFacing facing, Block door) {
            this.func_175811_a(worldIn, door.func_176223_P().func_177226_a((IProperty)BlockSkyDoor.field_176520_a, (Comparable)facing), x, y, z, sbb);
            this.func_175811_a(worldIn, door.func_176223_P().func_177226_a((IProperty)BlockSkyDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockSkyDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), x, y + 1, z, sbb);
        }

        protected void createVillageDoor(World p_189927_1_, StructureBoundingBox p_189927_2_, Random p_189927_3_, int p_189927_4_, int p_189927_5_, int p_189927_6_, EnumFacing p_189927_7_) {
            if (!this.isZombieInfested) {
                this.generateSkyDoor(p_189927_1_, p_189927_2_, p_189927_3_, p_189927_4_, p_189927_5_, p_189927_6_, EnumFacing.NORTH, this.biomeDoor());
            }
        }

        protected void placeMoonstone(World p_189926_1_, EnumFacing p_189926_2_, int p_189926_3_, int p_189926_4_, int p_189926_5_, StructureBoundingBox p_189926_6_) {
            if (!this.isZombieInfested) {
                this.func_175811_a(p_189926_1_, BlocksSkies.moonstone.func_176223_P().func_177226_a((IProperty)BlockSkyWallMoonstone.field_176387_N, (Comparable)p_189926_2_), p_189926_3_, p_189926_4_, p_189926_5_, p_189926_6_);
            }
        }

        protected void func_175808_b(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(blockstateIn);
            super.func_175808_b(worldIn, iblockstate, x, y, z, boundingboxIn);
        }

        protected void setStructureType(int p_189924_1_) {
            this.structureType = p_189924_1_;
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start start, int p_i45568_2_, Random rand, StructureBoundingBox p_i45568_4_, EnumFacing facing) {
            super(start, p_i45568_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45568_4_;
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175856_1_, Random rand, int p_175856_3_, int p_175856_4_, int p_175856_5_, EnumFacing facing) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175856_3_, (int)p_175856_4_, (int)p_175856_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175856_1_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_stonebrick_wall.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 1, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.moonstone_lantern.func_176223_P(), 1, 3, 0, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> pendingHouses = Lists.newArrayList();
        public List<StructureComponent> pendingRoads = Lists.newArrayList();
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider chunkManagerIn, int p_i2104_2_, Random rand, int p_i2104_4_, int p_i2104_5_, List<PieceWeight> p_i2104_6_, int p_i2104_7_) {
            super(null, 0, rand, p_i2104_4_, p_i2104_5_);
            Biome biome;
            this.worldChunkMngr = chunkManagerIn;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            this.biome = biome = chunkManagerIn.func_180300_a(new BlockPos(p_i2104_4_, 0, p_i2104_5_), Biomes.field_180279_ad);
            this.startPiece = this;
            if (biome instanceof BiomeBrightlands) {
                this.structureType = 1;
            }
            this.setStructureType(this.structureType);
            this.isZombieInfested = rand.nextInt(50) == 0;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int type) {
            super(start, type);
        }
    }

    public static class PieceWeight {
        public Class<? extends Village> villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Village> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int componentType) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start start, int p_i45562_2_, Random rand, StructureBoundingBox p_i45562_4_, EnumFacing facing) {
            super(start, p_i45562_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45562_4_;
            this.length = Math.max(p_i45562_4_.func_78883_b(), p_i45562_4_.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.length);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.length = tagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            boolean flag = false;
            for (int i = rand.nextInt(5); i < this.length - 8; i += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)componentIn, listIn, rand, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.func_74874_b().func_78883_b(), structurecomponent.func_74874_b().func_78880_d());
                flag = true;
            }
            for (int j = rand.nextInt(5); j < this.length - 8; j += 2 + rand.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)componentIn, listIn, rand, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            EnumFacing enumfacing = this.func_186165_e();
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && rand.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureEverbrightVillagePieces.generateAndAddRoadPiece((Start)componentIn, listIn, rand, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox findPieceBox(Start start, List<StructureComponent> p_175848_1_, Random rand, int p_175848_3_, int p_175848_4_, int p_175848_5_, EnumFacing facing) {
            for (int i = 7 * MathHelper.func_76136_a((Random)rand, (int)3, (int)5); i >= 7; i -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175848_3_, (int)p_175848_4_, (int)p_175848_5_, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)facing);
                if (StructureComponent.func_74883_a(p_175848_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.coarse_turquoise_dirt.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P());
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone.func_176223_P());
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                block1: for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    BlockPos blockpos = new BlockPos(i, 65, j);
                    if (!structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) continue;
                    if ((blockpos = worldIn.func_175672_r(blockpos).func_177977_b()).func_177956_o() < worldIn.func_181545_F()) {
                        blockpos = new BlockPos(blockpos.func_177958_n(), worldIn.func_181545_F() - 1, blockpos.func_177952_p());
                    }
                    while (blockpos.func_177956_o() >= worldIn.func_181545_F() - 1) {
                        IBlockState iblockstate4 = worldIn.func_180495_p(blockpos);
                        if (iblockstate4.func_177230_c() == BlocksSkies.turquoise_grass && worldIn.func_175623_d(blockpos.func_177984_a())) {
                            worldIn.func_180501_a(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_177230_c() == BlocksSkies.turquoise_grass && worldIn.func_180495_p(blockpos.func_177984_a()) == BlocksSkies.turquoise_tallgrass) {
                            worldIn.func_180501_a(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.func_185904_a().func_76224_d()) {
                            worldIn.func_180501_a(blockpos, iblockstate1, 2);
                            continue block1;
                        }
                        blockpos = blockpos.func_177977_b();
                    }
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;

        public House4Garden() {
        }

        public House4Garden(Start start, int p_i45566_2_, Random rand, StructureBoundingBox p_i45566_4_, EnumFacing facing) {
            super(start, p_i45566_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45566_4_;
            this.isRoofAccessible = rand.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.isRoofAccessible = tagCompound.func_74767_n("Terrace");
        }

        public static House4Garden createPiece(Start start, List<StructureComponent> p_175858_1_, Random rand, int p_175858_3_, int p_175858_4_, int p_175858_5_, EnumFacing facing, int p_175858_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175858_3_, (int)p_175858_4_, (int)p_175858_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (EnumFacing)facing);
            return StructureComponent.func_74883_a(p_175858_1_, (StructureBoundingBox)structureboundingbox) != null ? null : new House4Garden(start, p_175858_7_, rand, structureboundingbox, facing);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_log.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_fence.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 0, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 3, 4, 3, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, iblockstate, 0, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 0, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 4, 3, 3, 4, iblockstate1, iblockstate1, false);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 0, structureBoundingBoxIn);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate2, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.coarse_turquoise_dirt) {
                    this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.isRoofAccessible) {
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 2, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 3, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 1, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 2, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 3, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 4, 5, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate4, 0, 5, 3, structureBoundingBoxIn);
            }
            if (this.isRoofAccessible) {
                IBlockState iblockstate5 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(worldIn, iblockstate5, 3, 1, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 3, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 3, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 3, 4, 3, structureBoundingBoxIn);
            }
            this.placeMoonstone(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 5; ++i) {
                    this.func_74871_b(worldIn, i, 6, j, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, i, -1, j, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 1, 1, 2, 1);
            return true;
        }

        @Override
        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof, World world) {
            if (this.structureType == 1) {
                return SkyVillagerProfessionRegistry.shoveler;
            }
            return SkyVillagerProfessionRegistry.wrangler;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start start, int type, Random rand, StructureBoundingBox p_i45561_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45561_4_;
        }

        public static House3 createPiece(Start start, List<StructureComponent> p_175849_1_, Random rand, int p_175849_3_, int p_175849_4_, int p_175849_5_, EnumFacing facing, int p_175849_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175849_3_, (int)p_175849_4_, (int)p_175849_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (EnumFacing)facing);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175849_1_, (StructureBoundingBox)structureboundingbox) == null ? new House3(start, p_175849_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_log.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 5, 8, 0, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 2, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 2, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 2, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 10, 7, 3, 10, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 2, 3, 5, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 3, 4, 4, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 4, 4, structureBoundingBoxIn);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            IBlockState iblockstate9 = iblockstate4;
            IBlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.func_175811_a(worldIn, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 4, 5, 3, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 4, 2, 7, 4, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 4, 4, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 5, 4, 6, 5, 10, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 6, 3, 5, 6, 10, iblockstate5, iblockstate5, false);
            for (int k = 4; k >= 1; --k) {
                this.func_175811_a(worldIn, iblockstate5, k, 2 + k, 7 - k, structureBoundingBoxIn);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.func_175811_a(worldIn, iblockstate10, k, 2 + k, k1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 6, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 7, 5, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 6, 6, 4, structureBoundingBoxIn);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.func_175811_a(worldIn, iblockstate9, l, 12 - l, l1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 8, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 5, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 4, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.turquoise_tallgrass && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.coarse_turquoise_dirt) {
                    this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.func_74871_b(worldIn, i2, 7, i1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, i2, -1, i1, structureBoundingBoxIn);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.func_74871_b(worldIn, j2, 7, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j2, -1, j1, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof, World world) {
            return SkyVillagerProfessionRegistry.stargazer;
        }
    }

    public static class House2
    extends Village {
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start start, int type, Random rand, StructureBoundingBox p_i45563_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45563_4_;
        }

        public static House2 createPiece(Start start, List<StructureComponent> p_175855_1_, Random rand, int p_175855_3_, int p_175855_4_, int p_175855_5_, EnumFacing facing, int p_175855_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175855_3_, (int)p_175855_4_, (int)p_175855_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (EnumFacing)facing);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175855_1_, (StructureBoundingBox)structureboundingbox) == null ? new House2(start, p_175855_7_, rand, structureboundingbox, facing) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasMadeChest = tagCompound.func_74767_n("Chest");
        }

        protected boolean func_191080_a(World worldIn, StructureBoundingBox structureBoundingBoxIn, Random rand, BlockPos pos, ResourceLocation loc, @Nullable IBlockState state) {
            if (structureBoundingBoxIn.func_175898_b((Vec3i)pos) && worldIn.func_180495_p(pos).func_177230_c() != BlocksSkies.bluebright_chest) {
                if (state == null) {
                    state = BlocksSkies.bluebright_chest.func_176223_P();
                }
                worldIn.func_180501_a(pos, state, 2);
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof TileEntityBluebrightChest) {
                    ((TileEntityBluebrightChest)tileentity).func_189404_a(loc, rand.nextLong());
                }
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iblockstate = BlocksSkies.turquoise_cobblestone.func_176223_P();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_log.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_fence.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 9, 0, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 4, 0, iblockstate5, iblockstate5, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 4, 6, iblockstate5, iblockstate5, false);
            this.func_175811_a(worldIn, iblockstate3, 3, 3, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 3, 2, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 3, 5, 3, 3, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 5, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 6, 5, 3, 6, iblockstate3, iblockstate3, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, 4, 9, 4, 6, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 7, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150356_k.func_176223_P(), 8, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 9, 2, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150460_al.func_176223_P(), 6, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 8, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150404_cg.func_176223_P(), 2, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 1, 4, structureBoundingBoxIn);
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.hasMadeChest = true;
                this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 5, 1, 5, SkiesLootTables.everbright_blacksmith);
            }
            for (int i = 6; i <= 8; ++i) {
                if (this.func_175807_a(worldIn, i, 0, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a) continue;
                this.func_175811_a(worldIn, iblockstate4, i, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, i, -1, -1, structureBoundingBoxIn).func_177230_c() != BlocksSkies.coarse_turquoise_dirt) continue;
                this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), i, -1, -1, structureBoundingBoxIn);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.func_74871_b(worldIn, j, 6, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int type, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static House1 createPiece(Start start, List<StructureComponent> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new House1(start, p_175850_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_fence.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate1, j, 6 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate2, j, 6 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, BlocksSkies.bluebright_bookshelf.func_176223_P(), BlocksSkies.bluebright_bookshelf.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate4, 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 6, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150404_cg.func_176223_P(), 6, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 4, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150404_cg.func_176223_P(), 4, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.bluebright_crafting_table.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.turquoise_tallgrass && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate5, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.coarse_turquoise_dirt) {
                    this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(worldIn, k, 9, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
            return VillagerRegistry.getById((int)1);
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start start, int type, Random rand, StructureBoundingBox p_i45567_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45567_4_;
        }

        public static Hall createPiece(Start start, List<StructureComponent> p_175857_1_, Random rand, int p_175857_3_, int p_175857_4_, int p_175857_5_, EnumFacing facing, int p_175857_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175857_3_, (int)p_175857_4_, (int)p_175857_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (EnumFacing)facing);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175857_1_, (StructureBoundingBox)structureboundingbox) == null ? new Hall(start, p_175857_7_, rand, structureboundingbox, facing) : null;
        }

        protected boolean func_191080_a(World worldIn, StructureBoundingBox structureBoundingBoxIn, Random rand, BlockPos pos, ResourceLocation loc, @Nullable IBlockState state) {
            if (structureBoundingBoxIn.func_175898_b((Vec3i)pos) && worldIn.func_180495_p(pos).func_177230_c() != BlocksSkies.bluebright_chest) {
                if (state == null) {
                    state = BlocksSkies.bluebright_chest.func_176223_P();
                }
                worldIn.func_180501_a(pos, state, 2);
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof TileEntityBluebrightChest) {
                    ((TileEntityBluebrightChest)tileentity).func_189404_a(loc, rand.nextLong());
                }
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone.func_176223_P());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_planks.func_176223_P());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_fence.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 0, 6, 8, 0, 10, BlocksSkies.coarse_turquoise_dirt.func_176223_P(), BlocksSkies.coarse_turquoise_dirt.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate, 6, 0, 6, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 6, 2, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 6, 8, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 10, 7, 1, 10, iblockstate6, iblockstate6, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 7, 0, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 8, 3, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 5, 7, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 3, 0, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 3, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 8, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 4, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 2, 8, 5, 3, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, iblockstate4, 0, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 0, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 8, 4, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 8, 4, 3, structureBoundingBoxIn);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate7, j, 4 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate8, j, 4 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, iblockstate5, 0, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 0, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate5, 8, 2, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate6, 2, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150404_cg.func_176223_P(), 2, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 1, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate7, 2, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 1, 1, 3, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 1, 7, 0, 3, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 6, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.NORTH, 2, 3, 1, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate7, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.coarse_turquoise_dirt) {
                    this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.SOUTH, 6, 3, 4, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 6, 1, 5, EnumFacing.SOUTH);
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    this.func_74871_b(worldIn, l, 7, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, l, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof, World world) {
            return SkyVillagerProfessionRegistry.stargazer;
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;

        public Field2() {
        }

        public Field2(Start start, int p_i45569_2_, Random rand, StructureBoundingBox p_i45569_4_, EnumFacing facing) {
            super(start, p_i45569_2_);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45569_4_;
            this.cropTypeA = this.getRandomCropType(rand);
            this.cropTypeB = this.getRandomCropType(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            tagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.cropTypeA = Block.func_149729_e((int)tagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)tagCompound.func_74762_e("CB"));
        }

        private Block getRandomCropType(Random rand) {
            switch (rand.nextInt(10)) {
                case 0: 
                case 1: {
                    return BlocksSkies.carrots;
                }
                case 2: 
                case 3: {
                    return BlocksSkies.potatoes;
                }
                case 4: {
                    return BlocksSkies.beetroots;
                }
            }
            return BlocksSkies.wheat;
        }

        public static Field2 createPiece(Start start, List<StructureComponent> p_175852_1_, Random rand, int p_175852_3_, int p_175852_4_, int p_175852_5_, EnumFacing facing, int p_175852_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175852_3_, (int)p_175852_4_, (int)p_175852_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (EnumFacing)facing);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175852_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field2(start, p_175852_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_log.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, BlocksSkies.turquoise_farmland.func_176223_P(), BlocksSkies.turquoise_farmland.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, BlocksSkies.turquoise_farmland.func_176223_P(), BlocksSkies.turquoise_farmland.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 5, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 5, 0, 8, iblockstate, iblockstate, false);
            if (this.structureType == 1) {
                IBlockState fence = this.getBiomeSpecificBlockState(BlocksSkies.starlit_fence.func_176223_P());
                IBlockState slab = this.getBiomeSpecificBlockState(BlocksSkies.starlit_slab.func_176223_P());
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 3, 0, 3, 3, 8, slab, slab, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 2, 8, fence, fence, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 2, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCrops)this.cropTypeA).func_185526_g();
                int k = j / 3;
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 2, 1, i, structureBoundingBoxIn);
                int l = ((BlockCrops)this.cropTypeB).func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 5, 1, i, structureBoundingBoxIn);
            }
            for (int j1 = 0; j1 < 9; ++j1) {
                for (int k1 = 0; k1 < 7; ++k1) {
                    this.func_74871_b(worldIn, k1, 4, j1, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, BlocksSkies.turquoise_dirt.func_176223_P(), k1, -1, j1, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;

        public Field1() {
        }

        public Field1(Start start, int type, Random rand, StructureBoundingBox p_i45570_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45570_4_;
            this.cropTypeA = this.getRandomCropType(rand);
            this.cropTypeB = this.getRandomCropType(rand);
            this.cropTypeC = this.getRandomCropType(rand);
            this.cropTypeD = this.getRandomCropType(rand);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            tagCompound.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            tagCompound.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            tagCompound.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.cropTypeA = Block.func_149729_e((int)tagCompound.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)tagCompound.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)tagCompound.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)tagCompound.func_74762_e("CD"));
            if (!(this.cropTypeA instanceof BlockCrops)) {
                this.cropTypeA = BlocksSkies.wheat;
            }
            if (!(this.cropTypeB instanceof BlockCrops)) {
                this.cropTypeB = BlocksSkies.carrots;
            }
            if (!(this.cropTypeC instanceof BlockCrops)) {
                this.cropTypeC = BlocksSkies.potatoes;
            }
            if (!(this.cropTypeD instanceof BlockCrops)) {
                this.cropTypeD = BlocksSkies.beetroots;
            }
        }

        private Block getRandomCropType(Random rand) {
            switch (rand.nextInt(10)) {
                case 0: 
                case 1: {
                    return BlocksSkies.carrots;
                }
                case 2: 
                case 3: {
                    return BlocksSkies.potatoes;
                }
                case 4: {
                    return BlocksSkies.beetroots;
                }
            }
            return BlocksSkies.wheat;
        }

        public static Field1 createPiece(Start start, List<StructureComponent> p_175851_1_, Random rand, int p_175851_3_, int p_175851_4_, int p_175851_5_, EnumFacing facing, int p_175851_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175851_3_, (int)p_175851_4_, (int)p_175851_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (EnumFacing)facing);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175851_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field1(start, p_175851_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(BlocksSkies.bluebright_log.func_176223_P());
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, BlocksSkies.turquoise_farmland.func_176223_P(), BlocksSkies.turquoise_farmland.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, BlocksSkies.turquoise_farmland.func_176223_P(), BlocksSkies.turquoise_farmland.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 0, 1, 8, 0, 7, BlocksSkies.turquoise_farmland.func_176223_P(), BlocksSkies.turquoise_farmland.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 0, 1, 11, 0, 7, BlocksSkies.turquoise_farmland.func_176223_P(), BlocksSkies.turquoise_farmland.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 0, 0, 12, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 11, 0, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 11, 0, 8, iblockstate, iblockstate, false);
            if (this.structureType == 1) {
                IBlockState fence = this.getBiomeSpecificBlockState(BlocksSkies.starlit_fence.func_176223_P());
                IBlockState slab = this.getBiomeSpecificBlockState(BlocksSkies.starlit_slab.func_176223_P());
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 3, 0, 3, 3, 8, slab, slab, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 0, 3, 2, 8, fence, fence, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 1, 3, 2, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 3, 0, 9, 3, 8, slab, slab, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 9, 2, 8, fence, fence, false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 1, 9, 2, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCrops)this.cropTypeA).func_185526_g();
                int k = j / 3;
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 1, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeA.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k, (int)j)), 2, 1, i, structureBoundingBoxIn);
                int l = ((BlockCrops)this.cropTypeB).func_185526_g();
                int i1 = l / 3;
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 4, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeB.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i1, (int)l)), 5, 1, i, structureBoundingBoxIn);
                int j1 = ((BlockCrops)this.cropTypeC).func_185526_g();
                int k1 = j1 / 3;
                this.func_175811_a(worldIn, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k1, (int)j1)), 7, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeC.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)k1, (int)j1)), 8, 1, i, structureBoundingBoxIn);
                int l1 = ((BlockCrops)this.cropTypeD).func_185526_g();
                int i2 = l1 / 3;
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i2, (int)l1)), 10, 1, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, this.cropTypeD.func_176203_a(MathHelper.func_76136_a((Random)randomIn, (int)i2, (int)l1)), 11, 1, i, structureBoundingBoxIn);
            }
            for (int j2 = 0; j2 < 9; ++j2) {
                for (int k2 = 0; k2 < 13; ++k2) {
                    this.func_74871_b(worldIn, k2, 4, j2, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, BlocksSkies.turquoise_dirt.func_176223_P(), k2, -1, j2, structureBoundingBoxIn);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start start, int type, Random rand, StructureBoundingBox p_i45564_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45564_4_;
        }

        public static Church createPiece(Start start, List<StructureComponent> p_175854_1_, Random rand, int p_175854_3_, int p_175854_4_, int p_175854_5_, EnumFacing facing, int p_175854_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175854_3_, (int)p_175854_4_, (int)p_175854_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (EnumFacing)facing);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175854_1_, (StructureBoundingBox)structureboundingbox) == null ? new Church(start, p_175854_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(worldIn, structureBoundingBoxIn);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            IBlockState iblockstate = BlocksSkies.turquoise_cobblestone.func_176223_P();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(BlocksSkies.turquoise_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 3, 0, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 0, 3, 10, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 10, 3, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 4, 0, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 4, 4, 4, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 8, 3, 4, 8, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 4, 3, 10, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 5, 3, 5, 7, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 9, 0, 4, 9, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 0, 4, 4, 4, iblockstate, iblockstate, false);
            this.func_175811_a(worldIn, iblockstate, 0, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 11, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 11, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 11, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 1, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 3, 1, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 1, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 1, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 1, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 3, 2, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 6, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 7, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 7, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 6, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 7, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 0, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 4, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, BlocksSkies.midnight_glass_pane.func_176223_P(), 2, 3, 8, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.SOUTH, 2, 4, 7, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.EAST, 1, 4, 6, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.WEST, 3, 4, 6, structureBoundingBoxIn);
            this.placeMoonstone(worldIn, EnumFacing.NORTH, 2, 4, 5, structureBoundingBoxIn);
            IBlockState iblockstate4 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST);
            for (int i = 1; i <= 9; ++i) {
                this.func_175811_a(worldIn, iblockstate4, 3, i, 3, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, structureBoundingBoxIn);
            this.createVillageDoor(worldIn, structureBoundingBoxIn, randomIn, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a || this.func_175807_a(worldIn, 2, 0, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.turquoise_tallgrass && this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate1, 2, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 2, -1, -1, structureBoundingBoxIn).func_177230_c() == BlocksSkies.coarse_turquoise_dirt) {
                    this.func_175811_a(worldIn, BlocksSkies.turquoise_grass.func_176223_P(), 2, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.func_74871_b(worldIn, j, 12, k, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, j, -1, k, structureBoundingBoxIn);
                }
            }
            this.spawnVillagers(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }
}

