/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.tile_entities.util;

import com.google.common.base.Objects;
import com.legacy.blue_skies.tile_entities.TileEntityStarlitChest;
import java.lang.ref.WeakReference;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class StarlitDoubleChestItemHandler
extends WeakReference<TileEntityStarlitChest>
implements IItemHandlerModifiable {
    public static final StarlitDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new StarlitDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final TileEntityStarlitChest mainChest;
    private final int hashCode;

    public StarlitDoubleChestItemHandler(TileEntityStarlitChest mainChest, TileEntityStarlitChest other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    public static StarlitDoubleChestItemHandler get(TileEntityStarlitChest chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileEntityStarlitChest)) continue;
            TileEntityStarlitChest otherChest = (TileEntityStarlitChest)otherTE;
            return new StarlitDoubleChestItemHandler(chest, otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public TileEntityStarlitChest getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    private TileEntityStarlitChest getOtherChest() {
        TileEntityStarlitChest TileEntityStarlitChest2 = (TileEntityStarlitChest)((Object)this.get());
        return TileEntityStarlitChest2 != null && !TileEntityStarlitChest2.func_145837_r() ? TileEntityStarlitChest2 : null;
    }

    public int getSlots() {
        return 54;
    }

    public ItemStack getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityStarlitChest chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.func_70301_a(targetSlot) : null;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityStarlitChest chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityStarlitChest chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        TileEntityStarlitChest chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StarlitDoubleChestItemHandler that = (StarlitDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        TileEntityStarlitChest otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.mainChest)) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.getOtherChest()));
        }
        return Objects.equal((Object)((Object)this.mainChest), (Object)((Object)that.getOtherChest())) && Objects.equal((Object)((Object)otherChest), (Object)((Object)that.mainChest));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        TileEntityStarlitChest TileEntityNetherChest = (TileEntityStarlitChest)((Object)this.get());
        return TileEntityNetherChest == null || TileEntityNetherChest.func_145837_r();
    }

    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 27;
        return this.getChest(accessingUpperChest).func_70297_j_();
    }
}

