/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager;

import com.google.common.base.Predicate;
import com.legacy.blue_skies.entities.util.ai.EntityAIAttackRangedBow;
import com.legacy.blue_skies.items.ItemsSkies;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVillagerWarrior
extends EntityGolem
implements IRangedAttackMob {
    public static final DataParameter<Integer> VILLAGER_TYPE = EntityDataManager.func_187226_a(EntityVillagerWarrior.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> AIMING = EntityDataManager.func_187226_a(EntityVillagerWarrior.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ARMORED = EntityDataManager.func_187226_a(EntityVillagerWarrior.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIAttackRangedBow<EntityVillagerWarrior> aiArrowAttack = new EntityAIAttackRangedBow<EntityVillagerWarrior>(this, 1.0, 25, 15.0f);
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
    private int homeCheckTimer;
    Village villageObj;

    public EntityVillagerWarrior(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.func_98053_h(true);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 1, false, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving living) {
                return living != null && IMob.field_175450_e.apply((Object)living) && !(living instanceof EntityCreeper);
            }
        }));
    }

    protected void func_70619_bc() {
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(100);
            this.villageObj = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this), 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos = this.villageObj.func_180608_a();
                this.func_175449_a(blockpos, (int)((float)this.villageObj.func_75568_b() * 0.6f));
            }
        }
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VILLAGER_TYPE, (Object)this.field_70146_Z.nextInt(8));
        this.field_70180_af.func_187214_a(AIMING, (Object)false);
        this.field_70180_af.func_187214_a(ARMORED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("VillagerType", this.getVillagerType());
        compound.func_74757_a("Armored", this.isArmored());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVillagerType(compound.func_74762_e("VillagerType"));
        this.setArmored(compound.func_74767_n("Armored"));
        this.setCombatTask();
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && !(entityIn instanceof EntityCreeper)) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(80) == 0 && this.func_70638_az() == null && this.func_94060_bK() == null) {
            this.func_70691_i(2.0f);
        }
        if (this.func_70638_az() != null && this.func_184614_ca().func_77973_b() == Items.field_151031_f) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), (float)this.func_184649_cE(), (float)this.func_70646_bf());
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityVillager || entityIn instanceof EntityVillagerWarrior || entityIn instanceof EntityGolem) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public Village getVillage() {
        return this.villageObj;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public void setVillagerType(int type) {
        this.field_70180_af.func_187227_b(VILLAGER_TYPE, (Object)type);
    }

    public int getVillagerType() {
        return (Integer)this.field_70180_af.func_187225_a(VILLAGER_TYPE);
    }

    public boolean isArmored() {
        return (Boolean)this.field_70180_af.func_187225_a(ARMORED);
    }

    public void setArmored(boolean isArmored) {
        this.field_70180_af.func_187227_b(ARMORED, (Object)isArmored);
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() == Items.field_151031_f) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(1, this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180483_b(difficulty);
        this.setCombatTask();
        if (!this.field_70170_p.field_72995_K) {
            this.setVillagerType(this.field_70146_Z.nextInt(8));
        }
        return livingdata;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float distanceFactor) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, distanceFactor);
        entitytippedarrow.func_70239_b(6.0);
        return entitytippedarrow;
    }

    public double func_70033_W() {
        return -0.6;
    }

    public void func_70098_U() {
        super.func_70098_U();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(AIMING);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(AIMING, (Object)swingingArms);
    }

    public void randomGear() {
        if (this.getVillagerType() == 8 && !this.field_70170_p.field_72995_K) {
            int c = this.field_70170_p.field_73012_v.nextInt(5);
            if (c == 0) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsSkies.turquoise_helmet));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsSkies.turquoise_chestplate));
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsSkies.turquoise_leggings));
                this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsSkies.turquoise_boots));
                if (this.field_70146_Z.nextInt(4) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsSkies.everbright_turquoise_sword));
                }
            } else if (c == 1) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsSkies.pyrope_helmet));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsSkies.pyrope_chestplate));
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsSkies.pyrope_leggings));
                this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsSkies.pyrope_boots));
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsSkies.everbright_pyrope_sword));
                }
            } else if (c == 2) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
                this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151167_ab));
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                }
            } else if (c == 3) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsSkies.diopside_helmet));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsSkies.diopside_chestplate));
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsSkies.diopside_leggings));
                this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsSkies.diopside_boots));
                if (this.field_70146_Z.nextInt(4) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsSkies.everbright_diopside_sword));
                }
            } else {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
                this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsSkies.everbright_charoite_sword));
                }
            }
            this.setArmored(true);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() instanceof EntityVillagerWarrior) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }
}

