/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.base.Predicate;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.dungeon.BlockSkyKeystone;
import com.legacy.blue_skies.client.particle.ParticleBlackFlame;
import com.legacy.blue_skies.client.sounds.SkiesSounds;
import com.legacy.blue_skies.entities.hostile.boss.summons.EntityDecayingFallingBlock;
import com.legacy.blue_skies.entities.passive.EntityStardustRam;
import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.tile_entities.TileEntityKeystone;
import com.legacy.blue_skies.tile_entities.TileEntityLunarChest;
import com.legacy.blue_skies.variables.SkiesLootTables;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAlchemist
extends EntitySpellcasterIllager {
    public static final DataParameter<Boolean> DUNGEON_SPAWNED = EntityDataManager.func_187226_a(EntityAlchemist.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_HOME = EntityDataManager.func_187226_a(EntityAlchemist.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityAlchemist.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityStardustRam wololoTarget;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186742_b(true);
    private int teleportCooldown;
    private int timeSinceFighting;
    public double homeX;
    public double homeY;
    public double homeZ;

    public EntityAlchemist(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 2.0f);
        this.field_70728_aV = 30;
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 5.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIHealSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIFireArrow());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIFallingBlockSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIPotionCloudSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AILiquidChangeSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIBlindlessSpell());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIWololoSpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityAlchemist.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillagerWarrior.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.getInvulTime() <= 0) {
            super.func_70091_d(type, x, y, z);
        } else {
            super.func_70091_d(type, 0.0, y, 0.0);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DUNGEON_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(HAS_HOME, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public boolean isDungeonSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(DUNGEON_SPAWNED);
    }

    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.field_70180_af.func_187227_b(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    public boolean func_110175_bO() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_HOME);
    }

    public void setHasHome(boolean hasHome) {
        this.field_70180_af.func_187227_b(HAS_HOME, (Object)hasHome);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public static void registerFixesAlchemist(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityAlchemist.class);
    }

    public void func_70609_aI() {
        super.func_70609_aI();
        if (this.isDungeonSpawned() && this.func_110175_bO() && this.field_70725_aQ == 1) {
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY, this.homeZ + 4.0), BlocksSkies.lunar_chest.func_176223_P());
            TileEntity tileentity = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY, this.homeZ + 4.0));
            if (tileentity instanceof TileEntityLunarChest) {
                ((TileEntityLunarChest)tileentity).func_189404_a(SkiesLootTables.alchemist_loot, this.field_70146_Z.nextLong());
                ((TileEntityLunarChest)tileentity).func_190575_a(TextFormatting.LIGHT_PURPLE + "Treasure Chest");
            }
            this.field_70170_p.func_180501_a(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ), BlocksSkies.keystone.func_176223_P().func_177226_a(BlockSkyKeystone.DUNGEON, (Comparable)((Object)BlockSkyKeystone.EnumKeystone.SILVER)), 2);
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY, this.homeZ), BlocksSkies.dungeon_block.func_176203_a(3));
            TileEntity keystone = this.field_70170_p.func_175625_s(new BlockPos(this.homeX, this.homeY + 1.0, this.homeZ));
            if (keystone instanceof TileEntityKeystone) {
                ((TileEntityKeystone)keystone).setDestination(new BlockPos(0, -7, 0));
                ((TileEntityKeystone)keystone).keysRequired = false;
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDungeonSpawned(compound.func_74767_n("DungeonSpawned"));
        this.setHasHome(compound.func_74767_n("HasHome"));
        this.setInvulTime(compound.func_74762_e("Invul"));
        this.homeX = compound.func_74769_h("HomeX");
        this.homeY = compound.func_74769_h("HomeY");
        this.homeZ = compound.func_74769_h("HomeZ");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74780_a("HomeX", this.homeX);
        compound.func_74780_a("HomeY", this.homeY);
        compound.func_74780_a("HomeZ", this.homeZ);
        compound.func_74768_a("Invul", this.getInvulTime());
        compound.func_74757_a("DungeonSpawned", this.isDungeonSpawned());
        compound.func_74757_a("HasHome", this.func_110175_bO());
    }

    public void setHome(double posX, double posY, double posZ) {
        this.homeX = posX;
        this.homeY = posY;
        this.homeZ = posZ;
    }

    protected ResourceLocation func_184647_J() {
        return SkiesLootTables.alchemist;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() == MobEffects.field_76436_u ? false : (effect.func_188419_a() == MobEffects.field_76433_i ? false : (effect.func_188419_a() == MobEffects.field_82731_v ? false : super.func_70687_e(effect)));
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            this.setInvulTime(j1);
        } else {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.func_70638_az() == null && this.isDungeonSpawned() && this.teleportCooldown >= 40 && this.field_70146_Z.nextFloat() * 120.0f < 4.6f) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void healthParticles() {
        if (this.func_110143_aJ() <= 250.0f) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            ParticleBlackFlame particle = new ParticleBlackFlame(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
        } else {
            this.spawnParticles(EnumParticleTypes.END_ROD);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.field_70170_p.field_72995_K) {
            this.healthParticles();
        }
        if (!this.field_70170_p.field_72995_K) {
            List list;
            if (!this.func_193082_dl() && this.func_70090_H() || !this.func_193082_dl() && this.func_180799_ab()) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
            if (this.isDungeonSpawned() && !this.func_175446_cd()) {
                if (this.func_110175_bO()) {
                    this.checkIfHome();
                }
                if (this.func_70638_az() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.func_70638_az();
                    if (player.field_70128_L) {
                        this.func_70634_a(this.homeX, this.homeY, this.homeZ);
                    }
                }
                ++this.teleportCooldown;
            }
            if (this.func_110143_aJ() != 500.0f && this.timeSinceFighting >= 30 && this.isDungeonSpawned() && (list = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 1.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                this.func_70606_j(500.0f);
            }
            if (this.func_70638_az() != null) {
                if ((this.func_70638_az() instanceof EntityPlayer && this.func_70638_az().func_110143_aJ() == 0.0f || this.func_70638_az() instanceof EntityPlayer && this.func_70638_az().field_70128_L && this.isDungeonSpawned()) && !(list = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.homeX - 25.0, this.homeY - 5.0, this.homeZ - 25.0, this.homeX + 25.0, this.homeY + 10.0, this.homeZ + 25.0))).isEmpty()) {
                    this.func_70691_i(30.0f);
                }
                this.timeSinceFighting = 0;
            }
            if (this.field_70737_aN > 0) {
                this.timeSinceFighting = 0;
            }
            if (this.func_70638_az() == null && this.timeSinceFighting <= 201) {
                ++this.timeSinceFighting;
            }
        }
    }

    public void func_70030_z() {
        int playerCount;
        super.func_70030_z();
        if (this.func_70638_az() != null && ((playerCount = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(4.0)).size()) > 0 || (double)this.func_70032_d((Entity)this.func_70638_az()) < 5.0) && !this.func_193082_dl()) {
            this.teleportAround();
        }
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 2.0f, 1.0f);
            }
            double d0 = 0.05;
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.5, 0.0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, d0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, d0, -0.4, -d0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, d0, new int[0]);
                this.field_70170_p.func_175682_a(EnumParticleTypes.END_ROD, true, this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, -d0, -0.4, -d0, new int[0]);
            }
        }
    }

    public void checkIfHome() {
        int distance = 15;
        if (this.field_70165_t > this.homeX + (double)distance || this.field_70161_v > this.homeZ + (double)distance || this.field_70163_u > this.homeY + 10.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), BlocksSkies.lunar_stonebrick.func_176223_P());
        } else if (this.field_70165_t < this.homeX - (double)distance || this.field_70161_v < this.homeZ - (double)distance || this.field_70163_u < this.homeY - 5.0) {
            this.func_70634_a(this.homeX, this.homeY, this.homeZ);
            this.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
            this.func_70656_aK();
            this.field_70170_p.func_175656_a(new BlockPos(this.homeX, this.homeY - 1.0, this.homeZ), BlocksSkies.lunar_stonebrick.func_176223_P());
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && !this.func_193082_dl()) {
            this.teleportAround();
            return false;
        }
        if (source == DamageSource.field_180137_b) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() == this) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            ItemStack stack = player.field_71071_by.func_70448_g();
            boolean isMudkip = stack.func_77973_b().getRegistryName().toString().contains("mudkip");
            if (source.func_180136_u()) {
                return super.func_70097_a(source, amount);
            }
            if (isMudkip) {
                return false;
            }
            if (!source.func_180136_u() && !source.func_76352_a() && (double)source.func_76346_g().func_70032_d((Entity)this) > 3.5) {
                return false;
            }
            return super.func_70097_a(source, Math.min(21.0f, amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void teleportAround() {
        if (this.getInvulTime() <= 0) {
            double d0 = this.field_70165_t;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v;
            for (int i = 0; i < 16; ++i) {
                double d3 = this.field_70165_t + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                double d4 = MathHelper.func_151237_a((double)(this.field_70163_u + (double)(this.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(this.field_70170_p.func_72940_L() - 1));
                double d5 = this.field_70161_v + (this.func_70681_au().nextDouble() - 0.5) * 20.0;
                if (this.func_184218_aH()) {
                    this.func_184210_p();
                }
                if (this.isDungeonSpawned()) {
                    if (!this.attemptDungeonTeleport(d3, d4, d5)) continue;
                    this.field_70170_p.func_184148_a((EntityPlayer)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                    this.func_70656_aK();
                    break;
                }
                if (!this.func_184595_k(d3, d4, d5)) continue;
                this.field_70170_p.func_184148_a((EntityPlayer)null, d0, d1, d2, SoundEvents.field_187544_ad, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                this.func_70656_aK();
                break;
            }
        }
    }

    public boolean attemptDungeonTeleport(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && (double)blockpos.func_177956_o() > this.homeY - 3.0 && (double)blockpos.func_177956_o() <= this.homeY + 1.0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate == BlocksSkies.lunar_stonebrick.func_176223_P() || iblockstate == BlocksSkies.mossy_lunar_stonebrick.func_176223_P() || iblockstate == BlocksSkies.cracked_lunar_stonebrick.func_176223_P()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.CLOUD, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (this instanceof EntityCreature) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityVex) {
            return this.func_184191_r((Entity)((EntityVex)entityIn).func_190645_o());
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.createArrowEntity(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
        EntityArrow arrow2 = this.createArrowEntity(distanceFactor);
        double e0 = target.field_70165_t - this.field_70165_t;
        double e1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow2.field_70163_u;
        double e2 = target.field_70161_v - this.field_70161_v;
        double e3 = MathHelper.func_76133_a((double)(e0 * e0 + e2 * e2));
        arrow2.func_70186_c(e0, e1 + e3 * (double)0.2f, e2 + 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow2);
        EntityArrow arrow3 = this.createArrowEntity(distanceFactor);
        double z0 = target.field_70165_t - this.field_70165_t;
        double z1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow3.field_70163_u;
        double z2 = target.field_70161_v - this.field_70161_v;
        double z3 = MathHelper.func_76133_a((double)(z0 * z0 + z2 * z2));
        arrow3.func_70186_c(z0, z1 + z3 * (double)0.2f, z2 - 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow3);
        if (this.func_110143_aJ() <= 250.0f) {
            EntityArrow arrow4 = this.createArrowEntity(distanceFactor);
            double y0 = target.field_70165_t - this.field_70165_t;
            double y1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow4.field_70163_u - 1.0;
            double y2 = target.field_70161_v - this.field_70161_v;
            double y3 = MathHelper.func_76133_a((double)(y0 * y0 + y2 * y2));
            arrow4.func_70186_c(y0, y1 + y3 * (double)0.2f, y2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            arrow4.func_70015_d(7);
            this.field_70170_p.func_72838_d((Entity)arrow4);
            EntityArrow arrow5 = this.createArrowEntity(distanceFactor);
            double t0 = target.field_70165_t - this.field_70165_t;
            double t1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow5.field_70163_u - 1.0;
            double t2 = target.field_70161_v - this.field_70161_v;
            double t3 = MathHelper.func_76133_a((double)(t0 * t0 + t2 * t2));
            arrow5.func_70186_c(t0, t1 + t3 * (double)0.2f, t2 + 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            arrow5.func_70015_d(7);
            this.field_70170_p.func_72838_d((Entity)arrow5);
            EntityArrow arrow6 = this.createArrowEntity(distanceFactor);
            double u0 = target.field_70165_t - this.field_70165_t;
            double u1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow6.field_70163_u - 1.0;
            double u2 = target.field_70161_v - this.field_70161_v;
            double u3 = MathHelper.func_76133_a((double)(u0 * u0 + u2 * u2));
            arrow6.func_70186_c(u0, u1 + u3 * (double)0.2f, u2 - 4.0, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            arrow6.func_70015_d(7);
            this.field_70170_p.func_72838_d((Entity)arrow6);
        }
    }

    protected EntityArrow createArrowEntity(float p_193097_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_193097_1_);
        entitytippedarrow.func_70239_b(3.0);
        if (this.func_110143_aJ() <= 250.0f) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                entitytippedarrow.func_184558_a(new PotionEffect(MobEffects.field_76421_d, 300));
            }
            entitytippedarrow.func_70239_b(5.0);
        } else {
            entitytippedarrow.func_70239_b(3.0);
        }
        entitytippedarrow.func_70240_a(1);
        return entitytippedarrow;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_ALCHEMIST_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_ALCHEMIST_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SkiesSounds.ENTITY_ALCHEMIST_HURT;
    }

    protected float func_70599_aP() {
        return 1.4f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 1; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    private void setWololoTarget(@Nullable EntityStardustRam p_190748_1_) {
        this.wololoTarget = p_190748_1_;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    private EntityStardustRam getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent func_193086_dk() {
        return SkiesSounds.ENTITY_ALCHEMIST_CAST_SPELL;
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityAlchemist.this.getInvulTime() > 0;
        }
    }

    class AIFireArrow
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIFireArrow() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 200;
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return EntityAlchemist.this.getInvulTime() <= 0;
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntityAlchemist.this.func_70638_az();
            EntityAlchemist.this.attackEntityWithRangedAttack(entitylivingbase, ItemBow.func_185059_b((int)40));
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ATTACK;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)10);
        }
    }

    class AIPotionCloudSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIPotionCloudSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityAlchemist.this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            return EntityAlchemist.this.getInvulTime() <= 0;
        }

        protected int func_190869_f() {
            return 70;
        }

        protected int func_190872_i() {
            return 400;
        }

        public void func_75249_e() {
            this.field_193321_c = this.func_190867_m();
            EntityAlchemist.this.field_193087_b = this.func_190869_f();
            this.field_193322_d = EntityAlchemist.this.field_70173_aa + this.func_190872_i();
            SoundEvent soundevent = this.func_190871_k();
            if (soundevent != null) {
                EntityAlchemist.this.func_184185_a(soundevent, 1.3f, 1.0f);
            }
            MathHelper.func_181159_b((double)(EntityAlchemist.this.func_70638_az().field_70161_v - EntityAlchemist.this.field_70161_v), (double)(EntityAlchemist.this.func_70638_az().field_70165_t - EntityAlchemist.this.field_70165_t));
            EntityAlchemist.this.func_193081_a(this.func_193320_l());
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntityAlchemist.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, EntityAlchemist.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntityAlchemist.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntityAlchemist.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntityAlchemist.this.field_70165_t));
            float f2 = f + 0.7853982f + 1.2566371f;
            this.spawnCloud(EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 3);
            if (this.func_190872_i() < 2) {
                EntityAlchemist.this.teleportAround();
            }
        }

        private void spawnCloud(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            EntityAreaEffectCloud potionCloudPX = new EntityAreaEffectCloud(EntityAlchemist.this.field_70170_p, EntityAlchemist.this.homeX + 5.0, EntityAlchemist.this.homeY, EntityAlchemist.this.homeZ + 5.0);
            EntityAreaEffectCloud potionCloudPZ = new EntityAreaEffectCloud(EntityAlchemist.this.field_70170_p, EntityAlchemist.this.homeX + 5.0, EntityAlchemist.this.homeY, EntityAlchemist.this.homeZ - 5.0);
            EntityAreaEffectCloud potionCloudNX = new EntityAreaEffectCloud(EntityAlchemist.this.field_70170_p, EntityAlchemist.this.homeX - 5.0, EntityAlchemist.this.homeY, EntityAlchemist.this.homeZ + 5.0);
            EntityAreaEffectCloud potionCloudNZ = new EntityAreaEffectCloud(EntityAlchemist.this.field_70170_p, EntityAlchemist.this.homeX - 5.0, EntityAlchemist.this.homeY, EntityAlchemist.this.homeZ - 5.0);
            PotionType potiontype = EntityAlchemist.this.func_110143_aJ() <= 250.0f ? PotionTypes.field_185252_x : PotionTypes.field_185254_z;
            potionCloudPX.func_184484_a(potiontype);
            potionCloudPX.func_184486_b(200);
            potionCloudPX.func_184481_a((EntityLivingBase)EntityAlchemist.this);
            potionCloudPZ.func_184484_a(potiontype);
            potionCloudPZ.func_184486_b(200);
            potionCloudPZ.func_184481_a((EntityLivingBase)EntityAlchemist.this);
            potionCloudNX.func_184484_a(potiontype);
            potionCloudNX.func_184486_b(200);
            potionCloudNX.func_184481_a((EntityLivingBase)EntityAlchemist.this);
            potionCloudNZ.func_184484_a(potiontype);
            potionCloudNZ.func_184486_b(200);
            potionCloudNZ.func_184481_a((EntityLivingBase)EntityAlchemist.this);
            EntityAlchemist.this.field_70170_p.func_72838_d((Entity)potionCloudPX);
            EntityAlchemist.this.field_70170_p.func_72838_d((Entity)potionCloudPZ);
            EntityAlchemist.this.field_70170_p.func_72838_d((Entity)potionCloudNX);
            EntityAlchemist.this.field_70170_p.func_72838_d((Entity)potionCloudNZ);
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_POTIONS;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            if (EntityAlchemist.this.func_110143_aJ() <= 250.0f) {
                return EntitySpellcasterIllager.SpellType.FANGS;
            }
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)11);
        }
    }

    class AIFallingBlockSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIFallingBlockSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 270;
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return EntityAlchemist.this.getInvulTime() <= 0;
        }

        public void func_75249_e() {
            this.field_193321_c = this.func_190867_m();
            EntityAlchemist.this.field_193087_b = this.func_190869_f();
            this.field_193322_d = EntityAlchemist.this.field_70173_aa + this.func_190872_i();
            SoundEvent soundevent = this.func_190871_k();
            if (soundevent != null) {
                EntityAlchemist.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
            float f = (float)MathHelper.func_181159_b((double)(EntityAlchemist.this.func_70638_az().field_70161_v - EntityAlchemist.this.field_70161_v), (double)(EntityAlchemist.this.func_70638_az().field_70165_t - EntityAlchemist.this.field_70165_t));
            if ((double)EntityAlchemist.this.func_70032_d((Entity)EntityAlchemist.this.func_70638_az()) < 9.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    if (!(EntityAlchemist.this.field_70170_p instanceof WorldServer)) continue;
                    ((WorldServer)EntityAlchemist.this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, EntityAlchemist.this.field_70163_u + 5.0, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, 20, (double)(EntityAlchemist.this.field_70130_N / 4.0f), (double)(EntityAlchemist.this.field_70131_O / 4.0f), (double)(EntityAlchemist.this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)BlocksSkies.decaying_spike.func_176223_P())});
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    if (!(EntityAlchemist.this.field_70170_p instanceof WorldServer)) continue;
                    ((WorldServer)EntityAlchemist.this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntityAlchemist.this.field_70163_u + 5.0, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, 20, (double)(EntityAlchemist.this.field_70130_N / 4.0f), (double)(EntityAlchemist.this.field_70131_O / 4.0f), (double)(EntityAlchemist.this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)BlocksSkies.decaying_spike.func_176223_P())});
                }
            }
            EntityAlchemist.this.func_193081_a(this.func_193320_l());
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntityAlchemist.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, EntityAlchemist.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntityAlchemist.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntityAlchemist.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntityAlchemist.this.field_70165_t));
            if ((double)EntityAlchemist.this.func_70032_d((Entity)entitylivingbase) < 9.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    if (EntityAlchemist.this.field_70170_p instanceof WorldServer) {
                        ((WorldServer)EntityAlchemist.this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, EntityAlchemist.this.field_70163_u + 5.0, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, 20, (double)(EntityAlchemist.this.field_70130_N / 4.0f), (double)(EntityAlchemist.this.field_70131_O / 4.0f), (double)(EntityAlchemist.this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)BlocksSkies.decaying_spike.func_176223_P())});
                    }
                    this.spawnSpikeCircle(EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    if (EntityAlchemist.this.field_70170_p instanceof WorldServer) {
                        ((WorldServer)EntityAlchemist.this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntityAlchemist.this.field_70163_u + 5.0, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, 20, (double)(EntityAlchemist.this.field_70130_N / 4.0f), (double)(EntityAlchemist.this.field_70131_O / 4.0f), (double)(EntityAlchemist.this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)BlocksSkies.decaying_spike.func_176223_P())});
                    }
                    this.spawnSpikeLine(EntityAlchemist.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntityAlchemist.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void spawnSpikeLine(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntityAlchemist.this.field_70170_p.func_175677_d(blockpos, true) || !EntityAlchemist.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntityAlchemist.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntityAlchemist.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntityAlchemist.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos(p_190876_1_, (double)blockpos.func_177956_o() + d0 + 5.0, p_190876_3_);
                EntityDecayingFallingBlock block = new EntityDecayingFallingBlock(EntityAlchemist.this.field_70170_p, blockpos2, BlocksSkies.decaying_spike.func_176223_P(), (EntityLivingBase)EntityAlchemist.this);
                block.setUpwards(false);
                EntityAlchemist.this.field_70170_p.func_72838_d((Entity)block);
            }
        }

        private void spawnSpikeCircle(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntityAlchemist.this.field_70170_p.func_175677_d(blockpos, true) || !EntityAlchemist.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntityAlchemist.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntityAlchemist.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntityAlchemist.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                BlockPos blockpos2 = new BlockPos((double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d0 + 5.0, (double)blockpos.func_177952_p() + d0);
                EntityDecayingFallingBlock block = new EntityDecayingFallingBlock(EntityAlchemist.this.field_70170_p, blockpos2, BlocksSkies.decaying_spike.func_176223_P(), (EntityLivingBase)EntityAlchemist.this);
                block.setUpwards(false);
                EntityAlchemist.this.field_70170_p.func_72838_d((Entity)block);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_ROCKS;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)7);
        }
    }

    public class AIBlindlessSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        public AIBlindlessSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityAlchemist.this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            return EntityAlchemist.this.getInvulTime() <= 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            EntityAlchemist.this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0));
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 300;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_BLINDNESS;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.BLINDNESS;
        }
    }

    public class AILiquidChangeSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        public boolean waterParticle;

        public AILiquidChangeSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        public boolean func_75250_a() {
            if (EntityAlchemist.this.func_110143_aJ() > 250.0f) {
                return false;
            }
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityAlchemist.this.field_70146_Z.nextInt(2) != 0) {
                return false;
            }
            return EntityAlchemist.this.getInvulTime() <= 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int var7;
            int var6;
            int var5;
            int var4;
            int var1 = MathHelper.func_76128_c((double)EntityAlchemist.this.homeX);
            int var2 = MathHelper.func_76128_c((double)EntityAlchemist.this.homeZ);
            int radius = 25;
            boolean isWater = EntityAlchemist.this.field_70146_Z.nextBoolean();
            for (var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
                for (var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                    for (var6 = 0; var6 < 8; ++var6) {
                        var7 = (int)EntityAlchemist.this.homeY - 1 + var6;
                        if (!(EntityAlchemist.this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_177230_c() instanceof BlockLiquid)) continue;
                        if ((Integer)EntityAlchemist.this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                            EntityAlchemist.this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), Blocks.field_180401_cv.func_176223_P());
                            continue;
                        }
                        EntityAlchemist.this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            for (var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
                for (var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                    for (var6 = 0; var6 < 8; ++var6) {
                        var7 = (int)EntityAlchemist.this.homeY - 1 + var6;
                        if (!(EntityAlchemist.this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_177230_c() instanceof BlockBarrier)) continue;
                        IBlockState liquid = isWater ? Blocks.field_150358_i.func_176223_P() : Blocks.field_150356_k.func_176223_P();
                        SoundEvent sound = isWater ? SoundEvents.field_187624_K : SoundEvents.field_187627_L;
                        EntityAlchemist.this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), liquid.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(0)));
                        EntityAlchemist.this.field_70170_p.func_184134_a(EntityAlchemist.this.field_70165_t, EntityAlchemist.this.field_70163_u, EntityAlchemist.this.field_70161_v, sound, SoundCategory.BLOCKS, 2.0f, EntityAlchemist.this.field_70146_Z.nextFloat() - EntityAlchemist.this.field_70146_Z.nextFloat() * 0.2f + 1.2f, false);
                    }
                }
            }
        }

        protected int func_190867_m() {
            return 30;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 90;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_CONVERSION;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)12);
        }
    }

    public class AIHealSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        public AIHealSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityAlchemist.this.func_110143_aJ() > 250.0f) {
                return false;
            }
            return EntityAlchemist.this.getInvulTime() <= 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int playerCount = EntityAlchemist.this.field_70170_p.func_72872_a(EntityPlayer.class, EntityAlchemist.this.func_174813_aQ().func_186662_g(35.0)).size();
            if (playerCount < 2) {
                EntityAlchemist.this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 50, 4, false, false));
            } else {
                EntityAlchemist.this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 25, 5, false, false));
            }
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 200;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_ALCHEMIST_PREPARE_REGEN;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.func_193337_a((int)6);
        }
    }

    public class AIWololoSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        final Predicate<EntityStardustRam> wololoSelector;

        public AIWololoSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
            this.wololoSelector = new Predicate<EntityStardustRam>(){

                public boolean apply(EntityStardustRam p_apply_1_) {
                    return p_apply_1_.getFleeceColor() == EnumDyeColor.RED;
                }
            };
        }

        public boolean func_75250_a() {
            if (EntityAlchemist.this.func_70638_az() != null) {
                return false;
            }
            if (EntityAlchemist.this.func_193082_dl()) {
                return false;
            }
            if (EntityAlchemist.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (EntityAlchemist.this.getInvulTime() > 0) {
                return false;
            }
            if (!EntityAlchemist.this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            List list = EntityAlchemist.this.field_70170_p.func_175647_a(EntityStardustRam.class, EntityAlchemist.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.wololoSelector);
            if (list.isEmpty()) {
                return false;
            }
            EntityAlchemist.this.setWololoTarget((EntityStardustRam)((Object)list.get(EntityAlchemist.this.field_70146_Z.nextInt(list.size()))));
            return true;
        }

        public boolean func_75253_b() {
            return EntityAlchemist.this.getWololoTarget() != null && this.field_193321_c > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityAlchemist.this.setWololoTarget(null);
        }

        protected void func_190868_j() {
            EntityStardustRam entitysheep = EntityAlchemist.this.getWololoTarget();
            if (entitysheep != null && entitysheep.func_70089_S()) {
                entitysheep.setFleeceColor(EnumDyeColor.BLUE);
            }
        }

        protected int func_190867_m() {
            return 40;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 120;
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191249_bs;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.WOLOLO;
        }

        public boolean isNonBoss() {
            return false;
        }
    }

    class AICastingSpell
    extends EntitySpellcasterIllager.AICastingApell {
        private AICastingSpell() {
            super((EntitySpellcasterIllager)EntityAlchemist.this);
        }

        public void func_75246_d() {
            if (EntityAlchemist.this.func_70638_az() != null) {
                EntityAlchemist.this.func_70671_ap().func_75651_a((Entity)EntityAlchemist.this.func_70638_az(), (float)EntityAlchemist.this.func_184649_cE(), (float)EntityAlchemist.this.func_70646_bf());
            } else if (EntityAlchemist.this.getWololoTarget() != null) {
                EntityAlchemist.this.func_70671_ap().func_75651_a((Entity)EntityAlchemist.this.getWololoTarget(), (float)EntityAlchemist.this.func_184649_cE(), (float)EntityAlchemist.this.func_70646_bf());
            }
        }
    }
}

