/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.client.sounds.SkiesSounds;
import com.legacy.blue_skies.entities.util.EntityFlyingMob;
import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.variables.SkiesLootTables;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityNyctoBug
extends EntityFlyingMob
implements IMob {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int ticksUntilFlap;
    private int idleTime;

    public EntityNyctoBug(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70728_aV = 5;
        this.func_189654_d(true);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)1.7f, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityNyctoBug.class}));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillagerWarrior.class, true));
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateWingRotation();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_70638_az() != null) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            this.field_70714_bg.func_85156_a((EntityAIBase)new AIRandomFly(this));
            this.func_70619_bc();
        } else if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
            this.func_70619_bc();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.idleTime = this.field_70159_w <= 1.0 && this.field_70179_y <= 1.0 && this.idleTime <= 100 ? ++this.idleTime : 0;
        } else if (this.field_70122_E) {
            this.field_70122_E = false;
        }
    }

    public void updateWingRotation() {
        if (this.ticksUntilFlap == 0 && this.func_110143_aJ() > 0.0f) {
            if (!this.func_174814_R()) {
                this.func_184185_a(SkiesSounds.ENTITY_NYCTOBUG_FLYING, 1.3f, 1.0f);
            }
            this.ticksUntilFlap = 25;
        } else {
            --this.ticksUntilFlap;
        }
        if (this.func_110143_aJ() == 0.0f) {
            this.ticksUntilFlap = 0;
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = EntityNyctoBug.minMax(0.01f, 1.0f, this.destPos);
        this.wingRotation += 1.233f;
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public boolean func_70652_k(Entity entityIn) {
        entityIn.func_70097_a((DamageSource)new EntityDamageSource("bite", (Entity)this), 3.0f);
        this.func_184185_a(SkiesSounds.ENTITY_NYCTOBUG_BITE, 0.5f, 1.0f);
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_NYCTOBUG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_NYCTOBUG_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return SkiesLootTables.nycto_bug;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(400) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public static void registerFixesBug(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityNyctoBug.class);
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityNyctoBug bug) {
            super((EntityLiving)bug);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityNyctoBug.this.field_70165_t;
                double d1 = this.field_75647_c - EntityNyctoBug.this.field_70163_u;
                double d2 = this.field_75644_d - EntityNyctoBug.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                EntityNyctoBug.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                EntityNyctoBug.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                EntityNyctoBug.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                if (EntityNyctoBug.this.func_70638_az() == null) {
                    EntityNyctoBug.this.field_70761_aq = EntityNyctoBug.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityNyctoBug.this.field_70159_w, (double)EntityNyctoBug.this.field_70179_y)) * 57.295776f;
                    if (EntityNyctoBug.this.field_70124_G && EntityNyctoBug.this.field_70173_aa > 100) {
                        EntityNyctoBug.this.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
                    }
                    if (EntityNyctoBug.this.idleTime >= 300 || !this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3)) {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                } else {
                    double d4 = EntityNyctoBug.this.func_70638_az().field_70165_t - EntityNyctoBug.this.field_70165_t;
                    double d5 = EntityNyctoBug.this.func_70638_az().field_70161_v - EntityNyctoBug.this.field_70161_v;
                    EntityNyctoBug.this.field_70761_aq = EntityNyctoBug.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - EntityNyctoBug.this.field_70165_t) / p_179926_7_;
            double d1 = (y - EntityNyctoBug.this.field_70163_u) / p_179926_7_;
            double d2 = (z - EntityNyctoBug.this.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = EntityNyctoBug.this.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!EntityNyctoBug.this.field_70170_p.func_184144_a((Entity)EntityNyctoBug.this, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityNyctoBug parentEntity;

        public AIRandomFly(EntityNyctoBug bug) {
            this.parentEntity = bug;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a() && this.parentEntity.func_70638_az() == null) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityNyctoBug parentEntity;

        public AILookAround(EntityNyctoBug bug) {
            this.parentEntity = bug;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                if ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

