/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.sounds.music;

import com.legacy.blue_skies.SkiesConfig;
import com.legacy.blue_skies.client.sounds.SkiesSounds;
import com.legacy.blue_skies.world.everbright.EverbrightWorldProvider;
import com.legacy.blue_skies.world.everdawn.EverdawnWorldProvider;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SkiesMusicTicker
implements ITickable {
    private final Random rand = new Random();
    private final Minecraft mc;
    public ISound ambientMusic;
    public ISound bossMusic;
    public ISound playingRecord;
    private int timeUntilNextMusic = 100;

    public SkiesMusicTicker(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void func_73660_a() {
        boolean boss;
        TrackType tracktypeB = this.getRandomTrackBright();
        TrackType tracktypeD = this.getRandomTrackDawn();
        TrackType bosstrack = this.getBossTrack();
        boolean bl = boss = this.mc.field_71456_v.func_184046_j().func_184054_d() && SkiesConfig.other.bossMusic;
        if (this.mc.field_71439_g != null && !this.mc.func_147118_V().func_147692_c(this.playingRecord)) {
            if (boss && (this.mc.field_71439_g.field_70170_p.field_73011_w instanceof EverbrightWorldProvider || this.mc.field_71439_g.field_70170_p.field_73011_w instanceof EverdawnWorldProvider)) {
                if (this.ambientMusic != null) {
                    this.stopMusic();
                }
                if (this.bossMusic != null && !this.mc.func_147118_V().func_147692_c(this.bossMusic)) {
                    this.bossMusic = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)bosstrack.getMinDelay(), (int)bosstrack.getMaxDelay()), this.timeUntilNextMusic);
                }
                this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, bosstrack.getMaxDelay());
                if (this.bossMusic == null && this.timeUntilNextMusic-- <= 0) {
                    this.playBossMusic(bosstrack);
                }
            } else if (this.mc.field_71439_g.field_70170_p.field_73011_w instanceof EverbrightWorldProvider) {
                if (this.bossMusic != null) {
                    this.stopBossMusic();
                }
                if (this.ambientMusic != null && !this.mc.func_147118_V().func_147692_c(this.ambientMusic)) {
                    this.ambientMusic = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)tracktypeB.getMinDelay(), (int)tracktypeB.getMaxDelay()), this.timeUntilNextMusic);
                }
                this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, tracktypeB.getMaxDelay());
                if (this.ambientMusic == null && this.timeUntilNextMusic-- <= 0) {
                    this.playMusic(tracktypeB);
                }
            } else if (this.mc.field_71439_g.field_70170_p.field_73011_w instanceof EverdawnWorldProvider) {
                if (this.bossMusic != null) {
                    this.stopBossMusic();
                }
                if (this.ambientMusic != null && !this.mc.func_147118_V().func_147692_c(this.ambientMusic)) {
                    this.ambientMusic = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)tracktypeD.getMinDelay(), (int)tracktypeD.getMaxDelay()), this.timeUntilNextMusic);
                }
                this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, tracktypeD.getMaxDelay());
                if (this.ambientMusic == null && this.timeUntilNextMusic-- <= 0) {
                    this.playMusic(tracktypeD);
                }
            } else {
                this.stopMusic();
            }
        }
    }

    public boolean playingMusic() {
        return this.ambientMusic != null;
    }

    public boolean playingRecord() {
        return this.playingRecord != null;
    }

    public TrackType getRandomTrackBright() {
        int num = this.rand.nextInt(5);
        return num == 0 ? TrackType.BRISEGEL : (num == 1 ? TrackType.TURQUOISE : (num == 2 ? TrackType.SNOWCAP : (num == 3 ? TrackType.BRIGHTLANDS : TrackType.DEVON)));
    }

    public TrackType getRandomTrackDawn() {
        int num = this.rand.nextInt(3);
        return num == 0 ? TrackType.MOONLIT_BLOOM : (num == 1 ? TrackType.BANEFUL : TrackType.MARS);
    }

    public TrackType getBossTrack() {
        return TrackType.ILLAGER_BOSS;
    }

    public void playMusic(TrackType requestedMusicType) {
        this.ambientMusic = PositionedSoundRecord.func_184370_a((SoundEvent)requestedMusicType.getMusicLocation());
        this.mc.func_147118_V().func_147682_a(this.ambientMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void stopMusic() {
        if (this.ambientMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.ambientMusic);
            this.ambientMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    public void playBossMusic(TrackType requestedMusicType) {
        this.bossMusic = PositionedSoundRecord.func_184370_a((SoundEvent)requestedMusicType.getMusicLocation());
        this.mc.func_147118_V().func_147682_a(this.bossMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void stopBossMusic() {
        if (this.bossMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.bossMusic);
            this.bossMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum TrackType {
        MARS(SkiesSounds.MUSIC_MARS, 1200, 1500),
        MOONLIT_BLOOM(SkiesSounds.MUSIC_MOONLIT_BLOOM, 1200, 1500),
        DEVON(SkiesSounds.MUSIC_DEVON, 1200, 1500),
        BRISEGEL(SkiesSounds.MUSIC_BRISEGEL, 1200, 1500),
        TURQUOISE(SkiesSounds.MUSIC_TURQUOISE, 1200, 1500),
        SNOWCAP(SkiesSounds.MUSIC_SNOWCAP, 1200, 1500),
        BANEFUL(SkiesSounds.MUSIC_BANEFUL, 1200, 1500),
        BRIGHTLANDS(SkiesSounds.MUSIC_BRIGHTLANDS, 1200, 1500),
        ILLAGER_BOSS(SkiesSounds.MUSIC_ILLAGER_BOSS, 0, 0);

        private final SoundEvent musicLocation;
        private final int minDelay;
        private final int maxDelay;

        private TrackType(SoundEvent musicLocationIn, int minDelayIn, int maxDelayIn) {
            this.musicLocation = musicLocationIn;
            this.minDelay = minDelayIn;
            this.maxDelay = maxDelayIn;
        }

        public SoundEvent getMusicLocation() {
            return this.musicLocation;
        }

        public int getMinDelay() {
            return this.minDelay;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }
    }
}

