/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.color;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IRegistryDelegate;

@SideOnly(value=Side.CLIENT)
public class SkiesColors {
    private final Map<IRegistryDelegate<Block>, IBlockColor> blockColorMap = Maps.newHashMap();

    public static void init() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ForgeHooksClient.onBlockColorsInit((BlockColors)blockColors);
    }

    public int getColor(IBlockState state, World world, BlockPos pos) {
        IBlockColor iblockcolor = this.blockColorMap.get(state.func_177230_c().delegate);
        if (iblockcolor != null) {
            return iblockcolor.func_186720_a(state, (IBlockAccess)null, (BlockPos)null, 0);
        }
        MapColor mapColor = state.func_185909_g((IBlockAccess)world, pos);
        return mapColor != null ? mapColor.field_76291_p : -1;
    }

    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess blockAccess, @Nullable BlockPos pos, int renderPass) {
        IBlockColor iBlockColor = this.blockColorMap.get(state.func_177230_c().delegate);
        return iBlockColor == null ? -1 : iBlockColor.func_186720_a(state, blockAccess, pos, renderPass);
    }

    public void registerBlockColorHandler(IBlockColor blockColor, Block ... blocksIn) {
        for (Block block : blocksIn) {
            if (block == null) continue;
            this.blockColorMap.put((IRegistryDelegate<Block>)block.delegate, blockColor);
        }
    }
}

